/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap.mapping;

import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapsStorage;
import com.intellij.openapi.editor.impl.softwrap.mapping.AbstractMappingStrategy;
import com.intellij.openapi.editor.impl.softwrap.mapping.CacheEntry;
import com.intellij.openapi.editor.impl.softwrap.mapping.EditorPosition;
import com.intellij.openapi.editor.impl.softwrap.mapping.MappingUtil;
import com.intellij.openapi.editor.impl.softwrap.mapping.TabData;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LogicalToOffsetCalculationStrategy
extends AbstractMappingStrategy<Integer> {
    private LogicalPosition targetPosition;

    LogicalToOffsetCalculationStrategy(@NotNull EditorEx editor, @NotNull SoftWrapsStorage storage2, @NotNull List<CacheEntry> cache) {
        super(editor, storage2, cache);
    }

    void init(LogicalPosition logical) {
        CacheEntry entry = MappingUtil.getCacheEntryForLogicalPosition(logical, this.myCache);
        if (entry == null) {
            if (logical.line >= this.myEditor.getDocument().getLineCount()) {
                this.setEagerMatch(this.myEditor.getDocument().getTextLength());
            } else {
                this.setEagerMatch(Math.min(this.myEditor.getDocument().getLineStartOffset(logical.line) + logical.column, this.myEditor.getDocument().getLineEndOffset(logical.line)));
            }
            return;
        }
        if (entry.endLogicalLine == logical.line && entry.endLogicalColumn <= logical.column) {
            this.setEagerMatch(entry.endOffset);
            return;
        }
        this.reset();
        this.targetPosition = logical;
        this.setTargetEntry(entry, true);
    }

    @Override
    @Nullable
    protected Integer buildIfExceeds(EditorPosition position, int offset) {
        if (position.logicalLine != this.targetPosition.line) {
            return null;
        }
        int result = position.offset + this.targetPosition.column - position.logicalColumn;
        return result > offset ? null : Integer.valueOf(result);
    }

    @Override
    public Integer processFoldRegion(@NotNull EditorPosition position, @NotNull FoldRegion foldRegion) {
        int startLine = position.logicalLine;
        int startColumn = position.logicalColumn;
        int startX = position.x;
        this.advancePositionOnFolding(position, foldRegion);
        if (position.logicalLine < this.targetPosition.line || position.logicalLine == this.targetPosition.line && position.logicalColumn <= this.targetPosition.column) {
            return null;
        }
        DocumentEx document = this.myEditor.getDocument();
        int lineEndOffset = document.getLineEndOffset(this.targetPosition.line);
        int result = SoftWrapModelImpl.getEditorTextRepresentationHelper(this.myEditor).calcSoftWrapUnawareOffset(this.targetPosition.line == startLine ? foldRegion.getStartOffset() : document.getLineStartOffset(this.targetPosition.line), lineEndOffset, this.targetPosition.line == startLine ? startColumn : 0, this.targetPosition.column, this.targetPosition.line == startLine ? startX : 0);
        return result < 0 ? lineEndOffset : result;
    }

    @Override
    @Nullable
    protected Integer buildIfExceeds(@NotNull EditorPosition position, @NotNull FoldRegion foldRegion) {
        throw new RuntimeException("Unexpected invocation");
    }

    @Override
    @Nullable
    protected Integer buildIfExceeds(EditorPosition position, TabData tabData) {
        if (position.logicalLine != this.targetPosition.line) {
            return null;
        }
        return position.logicalColumn + tabData.widthInColumns > this.targetPosition.column ? Integer.valueOf(position.offset) : null;
    }

    @Override
    @Nullable
    public Integer processSoftWrap(@NotNull EditorPosition position, SoftWrap softWrap) {
        return null;
    }

    @Override
    @NotNull
    public Integer build(@NotNull EditorPosition position) {
        return position.offset + this.targetPosition.column - position.logicalColumn;
    }
}

