/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap.mapping;

import com.intellij.openapi.editor.impl.softwrap.mapping.DataProvider;
import com.intellij.openapi.util.Pair;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class CompositeDataProvider {
    private final DataProvider<? extends Comparable<?>, ?>[] myProviders;

    public CompositeDataProvider(DataProvider<? extends Comparable<?>, ?> ... providers) {
        for (int i = 0; i < providers.length; ++i) {
            DataProvider<Comparable<?>, ?> provider = providers[i];
            if (provider.getData() != null) continue;
            providers[i] = null;
        }
        this.myProviders = providers;
        this.sort();
    }

    public boolean hasData() {
        for (DataProvider<Comparable<?>, ?> dataProvider : this.myProviders) {
            if (dataProvider == null) continue;
            return true;
        }
        return false;
    }

    public void advance(int sortingKey) {
        for (int i = 0; i < this.myProviders.length; ++i) {
            DataProvider<Comparable<?>, ?> provider = this.myProviders[i];
            if (provider == null) continue;
            provider.advance(sortingKey);
            if (provider.getData() != null) continue;
            this.myProviders[i] = null;
        }
        this.sort();
    }

    @NotNull
    public <K, V> Pair<K, V> getData() throws IllegalStateException {
        if (!this.hasData()) {
            throw new IllegalStateException("No more data is available within the current provider.");
        }
        DataProvider<Comparable<?>, ?> provider = this.myProviders[0];
        Pair<? extends Comparable<?>, ?> result = provider.getData();
        if (result == null) {
            throw new IllegalStateException(String.format("Programming error detected - registered data provider doesn't have data (%s). Registered providers: %s", provider, Arrays.toString(this.myProviders)));
        }
        return result;
    }

    public int getSortingKey() throws IllegalStateException {
        if (!this.hasData()) {
            throw new IllegalStateException("No more data is available within the current provider");
        }
        return this.myProviders[0].getSortingKey();
    }

    public boolean next() {
        if (!this.hasData()) {
            return false;
        }
        DataProvider<Comparable<?>, ?> provider = this.myProviders[0];
        if (!provider.next()) {
            this.myProviders[0] = null;
        }
        if (this.hasData()) {
            this.sort();
            return true;
        }
        return false;
    }

    private void sort() {
        if (this.myProviders.length <= 0) {
            return;
        }
        int i = 0;
        DataProvider<Comparable<?>, ?> dataProvider = this.myProviders[0];
        for (int j = 1; j < this.myProviders.length; ++j) {
            DataProvider<Comparable<?>, ?> candidate = this.myProviders[j];
            if (candidate == null || dataProvider != null && CompositeDataProvider.compare(dataProvider, candidate) <= 0) continue;
            i = j;
            dataProvider = candidate;
        }
        if (i > 0) {
            this.myProviders[i] = this.myProviders[0];
            this.myProviders[0] = dataProvider;
        }
    }

    private static int compare(DataProvider<? extends Comparable<?>, ?> o1, DataProvider<? extends Comparable<?>, ?> o2) {
        int result = o1.getSortingKey() - o2.getSortingKey();
        if (result != 0) {
            return result;
        }
        Pair<? extends Comparable<?>, ?> d1 = o1.getData();
        Pair<? extends Comparable<?>, ?> d2 = o2.getData();
        if (d1 != null && d2 != null) {
            return ((Comparable)d1.first).compareTo(d2.first);
        }
        return result;
    }
}

