/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap.mapping;

import com.intellij.openapi.editor.impl.softwrap.mapping.AbstractDataProvider;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractListBasedDataProvider<K extends Comparable<? super K>, V>
extends AbstractDataProvider<K, V> {
    private final List<V> myData;
    private int myIndex;

    public AbstractListBasedDataProvider(@NotNull K key, @NotNull List<V> data) {
        super(key);
        this.myData = data;
    }

    @Override
    protected V doGetData() {
        if (this.myIndex < this.myData.size()) {
            return this.myData.get(this.myIndex);
        }
        return null;
    }

    @Override
    public boolean next() {
        return ++this.myIndex < this.myData.size();
    }

    @Override
    public void advance(int sortingKey) {
        int start = this.myIndex;
        int end = this.myData.size() - 1;
        while (start <= end) {
            int i = end + start >>> 1;
            V data = this.myData.get(i);
            if (this.getSortingKey(data) < sortingKey) {
                start = i + 1;
                continue;
            }
            if (this.getSortingKey(data) > sortingKey) {
                end = i - 1;
                continue;
            }
            this.myIndex = i;
            return;
        }
        this.myIndex = start;
    }

    @Override
    public int getSortingKey() {
        if (this.myIndex < this.myData.size()) {
            return this.getSortingKey(this.myData.get(this.myIndex));
        }
        return 0;
    }

    protected abstract int getSortingKey(@NotNull V var1);
}

