/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.event;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditReadOnlyListener;
import com.intellij.openapi.editor.ex.EditorEventMulticasterEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.ErrorStripeListener;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.util.EventDispatcher;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class EditorEventMulticasterImpl
implements EditorEventMulticasterEx {
    private final EventDispatcher<DocumentListener> myDocumentMulticaster = EventDispatcher.create(DocumentListener.class);
    private final EventDispatcher<EditReadOnlyListener> myEditReadOnlyMulticaster = EventDispatcher.create(EditReadOnlyListener.class);
    private final EventDispatcher<EditorMouseListener> myEditorMouseMulticaster = EventDispatcher.create(EditorMouseListener.class);
    private final EventDispatcher<EditorMouseMotionListener> myEditorMouseMotionMulticaster = EventDispatcher.create(EditorMouseMotionListener.class);
    private final EventDispatcher<ErrorStripeListener> myErrorStripeMulticaster = EventDispatcher.create(ErrorStripeListener.class);
    private final EventDispatcher<CaretListener> myCaretMulticaster = EventDispatcher.create(CaretListener.class);
    private final EventDispatcher<SelectionListener> mySelectionMulticaster = EventDispatcher.create(SelectionListener.class);
    private final EventDispatcher<VisibleAreaListener> myVisibleAreaMulticaster = EventDispatcher.create(VisibleAreaListener.class);
    private final EventDispatcher<PropertyChangeListener> myPropertyChangeMulticaster = EventDispatcher.create(PropertyChangeListener.class);
    private final EventDispatcher<FocusChangeListener> myFocusChangeListenerMulticaster = EventDispatcher.create(FocusChangeListener.class);

    public void registerDocument(@NotNull DocumentEx document) {
        document.addDocumentListener((DocumentListener)this.myDocumentMulticaster.getMulticaster());
        document.addEditReadOnlyListener((EditReadOnlyListener)this.myEditReadOnlyMulticaster.getMulticaster());
    }

    public void registerEditor(@NotNull EditorEx editor) {
        editor.addEditorMouseListener((EditorMouseListener)this.myEditorMouseMulticaster.getMulticaster());
        editor.addEditorMouseMotionListener((EditorMouseMotionListener)this.myEditorMouseMotionMulticaster.getMulticaster());
        ((EditorMarkupModel)((Object)editor.getMarkupModel())).addErrorMarkerListener((ErrorStripeListener)this.myErrorStripeMulticaster.getMulticaster(), ((EditorImpl)editor).getDisposable());
        editor.getCaretModel().addCaretListener((CaretListener)this.myCaretMulticaster.getMulticaster());
        editor.getSelectionModel().addSelectionListener((SelectionListener)this.mySelectionMulticaster.getMulticaster());
        editor.getScrollingModel().addVisibleAreaListener((VisibleAreaListener)this.myVisibleAreaMulticaster.getMulticaster());
        editor.addPropertyChangeListener((PropertyChangeListener)this.myPropertyChangeMulticaster.getMulticaster());
        editor.addFocusListener((FocusChangeListener)this.myFocusChangeListenerMulticaster.getMulticaster());
    }

    public void addDocumentListener(@NotNull DocumentListener listener2) {
        this.myDocumentMulticaster.addListener((EventListener)listener2);
    }

    public void addDocumentListener(@NotNull DocumentListener listener2, @NotNull Disposable parentDisposable) {
        this.myDocumentMulticaster.addListener((EventListener)listener2, parentDisposable);
    }

    public void removeDocumentListener(@NotNull DocumentListener listener2) {
        this.myDocumentMulticaster.removeListener((EventListener)listener2);
    }

    public void addEditorMouseListener(@NotNull EditorMouseListener listener2) {
        this.myEditorMouseMulticaster.addListener((EventListener)listener2);
    }

    public void addEditorMouseListener(@NotNull EditorMouseListener listener2, @NotNull Disposable parentDisposable) {
        this.myEditorMouseMulticaster.addListener((EventListener)listener2, parentDisposable);
    }

    public void removeEditorMouseListener(@NotNull EditorMouseListener listener2) {
        this.myEditorMouseMulticaster.removeListener((EventListener)listener2);
    }

    public void addEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener2) {
        this.myEditorMouseMotionMulticaster.addListener((EventListener)listener2);
    }

    public void addEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener2, @NotNull Disposable parentDisposable) {
        this.myEditorMouseMotionMulticaster.addListener((EventListener)listener2, parentDisposable);
    }

    public void removeEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener2) {
        this.myEditorMouseMotionMulticaster.removeListener((EventListener)listener2);
    }

    public void addCaretListener(@NotNull CaretListener listener2) {
        this.myCaretMulticaster.addListener((EventListener)listener2);
    }

    public void addCaretListener(@NotNull CaretListener listener2, @NotNull Disposable parentDisposable) {
        this.myCaretMulticaster.addListener((EventListener)listener2, parentDisposable);
    }

    public void removeCaretListener(@NotNull CaretListener listener2) {
        this.myCaretMulticaster.removeListener((EventListener)listener2);
    }

    public void addSelectionListener(@NotNull SelectionListener listener2) {
        this.mySelectionMulticaster.addListener((EventListener)listener2);
    }

    public void addSelectionListener(@NotNull SelectionListener listener2, @NotNull Disposable parentDisposable) {
        this.mySelectionMulticaster.addListener((EventListener)listener2, parentDisposable);
    }

    public void removeSelectionListener(@NotNull SelectionListener listener2) {
        this.mySelectionMulticaster.removeListener((EventListener)listener2);
    }

    @Override
    public void addErrorStripeListener(@NotNull ErrorStripeListener listener2) {
        this.myErrorStripeMulticaster.addListener((EventListener)listener2);
    }

    @Override
    public void addErrorStripeListener(@NotNull ErrorStripeListener listener2, @NotNull Disposable parentDisposable) {
        this.myErrorStripeMulticaster.addListener((EventListener)listener2, parentDisposable);
    }

    @Override
    public void removeErrorStripeListener(@NotNull ErrorStripeListener listener2) {
        this.myErrorStripeMulticaster.removeListener((EventListener)listener2);
    }

    public void addVisibleAreaListener(@NotNull VisibleAreaListener listener2) {
        this.myVisibleAreaMulticaster.addListener((EventListener)listener2);
    }

    public void removeVisibleAreaListener(@NotNull VisibleAreaListener listener2) {
        this.myVisibleAreaMulticaster.removeListener((EventListener)listener2);
    }

    @Override
    public void addEditReadOnlyListener(@NotNull EditReadOnlyListener listener2) {
        this.myEditReadOnlyMulticaster.addListener((EventListener)listener2);
    }

    @Override
    public void removeEditReadOnlyListener(@NotNull EditReadOnlyListener listener2) {
        this.myEditReadOnlyMulticaster.removeListener((EventListener)listener2);
    }

    @Override
    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        this.myPropertyChangeMulticaster.addListener((EventListener)listener2);
    }

    @Override
    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        this.myPropertyChangeMulticaster.removeListener((EventListener)listener2);
    }

    @Override
    public void addFocusChangeListner(@NotNull FocusChangeListener listener2) {
        this.myFocusChangeListenerMulticaster.addListener((EventListener)listener2);
    }

    @Override
    public void addFocusChangeListner(@NotNull FocusChangeListener listener2, @NotNull Disposable parentDisposable) {
        this.myFocusChangeListenerMulticaster.addListener((EventListener)listener2, parentDisposable);
    }

    @Override
    public void removeFocusChangeListner(@NotNull FocusChangeListener listener2) {
        this.myFocusChangeListenerMulticaster.removeListener((EventListener)listener2);
    }

    public Map<Class, List> getListeners() {
        LinkedHashMap<Class, List> myCopy = new LinkedHashMap<Class, List>();
        myCopy.put(DocumentListener.class, new ArrayList(this.myDocumentMulticaster.getListeners()));
        myCopy.put(EditReadOnlyListener.class, new ArrayList(this.myEditReadOnlyMulticaster.getListeners()));
        myCopy.put(EditorMouseListener.class, new ArrayList(this.myEditorMouseMulticaster.getListeners()));
        myCopy.put(EditorMouseMotionListener.class, new ArrayList(this.myEditorMouseMotionMulticaster.getListeners()));
        myCopy.put(ErrorStripeListener.class, new ArrayList(this.myErrorStripeMulticaster.getListeners()));
        myCopy.put(CaretListener.class, new ArrayList(this.myCaretMulticaster.getListeners()));
        myCopy.put(SelectionListener.class, new ArrayList(this.mySelectionMulticaster.getListeners()));
        myCopy.put(VisibleAreaListener.class, new ArrayList(this.myVisibleAreaMulticaster.getListeners()));
        myCopy.put(PropertyChangeListener.class, new ArrayList(this.myPropertyChangeMulticaster.getListeners()));
        myCopy.put(FocusChangeListener.class, new ArrayList(this.myFocusChangeListenerMulticaster.getListeners()));
        return myCopy;
    }
}

