/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.diagnostic.Dumpable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.PrioritizedInternalDocumentListener;
import com.intellij.openapi.editor.ex.SoftWrapChangeListener;
import com.intellij.openapi.editor.ex.SoftWrapModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.CaretModelImpl;
import com.intellij.openapi.editor.impl.DefaultEditorTextRepresentationHelper;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.EditorTextRepresentationHelper;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.VisualSizeChangeListener;
import com.intellij.openapi.editor.impl.softwrap.CompositeSoftWrapPainter;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapDrawingType;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapPainter;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapsStorage;
import com.intellij.openapi.editor.impl.softwrap.mapping.CachingSoftWrapDataMapper;
import com.intellij.openapi.editor.impl.softwrap.mapping.SoftWrapApplianceManager;
import com.intellij.openapi.editor.impl.softwrap.mapping.SoftWrapAwareDocumentParsingListenerAdapter;
import com.intellij.openapi.editor.impl.softwrap.mapping.SoftWrapAwareVisualSizeManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.reference.SoftReference;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoftWrapModelImpl
implements SoftWrapModelEx,
PrioritizedInternalDocumentListener,
FoldingListener,
PropertyChangeListener,
Dumpable,
Disposable {
    private static final String DEBUG_PROPERTY_NAME = "idea.editor.wrap.soft.debug";
    private static final Logger LOG = Logger.getInstance((String)("#" + SoftWrapModelImpl.class.getName()));
    private final LogicalPositionToOffsetTask myLogicalToOffsetTask = new LogicalPositionToOffsetTask();
    private final OffsetToLogicalTask myOffsetToLogicalTask = new OffsetToLogicalTask();
    private final VisualToLogicalTask myVisualToLogicalTask = new VisualToLogicalTask();
    private final LogicalToVisualTask myLogicalToVisualTask = new LogicalToVisualTask();
    private final FoldProcessingEndTask myFoldProcessingEndTask = new FoldProcessingEndTask();
    private final List<SoftWrapChangeListener> mySoftWrapListeners = new ArrayList<SoftWrapChangeListener>();
    private final List<TextRange> myDeferredFoldRegions = new ArrayList<TextRange>();
    private final CachingSoftWrapDataMapper myDataMapper;
    private final SoftWrapsStorage myStorage;
    private SoftWrapPainter myPainter;
    private final SoftWrapApplianceManager myApplianceManager;
    private final SoftWrapAwareVisualSizeManager myVisualSizeManager;
    private EditorTextRepresentationHelper myEditorTextRepresentationHelper;
    @NotNull
    private final EditorImpl myEditor;
    private SoftReference<Thread> myLastEdt = new SoftReference(null);
    private int myActive;
    private boolean myUseSoftWraps;
    private int myTabWidth = -1;
    private final FontPreferences myFontPreferences = new FontPreferences();
    private boolean myUpdateInProgress;
    private boolean myBulkUpdateInProgress;
    private boolean myDirty;
    private boolean myForceAdditionalColumns;

    public SoftWrapModelImpl(@NotNull EditorImpl editor) {
        this.myEditor = editor;
        this.myStorage = new SoftWrapsStorage();
        this.myPainter = new CompositeSoftWrapPainter(editor);
        this.myEditorTextRepresentationHelper = new DefaultEditorTextRepresentationHelper(editor);
        this.myDataMapper = new CachingSoftWrapDataMapper(editor, this.myStorage);
        this.myApplianceManager = new SoftWrapApplianceManager(this.myStorage, editor, this.myPainter, this.myDataMapper);
        this.myVisualSizeManager = new SoftWrapAwareVisualSizeManager(this.myPainter);
        this.myApplianceManager.addListener(this.myVisualSizeManager);
        this.myApplianceManager.addListener(new SoftWrapAwareDocumentParsingListenerAdapter(){

            @Override
            public void recalculationEnds() {
                for (SoftWrapChangeListener listener2 : SoftWrapModelImpl.this.mySoftWrapListeners) {
                    listener2.recalculationEnds();
                }
            }
        });
        this.myUseSoftWraps = this.areSoftWrapsEnabledInEditor();
        this.myEditor.getColorsScheme().getFontPreferences().copyTo(this.myFontPreferences);
        editor.addPropertyChangeListener(this, this);
        this.myApplianceManager.addListener(this.myDataMapper);
    }

    private boolean areSoftWrapsEnabledInEditor() {
        return !(!this.myEditor.getSettings().isUseSoftWraps() || this.myEditor.myUseNewRendering && this.myEditor.isOneLineMode() || this.myEditor.getDocument() instanceof DocumentImpl && ((DocumentImpl)this.myEditor.getDocument()).acceptsSlashR());
    }

    public void reinitSettings() {
        boolean softWrapsUsedBefore = this.myUseSoftWraps;
        this.myUseSoftWraps = this.areSoftWrapsEnabledInEditor();
        int tabWidthBefore = this.myTabWidth;
        this.myTabWidth = EditorUtil.getTabSize(this.myEditor);
        boolean fontsChanged = false;
        if (!this.myFontPreferences.equals((Object)this.myEditor.getColorsScheme().getFontPreferences()) && this.myEditorTextRepresentationHelper instanceof DefaultEditorTextRepresentationHelper) {
            fontsChanged = true;
            this.myEditor.getColorsScheme().getFontPreferences().copyTo(this.myFontPreferences);
            ((DefaultEditorTextRepresentationHelper)this.myEditorTextRepresentationHelper).clearSymbolWidthCache();
            this.myPainter.reinit();
        }
        if (this.myUseSoftWraps ^ softWrapsUsedBefore || tabWidthBefore >= 0 && this.myTabWidth != tabWidthBefore || fontsChanged) {
            this.myApplianceManager.reset();
            this.myDeferredFoldRegions.clear();
            this.myStorage.removeAll();
            if (this.myEditor.myUseNewRendering) {
                this.myEditor.myView.reinitSettings();
            }
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        }
    }

    @Override
    public boolean isRespectAdditionalColumns() {
        return this.myForceAdditionalColumns;
    }

    @Override
    public void forceAdditionalColumnsUsage() {
        this.myForceAdditionalColumns = true;
    }

    public boolean isSoftWrappingEnabled() {
        Thread currentThread;
        if (!this.myUseSoftWraps || !this.myEditor.myUseNewRendering && this.myEditor.isOneLineMode() || this.myEditor.isPurePaintingMode()) {
            return false;
        }
        Application application = ApplicationManager.getApplication();
        Thread lastEdt = (Thread)this.myLastEdt.get();
        if (lastEdt != (currentThread = Thread.currentThread())) {
            if (application.isDispatchThread()) {
                this.myLastEdt = new SoftReference((Object)currentThread);
            } else {
                this.myLastEdt = new SoftReference(null);
                return false;
            }
        }
        return !this.myApplianceManager.getAvailableArea().isEmpty();
    }

    @Nullable
    public SoftWrap getSoftWrap(int offset) {
        if (!this.isSoftWrappingEnabled()) {
            return null;
        }
        return this.myStorage.getSoftWrap(offset);
    }

    @Override
    public int getSoftWrapIndex(int offset) {
        if (this.myEditor.myUseNewRendering && !this.isSoftWrappingEnabled()) {
            return -1;
        }
        return this.myStorage.getSoftWrapIndex(offset);
    }

    @NotNull
    public List<? extends SoftWrap> getSoftWrapsForRange(int start, int end) {
        if (!this.isSoftWrappingEnabled() || end < start) {
            return Collections.emptyList();
        }
        List<SoftWrapImpl> softWraps = this.myStorage.getSoftWraps();
        int startIndex = this.myStorage.getSoftWrapIndex(start);
        if (startIndex < 0 && ((startIndex = -startIndex - 1) >= softWraps.size() || ((SoftWrap)softWraps.get(startIndex)).getStart() > end)) {
            return Collections.emptyList();
        }
        int endIndex = this.myStorage.getSoftWrapIndex(end);
        if (endIndex >= 0) {
            return softWraps.subList(startIndex, endIndex + 1);
        }
        endIndex = -endIndex - 1;
        return softWraps.subList(startIndex, endIndex);
    }

    @NotNull
    public List<? extends SoftWrap> getSoftWrapsForLine(int documentLine) {
        if (!this.isSoftWrappingEnabled() || documentLine < 0) {
            return Collections.emptyList();
        }
        DocumentEx document = this.myEditor.getDocument();
        if (documentLine >= document.getLineCount()) {
            return Collections.emptyList();
        }
        int start = document.getLineStartOffset(documentLine);
        int end = document.getLineEndOffset(documentLine);
        return this.getSoftWrapsForRange(start, end + 1);
    }

    public int getSoftWrapsIntroducedLinesNumber() {
        return this.myStorage.getSoftWraps().size();
    }

    public void registerSoftWrapsIfNecessary() {
        if (!this.isSoftWrappingEnabled()) {
            return;
        }
        ++this.myActive;
        try {
            this.myApplianceManager.registerSoftWrapIfNecessary();
        }
        finally {
            --this.myActive;
        }
    }

    @Override
    public List<? extends SoftWrap> getRegisteredSoftWraps() {
        if (!this.isSoftWrappingEnabled()) {
            return Collections.emptyList();
        }
        List<SoftWrapImpl> softWraps = this.myStorage.getSoftWraps();
        if (!softWraps.isEmpty() && softWraps.get(softWraps.size() - 1).getStart() >= this.myEditor.getDocument().getTextLength()) {
            LOG.error("Unexpected soft wrap location", new Attachment[]{new Attachment("editorState.txt", this.myEditor.dumpState())});
        }
        return softWraps;
    }

    public boolean isVisible(SoftWrap softWrap) {
        int start;
        FoldingModelImpl foldingModel = this.myEditor.getFoldingModel();
        if (foldingModel.isOffsetCollapsed(start = softWrap.getStart())) {
            return false;
        }
        return start <= 0 || !foldingModel.isOffsetCollapsed(start - 1);
    }

    @Override
    public int paint(@NotNull Graphics g, @NotNull SoftWrapDrawingType drawingType, int x, int y, int lineHeight) {
        if (!this.isSoftWrappingEnabled()) {
            return 0;
        }
        if (!this.myEditor.getSettings().isAllSoftWrapsShown()) {
            int visualLine = y / lineHeight;
            LogicalPosition position = this.myEditor.visualToLogicalPosition(new VisualPosition(visualLine, 0));
            if (position.line != this.myEditor.getCaretModel().getLogicalPosition().line) {
                return this.myPainter.getDrawingHorizontalOffset(g, drawingType, x, y, lineHeight);
            }
        }
        return this.doPaint(g, drawingType, x, y, lineHeight);
    }

    public int doPaint(@NotNull Graphics g, @NotNull SoftWrapDrawingType drawingType, int x, int y, int lineHeight) {
        return this.myPainter.paint(g, drawingType, x, y, lineHeight);
    }

    @Override
    public int getMinDrawingWidthInPixels(@NotNull SoftWrapDrawingType drawingType) {
        return this.myPainter.getMinDrawingWidth(drawingType);
    }

    @Override
    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition visual) {
        if (!this.prepareToMapping()) {
            return this.myEditor.visualToLogicalPosition(visual, false);
        }
        ++this.myActive;
        try {
            this.myVisualToLogicalTask.input = visual;
            this.executeSafely(this.myVisualToLogicalTask);
            LogicalPosition logicalPosition = this.myVisualToLogicalTask.output;
            return logicalPosition;
        }
        finally {
            --this.myActive;
        }
    }

    @Override
    @NotNull
    public LogicalPosition offsetToLogicalPosition(int offset) {
        if (!this.prepareToMapping()) {
            return this.myEditor.offsetToLogicalPosition(offset, false);
        }
        ++this.myActive;
        try {
            this.myOffsetToLogicalTask.input = offset;
            this.executeSafely(this.myOffsetToLogicalTask);
            LogicalPosition logicalPosition = this.myOffsetToLogicalTask.output;
            return logicalPosition;
        }
        finally {
            --this.myActive;
        }
    }

    @Override
    public int logicalPositionToOffset(@NotNull LogicalPosition logicalPosition) {
        if (!this.prepareToMapping()) {
            return this.myEditor.logicalPositionToOffset(logicalPosition, false);
        }
        ++this.myActive;
        try {
            this.myLogicalToOffsetTask.input = logicalPosition;
            this.executeSafely(this.myLogicalToOffsetTask);
            int n = this.myLogicalToOffsetTask.output;
            return n;
        }
        finally {
            --this.myActive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public LogicalPosition adjustLogicalPosition(LogicalPosition defaultLogical, int offset) {
        if (!this.prepareToMapping()) {
            return defaultLogical;
        }
        ++this.myActive;
        try {
            this.myOffsetToLogicalTask.input = offset;
            this.executeSafely(this.myOffsetToLogicalTask);
            LogicalPosition logicalPosition = this.myOffsetToLogicalTask.output;
            return logicalPosition;
        }
        finally {
            --this.myActive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public VisualPosition adjustVisualPosition(@NotNull LogicalPosition logical, @NotNull VisualPosition defaultVisual) {
        if (!this.prepareToMapping()) {
            return defaultVisual;
        }
        ++this.myActive;
        try {
            this.myLogicalToVisualTask.input = logical;
            this.myLogicalToVisualTask.defaultOutput = defaultVisual;
            this.executeSafely(this.myLogicalToVisualTask);
            VisualPosition visualPosition = this.myLogicalToVisualTask.output;
            return visualPosition;
        }
        finally {
            --this.myActive;
        }
    }

    public boolean prepareToMapping() {
        if (this.myUpdateInProgress || this.myBulkUpdateInProgress || this.myActive > 0 || !this.isSoftWrappingEnabled() || this.myEditor.getDocument().getTextLength() <= 0) {
            return false;
        }
        if (this.myDirty) {
            this.myStorage.removeAll();
            this.myApplianceManager.reset();
            this.myDeferredFoldRegions.clear();
            this.myDirty = false;
        }
        return this.myApplianceManager.recalculateIfNecessary();
    }

    public boolean isInsideSoftWrap(@NotNull VisualPosition visual) {
        return this.isInsideSoftWrap(visual, false);
    }

    public boolean isInsideOrBeforeSoftWrap(@NotNull VisualPosition visual) {
        return this.isInsideSoftWrap(visual, true);
    }

    private boolean isInsideSoftWrap(@NotNull VisualPosition visual, boolean countBeforeSoftWrap) {
        int offsetLineStart;
        if (!this.isSoftWrappingEnabled()) {
            return false;
        }
        SoftWrapModelImpl model = this.myEditor.getSoftWrapModel();
        if (!model.isSoftWrappingEnabled()) {
            return false;
        }
        LogicalPosition logical = this.myEditor.visualToLogicalPosition(visual);
        int offset = this.myEditor.logicalPositionToOffset(logical);
        if (offset <= 0) {
            return false;
        }
        SoftWrap softWrap = model.getSoftWrap(offset);
        if (softWrap == null) {
            return false;
        }
        VisualPosition visualAfterSoftWrap = this.myEditor.offsetToVisualPosition(offset);
        if (visualAfterSoftWrap.line == visual.line && visualAfterSoftWrap.column <= visual.column) {
            return false;
        }
        if (this.myEditor.myUseNewRendering) {
            VisualPosition beforeSoftWrap = this.myEditor.offsetToVisualPosition(offset, true, true);
            return visual.line > beforeSoftWrap.line || visual.column > beforeSoftWrap.column || visual.column == beforeSoftWrap.column && countBeforeSoftWrap;
        }
        VisualPosition visualBeforeSoftWrap = this.myEditor.offsetToVisualPosition(offset - 1);
        int x = 0;
        LogicalPosition logLineStart = this.myEditor.visualToLogicalPosition(new VisualPosition(visualBeforeSoftWrap.line, 0));
        if (logLineStart.softWrapLinesOnCurrentLogicalLine > 0 && (softWrap = model.getSoftWrap(offsetLineStart = this.myEditor.logicalPositionToOffset(logLineStart))) != null) {
            x = softWrap.getIndentInPixels();
        }
        int width = EditorUtil.textWidthInColumns(this.myEditor, this.myEditor.getDocument().getCharsSequence(), offset - 1, offset, x);
        int softWrapStartColumn = visualBeforeSoftWrap.column + width;
        if (visual.line > visualBeforeSoftWrap.line) {
            return true;
        }
        return countBeforeSoftWrap ? visual.column >= softWrapStartColumn : visual.column > softWrapStartColumn;
    }

    public void beforeDocumentChangeAtCaret() {
        CaretModelImpl caretModel = this.myEditor.getCaretModel();
        VisualPosition visualCaretPosition = caretModel.getVisualPosition();
        if (!this.isInsideSoftWrap(visualCaretPosition)) {
            return;
        }
        SoftWrap softWrap = this.myStorage.getSoftWrap(caretModel.getOffset());
        if (softWrap == null) {
            return;
        }
        this.myEditor.getDocument().replaceString(softWrap.getStart(), softWrap.getEnd(), softWrap.getText());
        caretModel.moveToVisualPosition(visualCaretPosition);
    }

    @Override
    public boolean addSoftWrapChangeListener(@NotNull SoftWrapChangeListener listener2) {
        this.mySoftWrapListeners.add(listener2);
        return this.myStorage.addSoftWrapChangeListener(listener2);
    }

    public boolean addVisualSizeChangeListener(@NotNull VisualSizeChangeListener listener2) {
        return this.myVisualSizeManager.addVisualSizeChangeListener(listener2);
    }

    @Override
    public int getPriority() {
        return 100;
    }

    public void beforeDocumentChange(DocumentEvent event) {
        if (this.myBulkUpdateInProgress) {
            return;
        }
        this.myUpdateInProgress = true;
        if (!this.isSoftWrappingEnabled()) {
            this.myDirty = true;
            return;
        }
        this.myApplianceManager.beforeDocumentChange(event);
    }

    public void documentChanged(DocumentEvent event) {
        if (this.myBulkUpdateInProgress) {
            return;
        }
        this.myUpdateInProgress = false;
        if (!this.isSoftWrappingEnabled()) {
            return;
        }
        this.myApplianceManager.documentChanged(event);
    }

    @Override
    public void moveTextHappened(int start, int end, int base) {
        if (this.myBulkUpdateInProgress) {
            return;
        }
        if (!this.isSoftWrappingEnabled()) {
            this.myDirty = true;
            return;
        }
        this.myApplianceManager.recalculate(Arrays.asList(new TextRange(start, end), new TextRange(base, base + end - start)));
    }

    void onBulkDocumentUpdateStarted() {
        this.myBulkUpdateInProgress = true;
    }

    void onBulkDocumentUpdateFinished() {
        this.myBulkUpdateInProgress = false;
        if (!this.isSoftWrappingEnabled()) {
            this.myDirty = true;
            return;
        }
        this.recalculate();
    }

    @Override
    public void onFoldRegionStateChange(@NotNull FoldRegion region) {
        this.myUpdateInProgress = true;
        if (!this.isSoftWrappingEnabled() || !region.isValid()) {
            this.myDirty = true;
            return;
        }
        this.myDeferredFoldRegions.add(new TextRange(region.getStartOffset(), region.getEndOffset()));
    }

    @Override
    public void onFoldProcessingEnd() {
        this.myUpdateInProgress = false;
        if (!this.isSoftWrappingEnabled()) {
            return;
        }
        if (this.myEditor.myUseNewRendering) {
            this.myFoldProcessingEndTask.run(true);
        } else {
            this.executeSafely(this.myFoldProcessingEndTask);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("fontSize".equals(evt.getPropertyName())) {
            this.myDirty = true;
        }
    }

    @NotNull
    public CachingSoftWrapDataMapper getDataMapper() {
        return this.myDataMapper;
    }

    public void dispose() {
        this.release();
    }

    public void release() {
        this.myDataMapper.release();
        this.myApplianceManager.release();
        this.myStorage.removeAll();
        this.myDeferredFoldRegions.clear();
    }

    public void recalculate() {
        this.myApplianceManager.reset();
        this.myStorage.removeAll();
        this.myDeferredFoldRegions.clear();
        this.myApplianceManager.recalculateIfNecessary();
    }

    public SoftWrapApplianceManager getApplianceManager() {
        return this.myApplianceManager;
    }

    private void executeSafely(SoftWrapAwareTask task) {
        try {
            task.run(true);
        }
        catch (Throwable e) {
            if (Boolean.getBoolean(DEBUG_PROPERTY_NAME) || ApplicationManager.getApplication().isUnitTestMode()) {
                String info = this.myEditor.dumpState();
                LOG.error(String.format("Unexpected exception occurred during performing '%s'", task), e, new String[]{info});
            }
            this.myEditor.getFoldingModel().rebuild();
            this.myDataMapper.release();
            this.myApplianceManager.reset();
            this.myStorage.removeAll();
            this.myApplianceManager.recalculateIfNecessary();
            try {
                task.run(true);
            }
            catch (Throwable e1) {
                String info = this.myEditor.dumpState();
                LOG.error(String.format("Can't perform %s even with complete soft wraps cache re-parsing", task), e1, new String[]{info});
                this.myEditor.getSettings().setUseSoftWraps(false);
                task.run(false);
            }
        }
    }

    public void setSoftWrapPainter(SoftWrapPainter painter) {
        this.myPainter = painter;
        this.myApplianceManager.setSoftWrapPainter(painter);
        this.myVisualSizeManager.setSoftWrapPainter(painter);
    }

    public static EditorTextRepresentationHelper getEditorTextRepresentationHelper(@NotNull Editor editor) {
        return ((SoftWrapModelEx)editor.getSoftWrapModel()).getEditorTextRepresentationHelper();
    }

    @Override
    public EditorTextRepresentationHelper getEditorTextRepresentationHelper() {
        return this.myEditorTextRepresentationHelper;
    }

    public void setEditorTextRepresentationHelper(EditorTextRepresentationHelper editorTextRepresentationHelper) {
        this.myEditorTextRepresentationHelper = editorTextRepresentationHelper;
        this.myApplianceManager.reset();
    }

    @NotNull
    public String dumpState() {
        return String.format("appliance manager state: %s; soft wraps mapping info: %s; soft wraps: %s", this.myApplianceManager.dumpState(), this.myDataMapper.dumpState(), this.myStorage.dumpState());
    }

    public String toString() {
        return this.dumpState();
    }

    public boolean isDirty() {
        return this.myUseSoftWraps && this.myDirty;
    }

    private class FoldProcessingEndTask
    implements SoftWrapAwareTask {
        private FoldProcessingEndTask() {
        }

        @Override
        public void run(boolean softWrapAware) {
            if (!softWrapAware) {
                return;
            }
            try {
                if (!SoftWrapModelImpl.this.myDirty) {
                    SoftWrapModelImpl.this.myApplianceManager.recalculate(SoftWrapModelImpl.this.myDeferredFoldRegions);
                }
            }
            finally {
                SoftWrapModelImpl.this.myDeferredFoldRegions.clear();
            }
        }

        public String toString() {
            return "fold regions state change processing";
        }
    }

    private class LogicalPositionToOffsetTask
    implements SoftWrapAwareTask {
        public LogicalPosition input;
        public int output;

        private LogicalPositionToOffsetTask() {
        }

        @Override
        public void run(boolean softWrapAware) throws IllegalStateException {
            this.output = softWrapAware ? SoftWrapModelImpl.this.myDataMapper.logicalPositionToOffset(this.input) : SoftWrapModelImpl.this.myEditor.logicalPositionToOffset(this.input, false);
        }

        public String toString() {
            return "mapping from logical position (" + this.input + ") to offset";
        }
    }

    private class LogicalToVisualTask
    implements SoftWrapAwareTask {
        public LogicalPosition input;
        private VisualPosition defaultOutput;
        public VisualPosition output;

        private LogicalToVisualTask() {
        }

        @Override
        public void run(boolean softWrapAware) throws IllegalStateException {
            this.output = softWrapAware ? SoftWrapModelImpl.this.myDataMapper.logicalToVisualPosition(this.input, this.defaultOutput) : this.defaultOutput;
        }

        public String toString() {
            return "mapping from logical position (" + this.input + ") to visual position";
        }
    }

    private class VisualToLogicalTask
    implements SoftWrapAwareTask {
        public VisualPosition input;
        public LogicalPosition output;

        private VisualToLogicalTask() {
        }

        @Override
        public void run(boolean softWrapAware) throws IllegalStateException {
            this.output = softWrapAware ? SoftWrapModelImpl.this.myDataMapper.visualToLogical(this.input) : SoftWrapModelImpl.this.myEditor.visualToLogicalPosition(this.input, false);
        }

        public String toString() {
            return "mapping from visual position (" + this.input + ") to logical position";
        }
    }

    private class OffsetToLogicalTask
    implements SoftWrapAwareTask {
        public int input;
        public LogicalPosition output;

        private OffsetToLogicalTask() {
        }

        @Override
        public void run(boolean softWrapAware) throws IllegalStateException {
            this.output = softWrapAware ? SoftWrapModelImpl.this.myDataMapper.offsetToLogicalPosition(this.input) : SoftWrapModelImpl.this.myEditor.offsetToLogicalPosition(this.input, false);
        }

        public String toString() {
            return "mapping from offset (" + this.input + ") to logical position";
        }
    }

    private static interface SoftWrapAwareTask {
        public void run(boolean var1) throws IllegalStateException;
    }
}

