/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SettingsImpl
implements EditorSettings {
    @Nullable
    private final EditorEx myEditor;
    @Nullable
    private final Language myLanguage;
    private Boolean myIsCamelWords;
    private SoftWrapAppliancePlaces mySoftWrapAppliancePlace = SoftWrapAppliancePlaces.MAIN_EDITOR;
    private int myAdditionalLinesCount = 5;
    private int myAdditionalColumnsCount = 3;
    private int myLineCursorWidth = Registry.intValue((String)"editor.caret.width", (int)2);
    private boolean myLineMarkerAreaShown = true;
    private boolean myAllowSingleLogicalLineFolding = false;
    private boolean myAutoCodeFoldingEnabled = true;
    private Integer myTabSize = null;
    private Integer myCachedTabSize = null;
    private Boolean myUseTabCharacter = null;
    private Boolean myIsVirtualSpace = null;
    private Boolean myIsCaretInsideTabs = null;
    private Boolean myIsCaretBlinking = null;
    private Integer myCaretBlinkingPeriod = null;
    private Boolean myIsRightMarginShown = null;
    private Integer myRightMargin = null;
    private Boolean myAreLineNumbersShown = null;
    private Boolean myIsFoldingOutlineShown = null;
    private Boolean myIsSmartHome = null;
    private Boolean myIsBlockCursor = null;
    private Boolean myCaretRowShown = null;
    private Boolean myIsWhitespacesShown = null;
    private Boolean myIsLeadingWhitespacesShown = null;
    private Boolean myIsInnerWhitespacesShown = null;
    private Boolean myIsTrailingWhitespacesShown = null;
    private Boolean myIndentGuidesShown = null;
    private Boolean myIsAnimatedScrolling = null;
    private Boolean myIsAdditionalPageAtBottom = null;
    private Boolean myIsDndEnabled = null;
    private Boolean myIsWheelFontChangeEnabled = null;
    private Boolean myIsMouseClickSelectionHonorsCamelWords = null;
    private Boolean myIsRenameVariablesInplace = null;
    private Boolean myIsRefrainFromScrolling = null;
    private Boolean myUseSoftWraps = null;
    private Boolean myIsAllSoftWrapsShown = null;
    private Boolean myUseCustomSoftWrapIndent = null;
    private Integer myCustomSoftWrapIndent = null;
    private Boolean myRenamePreselect = null;
    private Boolean myWrapWhenTypingReachesRightMargin = null;
    private Boolean myShowIntentionBulb = null;

    public SettingsImpl() {
        this(null, null);
    }

    public SettingsImpl(@Nullable EditorEx editor, @Nullable Project project2) {
        this.myEditor = editor;
        this.myLanguage = editor != null && project2 != null ? SettingsImpl.getDocumentLanguage(project2, editor.getDocument()) : null;
    }

    public boolean isRightMarginShown() {
        return this.myIsRightMarginShown != null ? this.myIsRightMarginShown.booleanValue() : EditorSettingsExternalizable.getInstance().isRightMarginShown();
    }

    public void setRightMarginShown(boolean val) {
        Boolean newValue;
        Boolean bl = newValue = val ? Boolean.TRUE : Boolean.FALSE;
        if (newValue.equals(this.myIsRightMarginShown)) {
            return;
        }
        this.myIsRightMarginShown = newValue;
        this.fireEditorRefresh();
    }

    public boolean isWhitespacesShown() {
        return this.myIsWhitespacesShown != null ? this.myIsWhitespacesShown.booleanValue() : EditorSettingsExternalizable.getInstance().isWhitespacesShown();
    }

    public void setWhitespacesShown(boolean val) {
        this.myIsWhitespacesShown = val;
    }

    public boolean isLeadingWhitespaceShown() {
        return this.myIsLeadingWhitespacesShown != null ? this.myIsLeadingWhitespacesShown.booleanValue() : EditorSettingsExternalizable.getInstance().isLeadingWhitespacesShown();
    }

    public void setLeadingWhitespaceShown(boolean val) {
        this.myIsLeadingWhitespacesShown = val;
    }

    public boolean isInnerWhitespaceShown() {
        return this.myIsInnerWhitespacesShown != null ? this.myIsInnerWhitespacesShown.booleanValue() : EditorSettingsExternalizable.getInstance().isInnerWhitespacesShown();
    }

    public void setInnerWhitespaceShown(boolean val) {
        this.myIsInnerWhitespacesShown = val;
    }

    public boolean isTrailingWhitespaceShown() {
        return this.myIsTrailingWhitespacesShown != null ? this.myIsTrailingWhitespacesShown.booleanValue() : EditorSettingsExternalizable.getInstance().isTrailingWhitespacesShown();
    }

    public void setTrailingWhitespaceShown(boolean val) {
        this.myIsTrailingWhitespacesShown = val;
    }

    public boolean isIndentGuidesShown() {
        return this.myIndentGuidesShown != null ? this.myIndentGuidesShown.booleanValue() : EditorSettingsExternalizable.getInstance().isIndentGuidesShown();
    }

    public void setIndentGuidesShown(boolean val) {
        Boolean newValue;
        Boolean bl = newValue = val ? Boolean.TRUE : Boolean.FALSE;
        if (newValue.equals(this.myIndentGuidesShown)) {
            return;
        }
        this.myIndentGuidesShown = newValue;
        this.fireEditorRefresh();
    }

    public boolean isLineNumbersShown() {
        return this.myAreLineNumbersShown != null ? this.myAreLineNumbersShown.booleanValue() : EditorSettingsExternalizable.getInstance().isLineNumbersShown();
    }

    public void setLineNumbersShown(boolean val) {
        Boolean newValue;
        Boolean bl = newValue = val ? Boolean.TRUE : Boolean.FALSE;
        if (newValue.equals(this.myAreLineNumbersShown)) {
            return;
        }
        this.myAreLineNumbersShown = newValue;
        this.fireEditorRefresh();
    }

    public int getRightMargin(Project project2) {
        return this.myRightMargin != null ? this.myRightMargin.intValue() : CodeStyleFacade.getInstance((Project)project2).getRightMargin(this.myLanguage);
    }

    @Nullable
    private static Language getDocumentLanguage(@Nullable Project project2, @NotNull Document document) {
        PsiDocumentManager documentManager;
        PsiFile file2;
        if (project2 != null && (file2 = (documentManager = PsiDocumentManager.getInstance((Project)project2)).getPsiFile(document)) != null) {
            return file2.getLanguage();
        }
        return null;
    }

    public boolean isWrapWhenTypingReachesRightMargin(Project project2) {
        return this.myWrapWhenTypingReachesRightMargin != null ? this.myWrapWhenTypingReachesRightMargin.booleanValue() : CodeStyleFacade.getInstance((Project)project2).isWrapOnTyping(this.myLanguage);
    }

    public void setWrapWhenTypingReachesRightMargin(boolean val) {
        this.myWrapWhenTypingReachesRightMargin = val;
    }

    public void setRightMargin(int rightMargin) {
        Integer newValue = rightMargin;
        if (newValue.equals(this.myRightMargin)) {
            return;
        }
        this.myRightMargin = newValue;
        this.fireEditorRefresh();
    }

    public int getAdditionalLinesCount() {
        return this.myAdditionalLinesCount;
    }

    public void setAdditionalLinesCount(int additionalLinesCount) {
        if (this.myAdditionalLinesCount == additionalLinesCount) {
            return;
        }
        this.myAdditionalLinesCount = additionalLinesCount;
        this.fireEditorRefresh();
    }

    public int getAdditionalColumnsCount() {
        return this.myAdditionalColumnsCount;
    }

    public void setAdditionalColumnsCount(int additionalColumnsCount) {
        if (this.myAdditionalColumnsCount == additionalColumnsCount) {
            return;
        }
        this.myAdditionalColumnsCount = additionalColumnsCount;
        this.fireEditorRefresh();
    }

    public boolean isLineMarkerAreaShown() {
        return this.myLineMarkerAreaShown;
    }

    public void setLineMarkerAreaShown(boolean lineMarkerAreaShown) {
        if (this.myLineMarkerAreaShown == lineMarkerAreaShown) {
            return;
        }
        this.myLineMarkerAreaShown = lineMarkerAreaShown;
        this.fireEditorRefresh();
    }

    public boolean isFoldingOutlineShown() {
        return this.myIsFoldingOutlineShown != null ? this.myIsFoldingOutlineShown.booleanValue() : EditorSettingsExternalizable.getInstance().isFoldingOutlineShown();
    }

    public void setFoldingOutlineShown(boolean val) {
        Boolean newValue;
        Boolean bl = newValue = val ? Boolean.TRUE : Boolean.FALSE;
        if (newValue.equals(this.myIsFoldingOutlineShown)) {
            return;
        }
        this.myIsFoldingOutlineShown = newValue;
        this.fireEditorRefresh();
    }

    public boolean isAutoCodeFoldingEnabled() {
        return this.myAutoCodeFoldingEnabled;
    }

    public void setAutoCodeFoldingEnabled(boolean val) {
        this.myAutoCodeFoldingEnabled = val;
    }

    public boolean isUseTabCharacter(Project project2) {
        PsiFile file2 = this.getPsiFile(project2);
        return this.myUseTabCharacter != null ? this.myUseTabCharacter : CodeStyleSettingsManager.getSettings((Project)project2).getIndentOptionsByFile((PsiFile)file2).USE_TAB_CHARACTER;
    }

    public void setUseTabCharacter(boolean val) {
        Boolean newValue;
        Boolean bl = newValue = val ? Boolean.TRUE : Boolean.FALSE;
        if (newValue.equals(this.myUseTabCharacter)) {
            return;
        }
        this.myUseTabCharacter = newValue;
        this.fireEditorRefresh();
    }

    public void setSoftWrapAppliancePlace(SoftWrapAppliancePlaces softWrapAppliancePlace) {
        this.mySoftWrapAppliancePlace = softWrapAppliancePlace;
    }

    public void reinitSettings() {
        this.myCachedTabSize = null;
        this.reinitDocumentIndentOptions();
    }

    private void reinitDocumentIndentOptions() {
        if (this.myEditor == null || this.myEditor.isViewer()) {
            return;
        }
        final Project project2 = this.myEditor.getProject();
        final DocumentEx document = this.myEditor.getDocument();
        if (project2 == null || project2.isDisposed()) {
            return;
        }
        PsiDocumentManager psiManager = PsiDocumentManager.getInstance((Project)project2);
        PsiFile file2 = psiManager.getPsiFile((Document)document);
        if (file2 == null) {
            return;
        }
        CodeStyleSettings settings = CodeStyleSettingsManager.getInstance((Project)project2).getCurrentSettings();
        CommonCodeStyleSettings.IndentOptions options = settings.getIndentOptionsByFile(file2);
        if (CodeStyleSettings.isRecalculateForCommittedDocument((CommonCodeStyleSettings.IndentOptions)options)) {
            PsiDocumentManager.getInstance((Project)project2).performForCommittedDocument((Document)document, new Runnable(){

                @Override
                public void run() {
                    CodeStyleSettingsManager.updateDocumentIndentOptions((Project)project2, (Document)document);
                }
            });
        } else {
            CodeStyleSettingsManager.updateDocumentIndentOptions((Project)project2, (Document)document);
        }
    }

    public int getTabSize(Project project2) {
        int tabSize;
        if (this.myTabSize != null) {
            return this.myTabSize;
        }
        if (this.myCachedTabSize != null) {
            return this.myCachedTabSize;
        }
        if (project2 == null || project2.isDisposed()) {
            tabSize = CodeStyleSettingsManager.getSettings(null).getTabSize(null);
        } else {
            PsiFile file2 = this.getPsiFile(project2);
            if (this.myEditor != null && this.myEditor.isViewer()) {
                FileType fileType = file2 != null ? file2.getFileType() : null;
                tabSize = CodeStyleSettingsManager.getSettings((Project)project2).getIndentOptions((FileType)fileType).TAB_SIZE;
            } else {
                tabSize = CodeStyleSettingsManager.getSettings((Project)project2).getIndentOptionsByFile((PsiFile)file2).TAB_SIZE;
            }
        }
        this.myCachedTabSize = tabSize;
        return tabSize;
    }

    @Nullable
    private PsiFile getPsiFile(@Nullable Project project2) {
        if (project2 != null && this.myEditor != null) {
            return PsiDocumentManager.getInstance((Project)project2).getPsiFile((Document)this.myEditor.getDocument());
        }
        return null;
    }

    public void setTabSize(int tabSize) {
        Integer newValue = tabSize;
        if (newValue.equals(this.myTabSize)) {
            return;
        }
        this.myTabSize = newValue;
        this.fireEditorRefresh();
    }

    public boolean isSmartHome() {
        return this.myIsSmartHome != null ? this.myIsSmartHome.booleanValue() : EditorSettingsExternalizable.getInstance().isSmartHome();
    }

    public void setSmartHome(boolean val) {
        Boolean newValue;
        Boolean bl = newValue = val ? Boolean.TRUE : Boolean.FALSE;
        if (newValue.equals(this.myIsSmartHome)) {
            return;
        }
        this.myIsSmartHome = newValue;
        this.fireEditorRefresh();
    }

    public boolean isVirtualSpace() {
        if (this.myEditor != null && this.myEditor.isColumnMode()) {
            return true;
        }
        return this.myIsVirtualSpace != null ? this.myIsVirtualSpace.booleanValue() : EditorSettingsExternalizable.getInstance().isVirtualSpace();
    }

    public void setVirtualSpace(boolean allow) {
        Boolean newValue = allow;
        if (newValue.equals(this.myIsVirtualSpace)) {
            return;
        }
        this.myIsVirtualSpace = newValue;
        this.fireEditorRefresh();
    }

    public boolean isAdditionalPageAtBottom() {
        return this.myIsAdditionalPageAtBottom != null ? this.myIsAdditionalPageAtBottom.booleanValue() : EditorSettingsExternalizable.getInstance().isAdditionalPageAtBottom();
    }

    public void setAdditionalPageAtBottom(boolean val) {
        this.myIsAdditionalPageAtBottom = val;
    }

    public boolean isCaretInsideTabs() {
        if (this.myEditor != null && this.myEditor.isColumnMode()) {
            return true;
        }
        return this.myIsCaretInsideTabs != null ? this.myIsCaretInsideTabs.booleanValue() : EditorSettingsExternalizable.getInstance().isCaretInsideTabs();
    }

    public void setCaretInsideTabs(boolean allow) {
        Boolean newValue = allow;
        if (newValue.equals(this.myIsCaretInsideTabs)) {
            return;
        }
        this.myIsCaretInsideTabs = newValue;
        this.fireEditorRefresh();
    }

    public boolean isBlockCursor() {
        return this.myIsBlockCursor != null ? this.myIsBlockCursor.booleanValue() : EditorSettingsExternalizable.getInstance().isBlockCursor();
    }

    public void setBlockCursor(boolean val) {
        Boolean newValue;
        Boolean bl = newValue = val ? Boolean.TRUE : Boolean.FALSE;
        if (newValue.equals(this.myIsBlockCursor)) {
            return;
        }
        this.myIsBlockCursor = newValue;
        this.fireEditorRefresh();
    }

    public boolean isCaretRowShown() {
        return this.myCaretRowShown != null ? this.myCaretRowShown.booleanValue() : EditorSettingsExternalizable.getInstance().isCaretRowShown();
    }

    public void setCaretRowShown(boolean val) {
        Boolean newValue;
        Boolean bl = newValue = val ? Boolean.TRUE : Boolean.FALSE;
        if (newValue.equals(this.myCaretRowShown)) {
            return;
        }
        this.myCaretRowShown = newValue;
        this.fireEditorRefresh();
    }

    public int getLineCursorWidth() {
        return this.myLineCursorWidth;
    }

    public void setLineCursorWidth(int width) {
        this.myLineCursorWidth = width;
    }

    public boolean isAnimatedScrolling() {
        return this.myIsAnimatedScrolling != null ? this.myIsAnimatedScrolling.booleanValue() : EditorSettingsExternalizable.getInstance().isSmoothScrolling();
    }

    public void setAnimatedScrolling(boolean val) {
        this.myIsAnimatedScrolling = val ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isCamelWords() {
        return this.myIsCamelWords != null ? this.myIsCamelWords.booleanValue() : EditorSettingsExternalizable.getInstance().isCamelWords();
    }

    public void setCamelWords(boolean val) {
        this.myIsCamelWords = val ? Boolean.TRUE : Boolean.FALSE;
    }

    public void resetCamelWords() {
        this.myIsCamelWords = null;
    }

    public boolean isBlinkCaret() {
        return this.myIsCaretBlinking != null ? this.myIsCaretBlinking.booleanValue() : EditorSettingsExternalizable.getInstance().isBlinkCaret();
    }

    public void setBlinkCaret(boolean val) {
        Boolean newValue;
        Boolean bl = newValue = val ? Boolean.TRUE : Boolean.FALSE;
        if (newValue.equals(this.myIsCaretBlinking)) {
            return;
        }
        this.myIsCaretBlinking = newValue;
        this.fireEditorRefresh();
    }

    public int getCaretBlinkPeriod() {
        return this.myCaretBlinkingPeriod != null ? this.myCaretBlinkingPeriod.intValue() : EditorSettingsExternalizable.getInstance().getBlinkPeriod();
    }

    public void setCaretBlinkPeriod(int blinkPeriod) {
        Integer newValue = blinkPeriod;
        if (newValue.equals(this.myCaretBlinkingPeriod)) {
            return;
        }
        this.myCaretBlinkingPeriod = newValue;
        this.fireEditorRefresh();
    }

    public boolean isDndEnabled() {
        return this.myIsDndEnabled != null ? this.myIsDndEnabled.booleanValue() : EditorSettingsExternalizable.getInstance().isDndEnabled();
    }

    public void setDndEnabled(boolean val) {
        this.myIsDndEnabled = val ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isWheelFontChangeEnabled() {
        return this.myIsWheelFontChangeEnabled != null ? this.myIsWheelFontChangeEnabled.booleanValue() : EditorSettingsExternalizable.getInstance().isWheelFontChangeEnabled();
    }

    public void setWheelFontChangeEnabled(boolean val) {
        this.myIsWheelFontChangeEnabled = val ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isMouseClickSelectionHonorsCamelWords() {
        return this.myIsMouseClickSelectionHonorsCamelWords != null ? this.myIsMouseClickSelectionHonorsCamelWords.booleanValue() : EditorSettingsExternalizable.getInstance().isMouseClickSelectionHonorsCamelWords();
    }

    public void setMouseClickSelectionHonorsCamelWords(boolean val) {
        this.myIsMouseClickSelectionHonorsCamelWords = val ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isVariableInplaceRenameEnabled() {
        return this.myIsRenameVariablesInplace != null ? this.myIsRenameVariablesInplace.booleanValue() : EditorSettingsExternalizable.getInstance().isVariableInplaceRenameEnabled();
    }

    public void setVariableInplaceRenameEnabled(boolean val) {
        this.myIsRenameVariablesInplace = val ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isRefrainFromScrolling() {
        if (this.myIsRefrainFromScrolling != null) {
            return this.myIsRefrainFromScrolling;
        }
        return EditorSettingsExternalizable.getInstance().isRefrainFromScrolling();
    }

    public void setRefrainFromScrolling(boolean b) {
        this.myIsRefrainFromScrolling = b ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isUseSoftWraps() {
        return this.myUseSoftWraps != null ? this.myUseSoftWraps.booleanValue() : EditorSettingsExternalizable.getInstance().isUseSoftWraps(this.mySoftWrapAppliancePlace);
    }

    public void setUseSoftWraps(boolean use) {
        Boolean newValue;
        Boolean bl = newValue = use ? Boolean.TRUE : Boolean.FALSE;
        if (newValue.equals(this.myUseSoftWraps)) {
            return;
        }
        this.myUseSoftWraps = newValue;
        this.fireEditorRefresh();
    }

    public void setUseSoftWrapsQuiet() {
        this.myUseSoftWraps = Boolean.TRUE;
    }

    public boolean isAllSoftWrapsShown() {
        return this.myIsAllSoftWrapsShown != null ? this.myIsWhitespacesShown.booleanValue() : EditorSettingsExternalizable.getInstance().isAllSoftWrapsShown();
    }

    public boolean isUseCustomSoftWrapIndent() {
        return this.myUseCustomSoftWrapIndent == null ? EditorSettingsExternalizable.getInstance().isUseCustomSoftWrapIndent() : this.myUseCustomSoftWrapIndent.booleanValue();
    }

    public void setUseCustomSoftWrapIndent(boolean useCustomSoftWrapIndent) {
        this.myUseCustomSoftWrapIndent = useCustomSoftWrapIndent;
    }

    public int getCustomSoftWrapIndent() {
        return this.myCustomSoftWrapIndent == null ? EditorSettingsExternalizable.getInstance().getCustomSoftWrapIndent() : this.myCustomSoftWrapIndent.intValue();
    }

    public void setCustomSoftWrapIndent(int indent) {
        this.myCustomSoftWrapIndent = indent;
    }

    public boolean isAllowSingleLogicalLineFolding() {
        return this.myAllowSingleLogicalLineFolding;
    }

    public void setAllowSingleLogicalLineFolding(boolean allow) {
        this.myAllowSingleLogicalLineFolding = allow;
    }

    private void fireEditorRefresh() {
        if (this.myEditor != null) {
            this.myEditor.reinitSettings();
        }
    }

    public boolean isPreselectRename() {
        return this.myRenamePreselect == null ? EditorSettingsExternalizable.getInstance().isPreselectRename() : this.myRenamePreselect.booleanValue();
    }

    public void setPreselectRename(boolean val) {
        this.myRenamePreselect = val;
    }

    public boolean isShowIntentionBulb() {
        return this.myShowIntentionBulb == null ? EditorSettingsExternalizable.getInstance().isShowIntentionBulb() : this.myShowIntentionBulb.booleanValue();
    }

    public void setShowIntentionBulb(boolean show) {
        this.myShowIntentionBulb = show;
    }
}

