/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.StripTrailingSpacesFilter;
import com.intellij.openapi.editor.StripTrailingSpacesFilterFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.BitSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiBasedStripTrailingSpacesFilter
implements StripTrailingSpacesFilter {
    @NotNull
    private final BitSet myDisabledLinesBitSet;
    @NotNull
    private final Document myDocument;

    protected PsiBasedStripTrailingSpacesFilter(@NotNull Document document) {
        this.myDocument = document;
        this.myDisabledLinesBitSet = new BitSet(document.getLineCount());
    }

    public boolean isStripSpacesAllowedForLine(int line) {
        return !this.myDisabledLinesBitSet.get(line);
    }

    protected abstract void process(@NotNull PsiFile var1);

    @Nullable
    private static Language getDocumentLanguage(@NotNull Document document) {
        FileDocumentManager manager = FileDocumentManager.getInstance();
        VirtualFile file2 = manager.getFile(document);
        if (file2 != null && file2.isValid()) {
            return LanguageUtil.getFileLanguage((VirtualFile)file2);
        }
        return null;
    }

    @Nullable
    private static PsiFile getPsiFile(@Nullable Project project2, @NotNull Document document) {
        PsiDocumentManager documentManager;
        if (project2 != null && (documentManager = PsiDocumentManager.getInstance((Project)project2)).isCommitted(document)) {
            return documentManager.getCachedPsiFile(document);
        }
        return null;
    }

    protected final void disableRange(@NotNull TextRange range) {
        int startLine = this.myDocument.getLineNumber(range.getStartOffset());
        int endLine = this.myDocument.getLineNumber(range.getEndOffset());
        this.myDisabledLinesBitSet.set(startLine, endLine);
    }

    public static abstract class Factory
    extends StripTrailingSpacesFilterFactory {
        @NotNull
        public final StripTrailingSpacesFilter createFilter(@Nullable Project project2, @NotNull Document document) {
            Language language = PsiBasedStripTrailingSpacesFilter.getDocumentLanguage(document);
            if (language != null && this.isApplicableTo(language)) {
                PsiFile psiFile = PsiBasedStripTrailingSpacesFilter.getPsiFile(project2, document);
                if (psiFile != null) {
                    PsiBasedStripTrailingSpacesFilter filter = this.createFilter(document);
                    filter.process(psiFile);
                    return filter;
                }
                return StripTrailingSpacesFilter.POSTPONED;
            }
            return StripTrailingSpacesFilter.ALL_LINES;
        }

        @NotNull
        protected abstract PsiBasedStripTrailingSpacesFilter createFilter(@NotNull Document var1);

        protected abstract boolean isApplicableTo(@NotNull Language var1);
    }
}

