/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityStateListener;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.event.EditorEventMulticasterImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayCharSequence;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class EditorFactoryImpl
extends EditorFactory
implements ApplicationComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.EditorFactoryImpl");
    private final EditorEventMulticasterImpl myEditorEventMulticaster = new EditorEventMulticasterImpl();
    private final EventDispatcher<EditorFactoryListener> myEditorFactoryEventDispatcher = EventDispatcher.create(EditorFactoryListener.class);
    private final List<Editor> myEditors = ContainerUtil.createLockFreeCopyOnWriteList();

    public EditorFactoryImpl(ProjectManager projectManager) {
        projectManager.addProjectManagerListener((ProjectManagerListener)new ProjectManagerAdapter(){

            public void projectOpened(final Project project2) {
                Disposer.register((Disposable)project2, (Disposable)new Disposable(){

                    public void dispose() {
                        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
                        boolean isLastProjectClosed = openProjects.length == 0;
                        EditorFactoryImpl.this.validateEditorsAreReleased(project2, isLastProjectClosed);
                    }
                });
            }
        });
    }

    @NotNull
    public String getComponentName() {
        return "EditorFactory";
    }

    public void initComponent() {
        ModalityStateListener myModalityStateListener = new ModalityStateListener(){

            public void beforeModalityStateChanged(boolean entering) {
                for (Editor editor : EditorFactoryImpl.this.myEditors) {
                    ((EditorImpl)editor).beforeModalityStateChanged();
                }
            }
        };
        LaterInvocator.addModalityStateListener(myModalityStateListener, (Disposable)ApplicationManager.getApplication());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateEditorsAreReleased(Project project2, boolean isLastProjectClosed) {
        for (Editor editor : this.myEditors) {
            if (editor.getProject() != project2 && (editor.getProject() != null || !isLastProjectClosed)) continue;
            try {
                EditorFactoryImpl.throwNotReleasedError(editor);
            }
            finally {
                this.releaseEditor(editor);
            }
        }
    }

    @NonNls
    public static void throwNotReleasedError(@NotNull Editor editor) {
        if (!(editor instanceof EditorImpl)) {
            throw new RuntimeException("Editor of " + editor.getClass() + " and the following text hasn't been released:\n" + editor.getDocument().getText());
        }
        ((EditorImpl)editor).throwEditorNotDisposedError("Editor of " + editor.getClass() + " hasn't been released:");
    }

    public void disposeComponent() {
    }

    @NotNull
    public Document createDocument(@NotNull char[] text) {
        return this.createDocument((CharSequence)new CharArrayCharSequence(text));
    }

    @NotNull
    public Document createDocument(@NotNull CharSequence text) {
        DocumentImpl document = new DocumentImpl(text);
        this.myEditorEventMulticaster.registerDocument(document);
        return document;
    }

    @NotNull
    public Document createDocument(boolean allowUpdatesWithoutWriteAction) {
        DocumentImpl document = new DocumentImpl("", allowUpdatesWithoutWriteAction);
        this.myEditorEventMulticaster.registerDocument(document);
        return document;
    }

    @NotNull
    public Document createDocument(@NotNull CharSequence text, boolean acceptsSlashR, boolean allowUpdatesWithoutWriteAction) {
        DocumentImpl document = new DocumentImpl(text, acceptsSlashR, allowUpdatesWithoutWriteAction);
        this.myEditorEventMulticaster.registerDocument(document);
        return document;
    }

    public void refreshAllEditors() {
        for (Editor editor : this.myEditors) {
            ((EditorEx)editor).reinitSettings();
        }
    }

    public Editor createEditor(@NotNull Document document) {
        return this.createEditor(document, false, null);
    }

    public Editor createViewer(@NotNull Document document) {
        return this.createEditor(document, true, null);
    }

    public Editor createEditor(@NotNull Document document, Project project2) {
        return this.createEditor(document, false, project2);
    }

    public Editor createViewer(@NotNull Document document, Project project2) {
        return this.createEditor(document, true, project2);
    }

    public Editor createEditor(@NotNull Document document, Project project2, @NotNull FileType fileType, boolean isViewer) {
        Editor editor = this.createEditor(document, isViewer, project2);
        ((EditorEx)editor).setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(project2, fileType));
        return editor;
    }

    public Editor createEditor(@NotNull Document document, Project project2, @NotNull VirtualFile file2, boolean isViewer) {
        Editor editor = this.createEditor(document, isViewer, project2);
        ((EditorEx)editor).setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(project2, file2));
        return editor;
    }

    private Editor createEditor(@NotNull Document document, boolean isViewer, Project project2) {
        Document hostDocument = document instanceof DocumentWindow ? ((DocumentWindow)document).getDelegate() : document;
        EditorImpl editor = new EditorImpl(hostDocument, isViewer, project2);
        this.myEditors.add(editor);
        this.myEditorEventMulticaster.registerEditor(editor);
        ((EditorFactoryListener)this.myEditorFactoryEventDispatcher.getMulticaster()).editorCreated(new EditorFactoryEvent((EditorFactory)this, (Editor)editor));
        if (LOG.isDebugEnabled()) {
            LOG.debug("number of Editor's:" + this.myEditors.size());
        }
        return editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseEditor(@NotNull Editor editor) {
        try {
            ((EditorFactoryListener)this.myEditorFactoryEventDispatcher.getMulticaster()).editorReleased(new EditorFactoryEvent((EditorFactory)this, editor));
        }
        finally {
            try {
                ((EditorImpl)editor).release();
            }
            finally {
                this.myEditors.remove(editor);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("number of Editor's:" + this.myEditors.size());
                }
            }
        }
    }

    @NotNull
    public Editor[] getEditors(@NotNull Document document, Project project2) {
        List list = null;
        for (Editor editor : this.myEditors) {
            Project project1 = editor.getProject();
            if (!editor.getDocument().equals(document) || project2 != null && project1 != null && !project1.equals(project2)) continue;
            if (list == null) {
                list = new SmartList();
            }
            list.add(editor);
        }
        return list == null ? Editor.EMPTY_ARRAY : list.toArray(new Editor[list.size()]);
    }

    @NotNull
    public Editor[] getEditors(@NotNull Document document) {
        return this.getEditors(document, null);
    }

    @NotNull
    public Editor[] getAllEditors() {
        return (Editor[])ArrayUtil.stripTrailingNulls((Object[])this.myEditors.toArray(new Editor[this.myEditors.size()]));
    }

    @Deprecated
    public void addEditorFactoryListener(@NotNull EditorFactoryListener listener2) {
        this.myEditorFactoryEventDispatcher.addListener((EventListener)listener2);
    }

    public void addEditorFactoryListener(@NotNull EditorFactoryListener listener2, @NotNull Disposable parentDisposable) {
        this.myEditorFactoryEventDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    @Deprecated
    public void removeEditorFactoryListener(@NotNull EditorFactoryListener listener2) {
        this.myEditorFactoryEventDispatcher.removeListener((EventListener)listener2);
    }

    @NotNull
    public EditorEventMulticaster getEventMulticaster() {
        return this.myEditorEventMulticaster;
    }
}

