/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.WeakList;
import org.jetbrains.annotations.NotNull;

public class DocumentMarkupModelManager
extends AbstractProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.DocumentMarkupModelManager");
    private final WeakList<Document> myDocumentSet = new WeakList();
    private volatile boolean myDisposed;

    public static DocumentMarkupModelManager getInstance(Project project2) {
        return (DocumentMarkupModelManager)((Object)project2.getComponent(DocumentMarkupModelManager.class));
    }

    public DocumentMarkupModelManager(@NotNull Project project2) {
        super(project2);
        Disposer.register((Disposable)project2, (Disposable)new Disposable(){

            public void dispose() {
                DocumentMarkupModelManager.this.cleanupProjectMarkups();
            }
        });
    }

    public void registerDocument(Document document) {
        LOG.assertTrue(!this.myDisposed);
        this.myDocumentSet.add((Object)document);
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    private void cleanupProjectMarkups() {
        if (!this.myDisposed) {
            this.myDisposed = true;
            for (Document document : this.myDocumentSet.toStrongList()) {
                DocumentMarkupModel.removeMarkupModel(document, this.myProject);
            }
        }
    }
}

