/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.MarkupModelWindow;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModelManager;
import com.intellij.openapi.editor.impl.EmptyMarkupModel;
import com.intellij.openapi.editor.impl.MarkupModelImpl;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentMarkupModel {
    private static final Key<MarkupModelEx> MARKUP_MODEL_KEY = Key.create((String)"DocumentMarkupModel.MarkupModel");
    private static final Key<ConcurrentMap<Project, MarkupModelImpl>> MARKUP_MODEL_MAP_KEY = Key.create((String)"DocumentMarkupModel.MarkupModelMap");

    private DocumentMarkupModel() {
    }

    public static MarkupModel forDocument(@NotNull Document document, @Nullable Project project2, boolean create) {
        DocumentMarkupModelManager documentMarkupModelManager;
        if (document instanceof DocumentWindow) {
            Document delegate = ((DocumentWindow)document).getDelegate();
            MarkupModelEx baseMarkupModel = (MarkupModelEx)DocumentMarkupModel.forDocument(delegate, project2, true);
            return new MarkupModelWindow(baseMarkupModel, (DocumentWindow)document);
        }
        if (project2 == null) {
            MarkupModelImpl newModel;
            MarkupModelEx markupModel = (MarkupModelEx)document.getUserData(MARKUP_MODEL_KEY);
            if (create && markupModel == null && (markupModel = (MarkupModelEx)((UserDataHolderEx)document).putUserDataIfAbsent(MARKUP_MODEL_KEY, (Object)(newModel = new MarkupModelImpl((DocumentEx)document)))) != newModel) {
                newModel.dispose();
            }
            return markupModel;
        }
        DocumentMarkupModelManager documentMarkupModelManager2 = documentMarkupModelManager = project2.isDisposed() ? null : DocumentMarkupModelManager.getInstance(project2);
        if (documentMarkupModelManager == null || documentMarkupModelManager.isDisposed() || project2.isDisposed()) {
            return new EmptyMarkupModel(document);
        }
        ConcurrentMap<Project, MarkupModelImpl> markupModelMap = DocumentMarkupModel.getMarkupModelMap(document);
        MarkupModelImpl model = (MarkupModelImpl)markupModelMap.get(project2);
        if (create && model == null) {
            MarkupModelImpl newModel = new MarkupModelImpl((DocumentEx)document);
            model = (MarkupModelImpl)ConcurrencyUtil.cacheOrGet(markupModelMap, (Object)project2, (Object)newModel);
            if (model == newModel) {
                documentMarkupModelManager.registerDocument(document);
            } else {
                newModel.dispose();
            }
        }
        return model;
    }

    private static ConcurrentMap<Project, MarkupModelImpl> getMarkupModelMap(@NotNull Document document) {
        ConcurrentMap markupModelMap = (ConcurrentMap)document.getUserData(MARKUP_MODEL_MAP_KEY);
        if (markupModelMap == null) {
            ConcurrentMap newMap = ContainerUtil.newConcurrentMap();
            markupModelMap = (ConcurrentMap)((UserDataHolderEx)document).putUserDataIfAbsent(MARKUP_MODEL_MAP_KEY, (Object)newMap);
        }
        return markupModelMap;
    }

    static void removeMarkupModel(@NotNull Document document, @NotNull Project project2) {
        MarkupModelImpl removed = (MarkupModelImpl)DocumentMarkupModel.getMarkupModelMap(document).remove(project2);
        if (removed != null) {
            removed.dispose();
        }
    }
}

