/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import java.awt.Point;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

public class ClipDetector {
    private final EditorImpl myEditor;
    private final Rectangle myClipRectangle;
    private int myVisualLineStartOffset = -1;
    private int myVisualLineEndOffset = -1;
    private int myVisualLineClipStartOffset;
    private int myVisualLineClipEndOffset;

    public ClipDetector(@NotNull EditorImpl editor, Rectangle clipRectangle) {
        this.myEditor = editor;
        this.myClipRectangle = clipRectangle;
    }

    public boolean rangeCanBeVisible(int startOffset, int endOffset) {
        assert (startOffset >= 0);
        assert (startOffset <= endOffset);
        assert (endOffset <= this.myEditor.getDocument().getTextLength());
        if (this.myEditor.getSettings().isUseSoftWraps()) {
            return true;
        }
        if (startOffset < this.myVisualLineStartOffset || startOffset > this.myVisualLineEndOffset) {
            this.myVisualLineStartOffset = EditorUtil.getNotFoldedLineStartOffset(this.myEditor, startOffset);
            this.myVisualLineEndOffset = EditorUtil.getNotFoldedLineEndOffset(this.myEditor, startOffset);
            int visualLine = this.myEditor.offsetToVisualLine(startOffset);
            int y = this.myEditor.visibleLineToY(visualLine);
            this.myVisualLineClipStartOffset = this.myEditor.logicalPositionToOffset(this.myEditor.xyToLogicalPosition(new Point(this.myClipRectangle.x, y)));
            this.myVisualLineClipEndOffset = this.myEditor.logicalPositionToOffset(this.myEditor.xyToLogicalPosition(new Point(this.myClipRectangle.x + this.myClipRectangle.width, y)));
        }
        return endOffset > this.myVisualLineEndOffset || startOffset <= this.myVisualLineClipEndOffset && endOffset >= this.myVisualLineClipStartOffset;
    }
}

