/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.util.containers.IntIntHashMap;
import org.intellij.lang.annotations.JdkConstants;

public class CharWidthCache {
    private final Editor myEditor;
    private final IntIntHashMap myCache = new IntIntHashMap();

    public CharWidthCache(Editor editor) {
        this.myEditor = editor;
    }

    public int charWidth(char c, @JdkConstants.FontStyle int fontType) {
        int key = c + fontType * 65536;
        int width = this.myCache.get(key);
        if (width < 0) {
            width = EditorUtil.charWidth(c, fontType, this.myEditor);
            this.myCache.put(key, width);
        }
        return width;
    }
}

