/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.impl.ColorProvider;
import com.intellij.openapi.util.Computable;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import org.jetbrains.annotations.NotNull;

public class ArrowPainter {
    private final ColorProvider myColorHolder;
    private final Computable<Integer> myWidthProvider;
    private final Computable<Integer> myHeightProvider;

    public ArrowPainter(@NotNull ColorProvider colorHolder, @NotNull Computable<Integer> widthProvider, @NotNull Computable<Integer> heightProvider) {
        this.myColorHolder = colorHolder;
        this.myWidthProvider = widthProvider;
        this.myHeightProvider = heightProvider;
    }

    public void paint(Graphics g, int y, int start, int stop2) {
        stop2 -= (Integer)this.myWidthProvider.compute() / 4;
        Color oldColor = g.getColor();
        g.setColor(this.myColorHolder.getColor());
        int height = (Integer)this.myHeightProvider.compute();
        int halfHeight = height / 2;
        int mid = y - halfHeight;
        int top = y - height;
        UIUtil.drawLine((Graphics)g, (int)start, (int)mid, (int)stop2, (int)mid);
        UIUtil.drawLine((Graphics)g, (int)stop2, (int)y, (int)stop2, (int)top);
        g.fillPolygon(new int[]{stop2 - halfHeight, stop2 - halfHeight, stop2}, new int[]{y, y - height, y - halfHeight}, 3);
        g.setColor(oldColor);
    }
}

