/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.diagnostic.Dumpable;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.SoftWrapModelEx;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.IterationState;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.editor.textarea.TextComponentEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.DocumentUtil;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorUtil {
    private static final Logger LOG = Logger.getInstance(EditorUtil.class);

    private EditorUtil() {
    }

    public static boolean isRealFileEditor(@Nullable Editor editor) {
        return editor != null && TextEditorProvider.getInstance().getTextEditor(editor) instanceof TextEditorImpl;
    }

    public static int getLastVisualLineColumnNumber(@NotNull Editor editor, int line) {
        if (editor instanceof EditorImpl && ((EditorImpl)editor).myUseNewRendering) {
            LogicalPosition lineEndPosition = editor.visualToLogicalPosition(new VisualPosition(line, Integer.MAX_VALUE));
            int lineEndOffset = editor.logicalPositionToOffset(lineEndPosition);
            return editor.offsetToVisualPosition((int)lineEndOffset, (boolean)true, (boolean)true).column;
        }
        Document document = editor.getDocument();
        int lastLine = document.getLineCount() - 1;
        if (lastLine < 0) {
            return 0;
        }
        VisualPosition visStart = new VisualPosition(line, 0);
        LogicalPosition logStart = editor.visualToLogicalPosition(visStart);
        int lastLogLine = logStart.line;
        while (lastLogLine < document.getLineCount() - 1) {
            logStart = new LogicalPosition(logStart.line + 1, logStart.column);
            VisualPosition tryVisible = editor.logicalToVisualPosition(logStart);
            if (tryVisible.line != visStart.line) break;
            lastLogLine = logStart.line;
        }
        int resultLogLine = Math.min(lastLogLine, lastLine);
        VisualPosition resVisStart = editor.offsetToVisualPosition(document.getLineStartOffset(resultLogLine));
        VisualPosition resVisEnd = editor.offsetToVisualPosition(document.getLineEndOffset(resultLogLine));
        if (resVisStart.line == resVisEnd.line) {
            return resVisEnd.column;
        }
        int visualLinesToSkip = line - resVisStart.line;
        List softWraps = editor.getSoftWrapModel().getSoftWrapsForLine(resultLogLine);
        for (int i = 0; i < softWraps.size(); ++i) {
            SoftWrap softWrap = (SoftWrap)softWraps.get(i);
            CharSequence text = document.getCharsSequence();
            if (visualLinesToSkip <= 0) {
                VisualPosition visual = editor.offsetToVisualPosition(softWrap.getStart() - 1);
                int result = visual.column;
                int x = editor.visualPositionToXY((VisualPosition)visual).x;
                return result + EditorUtil.textWidthInColumns(editor, text, softWrap.getStart() - 1, softWrap.getStart(), x);
            }
            int softWrapLineFeeds = StringUtil.countNewLines((CharSequence)softWrap.getText());
            if (softWrapLineFeeds < visualLinesToSkip) {
                visualLinesToSkip -= softWrapLineFeeds;
                continue;
            }
            if (softWrapLineFeeds == visualLinesToSkip) {
                if (i >= softWraps.size() - 1) {
                    return resVisEnd.column;
                }
                SoftWrap nextSoftWrap = (SoftWrap)softWraps.get(i + 1);
                VisualPosition visual = editor.offsetToVisualPosition(nextSoftWrap.getStart() - 1);
                int result = visual.column;
                int x = editor.visualPositionToXY((VisualPosition)visual).x;
                result += EditorUtil.textWidthInColumns(editor, text, nextSoftWrap.getStart() - 1, nextSoftWrap.getStart(), x);
                int lineFeedIndex = StringUtil.indexOf((CharSequence)nextSoftWrap.getText(), (char)'\n');
                return result += EditorUtil.textWidthInColumns(editor, nextSoftWrap.getText(), 0, lineFeedIndex, 0);
            }
            int softWrapStartOffset = 0;
            int softWrapEndOffset = 0;
            int softWrapTextLength = softWrap.getText().length();
            while (visualLinesToSkip-- > 0) {
                softWrapStartOffset = softWrapEndOffset + 1;
                if (softWrapStartOffset >= softWrapTextLength) {
                    assert (false);
                    return resVisEnd.column;
                }
                softWrapEndOffset = StringUtil.indexOf((CharSequence)softWrap.getText(), (char)'\n', (int)softWrapStartOffset, (int)softWrapTextLength);
                if (softWrapEndOffset >= 0) continue;
                assert (false);
                return resVisEnd.column;
            }
            VisualPosition visual = editor.offsetToVisualPosition(softWrap.getStart() - 1);
            int result = visual.column;
            int x = editor.visualPositionToXY((VisualPosition)visual).x;
            result += EditorUtil.textWidthInColumns(editor, text, softWrap.getStart() - 1, softWrap.getStart(), x);
            return result += EditorUtil.calcColumnNumber(editor, softWrap.getText(), softWrapStartOffset, softWrapEndOffset);
        }
        String editorInfo = editor instanceof EditorImpl ? ((EditorImpl)editor).dumpState() : "editor's class: " + editor.getClass() + ", all soft wraps: " + editor.getSoftWrapModel().getSoftWrapsForRange(0, document.getTextLength()) + ", fold regions: " + Arrays.toString(editor.getFoldingModel().getAllFoldRegions());
        LogMessageEx.error(LOG, "Can't calculate last visual column", String.format("Target visual line: %d, mapped logical line: %d, visual lines range for the mapped logical line: [%s]-[%s], soft wraps for the target logical line: %s. Editor info: %s", line, resultLogLine, resVisStart, resVisEnd, softWraps, editorInfo));
        return resVisEnd.column;
    }

    public static int getVisualLineEndOffset(@NotNull Editor editor, int line) {
        VisualPosition endLineVisualPosition = new VisualPosition(line, EditorUtil.getLastVisualLineColumnNumber(editor, line));
        LogicalPosition endLineLogicalPosition = editor.visualToLogicalPosition(endLineVisualPosition);
        return editor.logicalPositionToOffset(endLineLogicalPosition);
    }

    public static float calcVerticalScrollProportion(@NotNull Editor editor) {
        Rectangle viewArea = editor.getScrollingModel().getVisibleAreaOnScrollingFinished();
        if (viewArea.height == 0) {
            return 0.0f;
        }
        LogicalPosition pos = editor.getCaretModel().getLogicalPosition();
        Point location = editor.logicalPositionToXY(pos);
        return (float)(location.y - viewArea.y) / (float)viewArea.height;
    }

    public static void setVerticalScrollProportion(@NotNull Editor editor, float proportion) {
        Rectangle viewArea = editor.getScrollingModel().getVisibleArea();
        LogicalPosition caretPosition = editor.getCaretModel().getLogicalPosition();
        Point caretLocation = editor.logicalPositionToXY(caretPosition);
        int yPos = caretLocation.y;
        yPos = (int)((float)yPos - (float)viewArea.height * proportion);
        editor.getScrollingModel().scrollVertically(yPos);
    }

    public static int calcRelativeCaretPosition(@NotNull Editor editor) {
        int caretY = editor.getCaretModel().getVisualPosition().line * editor.getLineHeight();
        int viewAreaPosition = editor.getScrollingModel().getVisibleAreaOnScrollingFinished().y;
        return caretY - viewAreaPosition;
    }

    public static void setRelativeCaretPosition(@NotNull Editor editor, int position) {
        int caretY = editor.getCaretModel().getVisualPosition().line * editor.getLineHeight();
        editor.getScrollingModel().scrollVertically(caretY - position);
    }

    public static void fillVirtualSpaceUntilCaret(@NotNull Editor editor) {
        LogicalPosition position = editor.getCaretModel().getLogicalPosition();
        EditorUtil.fillVirtualSpaceUntil(editor, position.column, position.line);
    }

    public static void fillVirtualSpaceUntil(final @NotNull Editor editor, int columnNumber, int lineNumber) {
        final int offset = editor.logicalPositionToOffset(new LogicalPosition(lineNumber, columnNumber));
        final String filler = EditorModificationUtil.calcStringToFillVirtualSpace((Editor)editor);
        if (!filler.isEmpty()) {
            new WriteAction(){

                protected void run(@NotNull Result result) throws Throwable {
                    editor.getDocument().insertString(offset, (CharSequence)filler);
                    editor.getCaretModel().moveToOffset(offset + filler.length());
                }
            }.execute();
        }
    }

    public static int calcOffset(@NotNull EditorEx editor, @NotNull CharSequence text, int start, int end, int columnNumber, int tabSize, @Nullable StringBuilder debugBuffer) {
        assert (start >= 0) : "start (" + start + ") must not be negative. end (" + end + ")";
        assert (end >= start) : "start (" + start + ") must not be greater than end (" + end + ")";
        if (debugBuffer != null) {
            debugBuffer.append(String.format("Starting calcOffset(). Start=%d, end=%d, column number=%d, tab size=%d%n", start, end, columnNumber, tabSize));
        }
        int maxScanIndex = Math.min(start + columnNumber + 1, end);
        SoftWrapModelEx softWrapModel = editor.getSoftWrapModel();
        List softWraps = softWrapModel.getSoftWrapsForRange(start, maxScanIndex);
        int startToUse = start;
        int x = editor.getDocument().getLineNumber(start) == 0 ? editor.getPrefixTextWidthInPixels() : 0;
        int[] currentColumn = new int[]{0};
        for (SoftWrap softWrap : softWraps) {
            if (currentColumn[0] >= columnNumber) {
                return startToUse;
            }
            int result = EditorUtil.calcSoftWrapUnawareOffset(editor, text, startToUse, softWrap.getEnd(), columnNumber, tabSize, x, currentColumn, debugBuffer);
            if (result >= 0) {
                return result;
            }
            startToUse = softWrap.getStart();
            x = softWrap.getIndentInPixels();
        }
        if (currentColumn[0] >= columnNumber) {
            return startToUse;
        }
        int result = EditorUtil.calcSoftWrapUnawareOffset(editor, text, startToUse, end, columnNumber, tabSize, x, currentColumn, debugBuffer);
        if (result >= 0) {
            return result;
        }
        if (debugBuffer != null) {
            debugBuffer.append(String.format("Returning %d as no match has been found for the target column (%d) at the target range [%d;%d)", end, columnNumber, start, end));
        }
        return end;
    }

    public static int calcSoftWrapUnawareOffset(@NotNull Editor editor, @NotNull CharSequence text, int start, int end, int columnNumber, int tabSize, int x, @NotNull int[] currentColumn, @Nullable StringBuilder debugBuffer) {
        int offset;
        char c;
        boolean hasTabs;
        if (debugBuffer != null) {
            debugBuffer.append(String.format("Starting calcSoftWrapUnawareOffset(). Target range: [%d; %d), target column number to map: %d, tab size: %d, x: %d, current column: %d%n", start, end, columnNumber, tabSize, x, currentColumn[0]));
        }
        boolean useOptimization = true;
        if (editor instanceof EditorImpl && !((EditorImpl)editor).hasTabs()) {
            hasTabs = false;
            useOptimization = true;
        } else {
            hasTabs = false;
            int scanEndOffset = Math.min(end, start + columnNumber - currentColumn[0] + 1);
            boolean hasNonTabs = false;
            for (int i = start; i < scanEndOffset; ++i) {
                c = text.charAt(i);
                if (debugBuffer != null) {
                    debugBuffer.append(String.format("Found symbol '%c' at the offset %d%n", Character.valueOf(c), i));
                }
                if (c == '\t') {
                    hasTabs = true;
                    if (!hasNonTabs) continue;
                    useOptimization = false;
                    break;
                }
                hasNonTabs = true;
            }
        }
        if (debugBuffer != null) {
            debugBuffer.append(String.format("Has tabs: %b, use optimisation: %b%n", hasTabs, useOptimization));
        }
        if (useOptimization) {
            if (!hasTabs) {
                int result = start + columnNumber - currentColumn[0];
                if (result < end) {
                    return result;
                }
                currentColumn[0] = currentColumn[0] + (end - start);
                if (debugBuffer != null) {
                    debugBuffer.append(String.format("Incrementing 'current column' by %d (new value is %d)%n", end - start, currentColumn[0]));
                }
                return -1;
            }
            int shift = 0;
            offset = start;
            int prevX = x;
            if (debugBuffer != null) {
                debugBuffer.append("Processing a string that contains only tabs\n");
            }
            while (offset < end && offset + shift + currentColumn[0] < start + columnNumber) {
                c = text.charAt(offset);
                if (c == '\t') {
                    int nextX = EditorUtil.nextTabStop(prevX, editor, tabSize);
                    int columnsShift = EditorUtil.columnsNumber(nextX - prevX, EditorUtil.getSpaceWidth(0, editor)) - 1;
                    if (debugBuffer != null) {
                        debugBuffer.append(String.format("Processing tabulation symbol at the offset %d. Current X: %d, new X: %d, current columns shift: %d, new column shift: %d%n", offset, prevX, nextX, shift, shift + columnsShift));
                    }
                    shift += columnsShift;
                    prevX = nextX;
                }
                ++offset;
            }
            int diff = start + columnNumber - offset - shift - currentColumn[0];
            if (debugBuffer != null) {
                debugBuffer.append(String.format("Resulting diff: %d%n", diff));
            }
            if (diff < 0) {
                return offset - 1;
            }
            if (diff == 0) {
                return offset;
            }
            int inc = offset - start + shift;
            if (debugBuffer != null) {
                debugBuffer.append(String.format("Incrementing 'current column' by %d (new value is %d)%n", inc, currentColumn[0] + inc));
            }
            currentColumn[0] = currentColumn[0] + inc;
            return -1;
        }
        EditorEx editorImpl = (EditorEx)editor;
        IterationState state = new IterationState(editorImpl, start, end, false);
        int fontType = state.getMergedAttributes().getFontType();
        int column = currentColumn[0];
        int plainSpaceSize = EditorUtil.getSpaceWidth(0, editorImpl);
        for (offset = start; column < columnNumber && offset < end; ++offset) {
            char c2;
            if (offset >= state.getEndOffset()) {
                state.advance();
                fontType = state.getMergedAttributes().getFontType();
            }
            if ((c2 = text.charAt(offset)) == '\t') {
                int newX = EditorUtil.nextTabStop(x, editorImpl);
                int columns = EditorUtil.columnsNumber(newX - x, plainSpaceSize);
                if (debugBuffer != null) {
                    debugBuffer.append(String.format("Processing tabulation at the offset %d. Current X: %d, new X: %d, current column: %d, new column: %d%n", offset, x, newX, column, column + columns));
                }
                x = newX;
                column += columns;
                continue;
            }
            int width = EditorUtil.charWidth(c2, fontType, editorImpl);
            if (debugBuffer != null) {
                debugBuffer.append(String.format("Processing symbol '%c' at the offset %d. Current X: %d, new X: %d%n", Character.valueOf(c2), offset, x, x + width));
            }
            x += width;
            ++column;
        }
        if (column == columnNumber) {
            return offset;
        }
        if (column > columnNumber && offset > 0 && text.charAt(offset - 1) == '\t') {
            return offset - 1;
        }
        currentColumn[0] = column;
        return -1;
    }

    private static int getTabLength(int colNumber, int tabSize) {
        if (tabSize <= 0) {
            tabSize = 1;
        }
        return tabSize - colNumber % tabSize;
    }

    public static int calcColumnNumber(@NotNull Editor editor, @NotNull CharSequence text, int start, int offset) {
        return EditorUtil.calcColumnNumber(editor, text, start, offset, EditorUtil.getTabSize(editor));
    }

    public static int calcColumnNumber(@Nullable Editor editor, @NotNull CharSequence text, int start, int offset, int tabSize) {
        if (editor instanceof TextComponentEditor) {
            return offset - start;
        }
        boolean useOptimization = true;
        if (editor != null) {
            SoftWrap softWrap = editor.getSoftWrapModel().getSoftWrap(start);
            useOptimization = softWrap == null;
        }
        boolean hasTabs = true;
        if (useOptimization) {
            if (editor instanceof EditorImpl && !((EditorImpl)editor).hasTabs()) {
                hasTabs = false;
            } else {
                boolean hasNonTabs = false;
                for (int i = start; i < offset; ++i) {
                    if (text.charAt(i) == '\t') {
                        if (!hasNonTabs) continue;
                        useOptimization = false;
                        break;
                    }
                    hasNonTabs = true;
                }
            }
        }
        if (editor == null || useOptimization) {
            Document document;
            Document document2 = document = editor == null ? null : editor.getDocument();
            if (document != null && start < offset - 1 && document.getLineNumber(start) != document.getLineNumber(offset - 1)) {
                String editorInfo = editor instanceof EditorImpl ? ". Editor info: " + ((EditorImpl)editor).dumpState() : "";
                String documentInfo = text instanceof Dumpable ? ((Dumpable)text).dumpState() : "Text holder class: " + text.getClass();
                LogMessageEx.error(LOG, "detected incorrect offset -> column number calculation", "start: " + start + ", given offset: " + offset + ", given tab size: " + tabSize + ". " + documentInfo + editorInfo);
            }
            int shift = 0;
            if (hasTabs) {
                for (int i = start; i < offset; ++i) {
                    char c = text.charAt(i);
                    if (c != '\t') continue;
                    shift += EditorUtil.getTabLength(i + shift - start, tabSize) - 1;
                }
            }
            return offset - start + shift;
        }
        EditorEx editorImpl = (EditorEx)editor;
        return editorImpl.calcColumnNumber(text, start, offset, tabSize);
    }

    public static void setHandCursor(@NotNull Editor view) {
        Cursor c = Cursor.getPredefinedCursor(12);
        if (view.getContentComponent().getCursor() != c) {
            view.getContentComponent().setCursor(c);
        }
    }

    @NotNull
    public static FontInfo fontForChar(char c, @JdkConstants.FontStyle int style, @NotNull Editor editor) {
        EditorColorsScheme colorsScheme = editor.getColorsScheme();
        return ComplementaryFontsRegistry.getFontAbleToDisplay(c, style, colorsScheme.getFontPreferences());
    }

    public static Icon scaleIconAccordingEditorFont(Icon icon, Editor editor) {
        float scale;
        if (Registry.is((String)"editor.scale.gutter.icons") && editor instanceof EditorImpl && icon instanceof ScalableIcon && Math.abs(1.0f - (scale = ((EditorImpl)editor).getScale())) > 0.1f) {
            return ((ScalableIcon)icon).scale(scale);
        }
        return icon;
    }

    public static int charWidth(char c, @JdkConstants.FontStyle int fontType, @NotNull Editor editor) {
        return EditorUtil.fontForChar(c, fontType, editor).charWidth(c);
    }

    public static int getSpaceWidth(@JdkConstants.FontStyle int fontType, @NotNull Editor editor) {
        int width = EditorUtil.charWidth(' ', fontType, editor);
        return width > 0 ? width : 1;
    }

    public static int getPlainSpaceWidth(@NotNull Editor editor) {
        return EditorUtil.getSpaceWidth(0, editor);
    }

    public static int getTabSize(@NotNull Editor editor) {
        return editor.getSettings().getTabSize(editor.getProject());
    }

    public static int nextTabStop(int x, @NotNull Editor editor) {
        int tabSize = EditorUtil.getTabSize(editor);
        if (tabSize <= 0) {
            tabSize = 1;
        }
        return EditorUtil.nextTabStop(x, editor, tabSize);
    }

    public static int nextTabStop(int x, @NotNull Editor editor, int tabSize) {
        return EditorUtil.nextTabStop(x, EditorUtil.getSpaceWidth(0, editor), tabSize);
    }

    public static int nextTabStop(int x, int plainSpaceWidth, int tabSize) {
        if (tabSize <= 0) {
            return x + plainSpaceWidth;
        }
        int nTabs = x / (tabSize *= plainSpaceWidth);
        return (nTabs + 1) * tabSize;
    }

    public static int textWidthInColumns(@NotNull Editor editor, @NotNull CharSequence text, int start, int end, int x) {
        int startToUse = start;
        int lastTabSymbolIndex = -1;
        block8: for (int i = end - 1; i >= start; --i) {
            switch (text.charAt(i)) {
                case '\n': {
                    startToUse = i + 1;
                    break block8;
                }
                case '\t': {
                    if (lastTabSymbolIndex < 0) {
                        lastTabSymbolIndex = i;
                    }
                }
                default: {
                    continue block8;
                }
            }
        }
        if (lastTabSymbolIndex < 0) {
            return end - startToUse;
        }
        int result = 0;
        int spaceSize = EditorUtil.getSpaceWidth(0, editor);
        block9: for (int i = startToUse; i <= lastTabSymbolIndex; ++i) {
            SoftWrap softWrap = editor.getSoftWrapModel().getSoftWrap(i);
            if (softWrap != null) {
                x = softWrap.getIndentInPixels();
            }
            char c = text.charAt(i);
            int prevX = x;
            switch (c) {
                case '\t': {
                    x = EditorUtil.nextTabStop(x, editor);
                    result += EditorUtil.columnsNumber(x - prevX, spaceSize);
                    continue block9;
                }
                case '\n': {
                    result = 0;
                    x = 0;
                    continue block9;
                }
                default: {
                    x += EditorUtil.charWidth(c, 0, editor);
                    ++result;
                }
            }
        }
        return result += end - lastTabSymbolIndex - 1;
    }

    public static int columnsNumber(char c, int x, int prevX, int plainSpaceSize) {
        if (c != '\t') {
            return 1;
        }
        int result = (x - prevX) / plainSpaceSize;
        if ((x - prevX) % plainSpaceSize > 0) {
            ++result;
        }
        return result;
    }

    public static int columnsNumber(int width, int plainSpaceSize) {
        int result = width / plainSpaceSize;
        if (width % plainSpaceSize > 0) {
            ++result;
        }
        return result;
    }

    public static int textWidth(@NotNull Editor editor, @NotNull CharSequence text, int start, int end, @JdkConstants.FontStyle int fontType, int x) {
        int result = 0;
        for (int i = start; i < end; ++i) {
            char c = text.charAt(i);
            if (c != '\t') {
                FontInfo font = EditorUtil.fontForChar(c, fontType, editor);
                result += font.charWidth(c);
                continue;
            }
            result += EditorUtil.nextTabStop(x + result, editor) - result - x;
        }
        return result;
    }

    public static Pair<LogicalPosition, LogicalPosition> calcCaretLineRange(@NotNull Editor editor) {
        return EditorUtil.calcSurroundingRange(editor, editor.getCaretModel().getVisualPosition(), editor.getCaretModel().getVisualPosition());
    }

    public static Pair<LogicalPosition, LogicalPosition> calcSurroundingRange(@NotNull Editor editor, @NotNull VisualPosition start, @NotNull VisualPosition end) {
        Document document = editor.getDocument();
        FoldingModel foldingModel = editor.getFoldingModel();
        LogicalPosition first = editor.visualToLogicalPosition(new VisualPosition(start.line, 0));
        int line = first.line;
        int offset = document.getLineStartOffset(line);
        while (offset >= 0) {
            FoldRegion foldRegion = foldingModel.getCollapsedRegionAtOffset(offset);
            if (foldRegion == null) {
                first = new LogicalPosition(line, 0);
                break;
            }
            int foldEndLine = document.getLineNumber(foldRegion.getStartOffset());
            if (foldEndLine <= line) {
                first = new LogicalPosition(line, 0);
                break;
            }
            line = foldEndLine;
            offset = document.getLineStartOffset(line);
        }
        LogicalPosition second = editor.visualToLogicalPosition(new VisualPosition(end.line, 0));
        int line2 = second.line;
        int offset2 = document.getLineEndOffset(line2);
        while (offset2 <= document.getTextLength()) {
            FoldRegion foldRegion = foldingModel.getCollapsedRegionAtOffset(offset2);
            if (foldRegion == null) {
                second = new LogicalPosition(line2 + 1, 0);
                break;
            }
            int foldEndLine = document.getLineNumber(foldRegion.getEndOffset());
            if (foldEndLine <= line2) {
                second = new LogicalPosition(line2 + 1, 0);
                break;
            }
            line2 = foldEndLine;
            offset2 = document.getLineEndOffset(line2);
        }
        if (second.line >= document.getLineCount()) {
            second = editor.offsetToLogicalPosition(document.getTextLength());
        }
        return Pair.create((Object)first, (Object)second);
    }

    public static int getNotFoldedLineStartOffset(@NotNull Editor editor, int offset) {
        while (true) {
            offset = DocumentUtil.getLineStartOffset(offset, editor.getDocument());
            FoldRegion foldRegion = editor.getFoldingModel().getCollapsedRegionAtOffset(offset - 1);
            if (foldRegion == null || foldRegion.getStartOffset() >= offset) break;
            offset = foldRegion.getStartOffset();
        }
        return offset;
    }

    public static int getNotFoldedLineEndOffset(@NotNull Editor editor, int offset) {
        while (true) {
            offset = EditorUtil.getLineEndOffset(offset, editor.getDocument());
            FoldRegion foldRegion = editor.getFoldingModel().getCollapsedRegionAtOffset(offset);
            if (foldRegion == null || foldRegion.getEndOffset() <= offset) break;
            offset = foldRegion.getEndOffset();
        }
        return offset;
    }

    private static int getLineEndOffset(int offset, Document document) {
        if (offset >= document.getTextLength()) {
            return offset;
        }
        int lineNumber = document.getLineNumber(offset);
        return document.getLineEndOffset(lineNumber);
    }

    public static void scrollToTheEnd(@NotNull Editor editor) {
        editor.getSelectionModel().removeSelection();
        int lastLine = Math.max(0, editor.getDocument().getLineCount() - 1);
        if (editor.getCaretModel().getLogicalPosition().line == lastLine) {
            editor.getCaretModel().moveToOffset(editor.getDocument().getTextLength());
        } else {
            editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(lastLine, 0));
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    public static boolean isChangeFontSize(@NotNull MouseWheelEvent e) {
        return SystemInfo.isMac ? !e.isControlDown() && e.isMetaDown() && !e.isAltDown() && !e.isShiftDown() : e.isControlDown() && !e.isMetaDown() && !e.isAltDown() && !e.isShiftDown();
    }

    public static boolean inVirtualSpace(@NotNull Editor editor, @NotNull LogicalPosition logicalPosition) {
        return !editor.offsetToLogicalPosition(editor.logicalPositionToOffset(logicalPosition)).equals((Object)logicalPosition);
    }

    public static void reinitSettings() {
        EditorFactory.getInstance().refreshAllEditors();
    }

    @NotNull
    public static TextRange getSelectionInAnyMode(Editor editor) {
        SelectionModel selection = editor.getSelectionModel();
        int[] starts = selection.getBlockSelectionStarts();
        int[] ends = selection.getBlockSelectionEnds();
        int start = starts.length > 0 ? starts[0] : selection.getSelectionStart();
        int end = ends.length > 0 ? ends[ends.length - 1] : selection.getSelectionEnd();
        return TextRange.create((int)start, (int)end);
    }

    public static int yPositionToLogicalLine(@NotNull Editor editor, @NotNull MouseEvent event) {
        return EditorUtil.yPositionToLogicalLine(editor, event.getY());
    }

    public static int yPositionToLogicalLine(@NotNull Editor editor, @NotNull Point point) {
        return EditorUtil.yPositionToLogicalLine(editor, point.y);
    }

    public static int yPositionToLogicalLine(@NotNull Editor editor, int y) {
        int line = editor instanceof EditorImpl ? ((EditorImpl)editor).yToVisibleLine(y) : y / editor.getLineHeight();
        return line > 0 ? editor.visualToLogicalPosition((VisualPosition)new VisualPosition((int)line, (int)0)).line : 0;
    }

    public static boolean isAtLineEnd(@NotNull Editor editor, int offset) {
        Document document = editor.getDocument();
        if (offset < 0 || offset > document.getTextLength()) {
            return false;
        }
        int line = document.getLineNumber(offset);
        return offset == document.getLineEndOffset(line);
    }

    public static void setSelectionExpandingFoldedRegionsIfNeeded(@NotNull Editor editor, int startOffset, int endOffset) {
        FoldRegion endFoldRegion;
        FoldingModel foldingModel = editor.getFoldingModel();
        FoldRegion startFoldRegion = foldingModel.getCollapsedRegionAtOffset(startOffset);
        if (startFoldRegion != null && (startFoldRegion.getStartOffset() == startOffset || startFoldRegion.isExpanded())) {
            startFoldRegion = null;
        }
        if ((endFoldRegion = foldingModel.getCollapsedRegionAtOffset(endOffset)) != null && (endFoldRegion.getStartOffset() == endOffset || endFoldRegion.isExpanded())) {
            endFoldRegion = null;
        }
        if (startFoldRegion != null || endFoldRegion != null) {
            final FoldRegion finalStartFoldRegion = startFoldRegion;
            final FoldRegion finalEndFoldRegion = endFoldRegion;
            foldingModel.runBatchFoldingOperation(new Runnable(){

                @Override
                public void run() {
                    if (finalStartFoldRegion != null) {
                        finalStartFoldRegion.setExpanded(true);
                    }
                    if (finalEndFoldRegion != null) {
                        finalEndFoldRegion.setExpanded(true);
                    }
                }
            });
        }
        editor.getSelectionModel().setSelection(startOffset, endOffset);
    }

    public static Font getEditorFont() {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        int size = UISettings.getInstance().PRESENTATION_MODE ? UISettings.getInstance().PRESENTATION_MODE_FONT_SIZE - 4 : scheme.getEditorFontSize();
        return new Font(scheme.getEditorFontName(), 0, size);
    }

    public static int getSoftWrapCountAfterLineStart(@NotNull Editor editor, @NotNull LogicalPosition position) {
        if (position.visualPositionAware) {
            return position.softWrapLinesOnCurrentLogicalLine;
        }
        int startOffset = editor.getDocument().getLineStartOffset(position.line);
        int endOffset = editor.logicalPositionToOffset(position);
        return editor.getSoftWrapModel().getSoftWrapsForRange(startOffset, endOffset).size();
    }

    public static boolean attributesImpactFontStyle(@Nullable TextAttributes attributes) {
        return attributes == TextAttributes.ERASE_MARKER || attributes != null && attributes.getFontType() != 0;
    }
}

