/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.util.Comparing;
import java.awt.Color;
import org.jetbrains.annotations.Nullable;

public class EditorColorsSchemeImpl
extends AbstractColorsScheme
implements ExternalizableScheme {
    public EditorColorsSchemeImpl(EditorColorsScheme parentScheme) {
        super(parentScheme);
    }

    public void setAttributes(TextAttributesKey key, TextAttributes attributes) {
        if (attributes != this.getAttributes(key)) {
            this.myAttributesMap.put(key, attributes);
        }
    }

    public void setColor(ColorKey key, Color color) {
        if (!Comparing.equal((Object)color, (Object)this.getColor(key))) {
            this.myColorsMap.put(key, color);
        }
    }

    public TextAttributes getAttributes(TextAttributesKey key) {
        if (key != null) {
            TextAttributesKey fallbackKey = key.getFallbackAttributeKey();
            TextAttributes attributes = this.getDirectlyDefinedAttributes(key);
            if (fallbackKey == null) {
                if (EditorColorsSchemeImpl.containsValue(attributes)) {
                    return attributes;
                }
            } else {
                if (EditorColorsSchemeImpl.containsValue(attributes) && !attributes.isFallbackEnabled()) {
                    return attributes;
                }
                attributes = this.getFallbackAttributes(fallbackKey);
                if (EditorColorsSchemeImpl.containsValue(attributes)) {
                    return attributes;
                }
            }
        }
        return this.myParentScheme.getAttributes(key);
    }

    @Nullable
    public Color getColor(ColorKey key) {
        if (this.myColorsMap.containsKey(key)) {
            return (Color)this.myColorsMap.get(key);
        }
        return this.myParentScheme.getColor(key);
    }

    @Override
    public Object clone() {
        EditorColorsSchemeImpl newScheme = new EditorColorsSchemeImpl(this.myParentScheme);
        this.copyTo(newScheme);
        newScheme.setName(this.getName());
        return newScheme;
    }
}

