/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlipCommaIntention
implements IntentionAction {
    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @NotNull
    public String getFamilyName() {
        return "Flip ','";
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        PsiElement comma = FlipCommaIntention.currentCommaElement(editor, file2);
        return comma != null && FlipCommaIntention.smartAdvance(comma, true) != null && FlipCommaIntention.smartAdvance(comma, false) != null;
    }

    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        PsiElement element = FlipCommaIntention.currentCommaElement(editor, file2);
        if (element != null) {
            FlipCommaIntention.swapAtComma(element);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static void swapAtComma(@NotNull PsiElement comma) {
        PsiElement prev = FlipCommaIntention.smartAdvance(comma, false);
        PsiElement next = FlipCommaIntention.smartAdvance(comma, true);
        if (prev != null && next != null) {
            if (Flipper.tryFlip(prev, next)) {
                return;
            }
            PsiElement copy = prev.copy();
            prev.replace(next);
            next.replace(copy);
        }
    }

    private static PsiElement currentCommaElement(@NotNull Editor editor, @NotNull PsiFile file2) {
        PsiElement element = FlipCommaIntention.leftElement(editor, file2);
        if (!FlipCommaIntention.isComma(element) && !FlipCommaIntention.isComma(element = FlipCommaIntention.rightElement(editor, file2))) {
            return null;
        }
        return element;
    }

    @Nullable
    private static PsiElement leftElement(@NotNull Editor editor, @NotNull PsiFile file2) {
        return file2.findElementAt(editor.getCaretModel().getOffset() - 1);
    }

    @Nullable
    private static PsiElement rightElement(@NotNull Editor editor, @NotNull PsiFile file2) {
        return file2.findElementAt(editor.getCaretModel().getOffset());
    }

    private static boolean isComma(@Nullable PsiElement element) {
        return element != null && element.getText().equals(",");
    }

    @Nullable
    private static PsiElement smartAdvance(PsiElement element, boolean fwd) {
        Class[] skipTypes = new Class[]{PsiWhiteSpace.class, PsiComment.class};
        return fwd ? PsiTreeUtil.skipSiblingsForward((PsiElement)element, (Class[])skipTypes) : PsiTreeUtil.skipSiblingsBackward((PsiElement)element, (Class[])skipTypes);
    }

    public static interface Flipper {
        public static final LanguageExtension<Flipper> EXTENSION = new LanguageExtension("com.intellij.flipCommaIntention.flipper");

        public boolean flip(PsiElement var1, PsiElement var2);

        public static boolean tryFlip(PsiElement left, PsiElement right) {
            Language language = left.getLanguage();
            for (Flipper handler2 : EXTENSION.allForLanguage(language)) {
                if (!handler2.flip(left, right)) continue;
                return true;
            }
            return false;
        }
    }
}

