/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.project.DumbAware;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractToggleUseSoftWrapsAction
extends ToggleAction
implements DumbAware {
    private final SoftWrapAppliancePlaces myAppliancePlace;
    private final boolean myGlobal;

    public AbstractToggleUseSoftWrapsAction(@NotNull SoftWrapAppliancePlaces appliancePlace, boolean global) {
        this.myAppliancePlace = appliancePlace;
        this.myGlobal = global;
    }

    public boolean isSelected(AnActionEvent e) {
        Editor editor = this.getEditor(e);
        return editor != null && editor.getSettings().isUseSoftWraps();
    }

    public void setSelected(AnActionEvent e, boolean state) {
        Editor editor = this.getEditor(e);
        if (editor == null) {
            return;
        }
        Point point = editor.getScrollingModel().getVisibleArea().getLocation();
        LogicalPosition anchorPosition = editor.xyToLogicalPosition(point);
        int intraLineShift = point.y - editor.logicalPositionToXY((LogicalPosition)anchorPosition).y;
        if (this.myGlobal) {
            EditorSettingsExternalizable.getInstance().setUseSoftWraps(state, this.myAppliancePlace);
        } else {
            editor.getSettings().setUseSoftWraps(state);
        }
        if (editor instanceof EditorEx) {
            ((EditorEx)editor).reinitSettings();
        }
        editor.getScrollingModel().disableAnimation();
        editor.getScrollingModel().scrollVertically(editor.logicalPositionToXY((LogicalPosition)anchorPosition).y + intraLineShift);
        editor.getScrollingModel().enableAnimation();
    }

    @Nullable
    protected Editor getEditor(AnActionEvent e) {
        return (Editor)e.getData(CommonDataKeys.EDITOR);
    }
}

