/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.editor.CaretStateTransferableData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClipboardTextPerCaretSplitter {
    @NotNull
    public List<String> split(@NotNull String input, @Nullable CaretStateTransferableData caretData, int caretCount) {
        if (caretCount <= 0) {
            throw new IllegalArgumentException("Caret count must be positive");
        }
        if (caretCount == 1) {
            return Collections.singletonList(input);
        }
        ArrayList<String> result = new ArrayList<String>(caretCount);
        int sourceCaretCount = caretData == null ? -1 : caretData.startOffsets.length;
        String[] lines = sourceCaretCount == 1 || sourceCaretCount == caretCount ? null : input.split("\n", -1);
        for (int i = 0; i < caretCount; ++i) {
            if (sourceCaretCount == 1) {
                result.add(input);
                continue;
            }
            if (sourceCaretCount == caretCount) {
                result.add(new String(input.substring(caretData.startOffsets[i], caretData.endOffsets[i])));
                continue;
            }
            if (lines.length == 0) {
                result.add("");
                continue;
            }
            if (lines.length == 1) {
                result.add(lines[0]);
                continue;
            }
            if (lines.length % caretCount == 0) {
                StringBuilder b = new StringBuilder();
                int linesPerSegment = lines.length / caretCount;
                for (int j = 0; j < linesPerSegment; ++j) {
                    if (j > 0) {
                        b.append('\n');
                    }
                    b.append(lines[i * linesPerSegment + j]);
                }
                result.add(b.toString());
                continue;
            }
            result.add(i < lines.length ? lines[i] : "");
        }
        return result;
    }
}

