/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.settings;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diff.impl.settings.DiffMergeEditorSetting;
import com.intellij.openapi.diff.impl.settings.DiffMergeSettings;
import com.intellij.openapi.editor.Editor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffMergeSettingsAction
extends ActionGroup {
    @NotNull
    private final Collection<Editor> myEditors;
    @NotNull
    private final DiffMergeSettings mySettings;

    public DiffMergeSettingsAction(@NotNull Collection<Editor> editors, @NotNull DiffMergeSettings settings) {
        super("Settings", null, AllIcons.General.SecondaryGroup);
        this.setPopup(true);
        this.myEditors = editors;
        this.mySettings = settings;
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        return new AnAction[]{new DiffMergeToggleAction("EditorToggleShowWhitespaces", DiffMergeEditorSetting.WHITESPACES, this.myEditors, this.mySettings), new DiffMergeToggleAction("EditorToggleShowLineNumbers", DiffMergeEditorSetting.LINE_NUMBERS, this.myEditors, this.mySettings), new DiffMergeToggleAction("EditorToggleShowIndentLines", DiffMergeEditorSetting.INDENT_LINES, this.myEditors, this.mySettings), new DiffMergeToggleAction("EditorToggleUseSoftWraps", DiffMergeEditorSetting.SOFT_WRAPS, this.myEditors, this.mySettings)};
    }

    private static class DiffMergeToggleAction
    extends ToggleAction {
        @NotNull
        private final DiffMergeEditorSetting mySetting;
        @NotNull
        private final Collection<Editor> myEditors;
        @NotNull
        private final DiffMergeSettings mySettings;

        private DiffMergeToggleAction(@NotNull String actionId, @NotNull DiffMergeEditorSetting setting, @NotNull Collection<Editor> editors, @NotNull DiffMergeSettings settings) {
            super(ActionsBundle.actionText((String)actionId), ActionsBundle.actionDescription((String)actionId), null);
            this.mySetting = setting;
            this.myEditors = editors;
            this.mySettings = settings;
        }

        public boolean isSelected(AnActionEvent e) {
            return this.getPreference(this.mySetting);
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.setPreference(this.mySetting, state);
            for (Editor editor : this.myEditors) {
                this.mySetting.apply(editor, state);
            }
        }

        private void setPreference(DiffMergeEditorSetting preference, boolean state) {
            this.mySettings.setPreference(preference, state);
        }

        private boolean getPreference(DiffMergeEditorSetting preference) {
            return this.mySettings.getPreference(preference);
        }
    }
}

