/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.formove;

import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryException;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diff.impl.patch.ApplyPatchContext;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.apply.ApplyTextFilePatch;
import com.intellij.openapi.diff.impl.patch.formove.CustomBinaryPatchApplier;
import com.intellij.openapi.diff.impl.patch.formove.PathMerger;
import com.intellij.openapi.diff.impl.patch.formove.PathsVerifier;
import com.intellij.openapi.diff.impl.patch.formove.TriggerAdditionOrDeletion;
import com.intellij.openapi.diff.impl.patch.formove.UndoApplyPatchDialog;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsFileListenerContextHelper;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchAction;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatchApplier<BinaryType extends FilePatch> {
    private final Project myProject;
    private final VirtualFile myBaseDirectory;
    @NotNull
    private final List<FilePatch> myPatches;
    private final CustomBinaryPatchApplier<BinaryType> myCustomForBinaries;
    private final CommitContext myCommitContext;
    private final Consumer<Collection<FilePath>> myToTargetListsMover;
    @NotNull
    private final List<FilePatch> myRemainingPatches;
    @NotNull
    private final List<FilePatch> myFailedPatches;
    private final PathsVerifier<BinaryType> myVerifier;
    private boolean mySystemOperation;
    private final boolean myReverseConflict;
    @Nullable
    private final String myLeftConflictPanelTitle;
    @Nullable
    private final String myRightConflictPanelTitle;

    public PatchApplier(@NotNull Project project2, VirtualFile baseDirectory, @NotNull List<FilePatch> patches, @Nullable Consumer<Collection<FilePath>> toTargetListsMover, CustomBinaryPatchApplier<BinaryType> customForBinaries, CommitContext commitContext, boolean reverseConflict, @Nullable String leftConflictPanelTitle, @Nullable String rightConflictPanelTitle) {
        this.myProject = project2;
        this.myBaseDirectory = baseDirectory;
        this.myPatches = patches;
        this.myToTargetListsMover = toTargetListsMover;
        this.myCustomForBinaries = customForBinaries;
        this.myCommitContext = commitContext;
        this.myReverseConflict = reverseConflict;
        this.myLeftConflictPanelTitle = leftConflictPanelTitle;
        this.myRightConflictPanelTitle = rightConflictPanelTitle;
        this.myRemainingPatches = new ArrayList<FilePatch>();
        this.myFailedPatches = new ArrayList<FilePatch>();
        this.myVerifier = new PathsVerifier(this.myProject, this.myBaseDirectory, this.myPatches, new PathsVerifier.BaseMapper(){

            @Override
            @Nullable
            public VirtualFile getFile(FilePatch patch, String path) {
                return PathMerger.getFile(PatchApplier.this.myBaseDirectory, path);
            }

            @Override
            public FilePath getPath(FilePatch patch, String path) {
                return PathMerger.getFile(VcsUtil.getFilePath((VirtualFile)PatchApplier.this.myBaseDirectory), path);
            }
        });
    }

    public PatchApplier(Project project2, VirtualFile baseDirectory, @NotNull List<FilePatch> patches, LocalChangeList targetChangeList, CustomBinaryPatchApplier<BinaryType> customForBinaries, CommitContext commitContext, boolean reverseConflict, @Nullable String leftConflictPanelTitle, @Nullable String rightConflictPanelTitle) {
        this(project2, baseDirectory, patches, PatchApplier.createMover(project2, targetChangeList), customForBinaries, commitContext, reverseConflict, leftConflictPanelTitle, rightConflictPanelTitle);
    }

    public void setIgnoreContentRootsCheck() {
        this.myVerifier.setIgnoreContentRootsCheck(true);
    }

    public PatchApplier(Project project2, VirtualFile baseDirectory, @NotNull List<FilePatch> patches, LocalChangeList targetChangeList, CustomBinaryPatchApplier<BinaryType> customForBinaries, CommitContext commitContext) {
        this(project2, baseDirectory, patches, targetChangeList, customForBinaries, commitContext, false, null, null);
    }

    public void setIsSystemOperation(boolean systemOperation) {
        this.mySystemOperation = systemOperation;
    }

    @Nullable
    private static Consumer<Collection<FilePath>> createMover(Project project2, LocalChangeList targetChangeList) {
        ChangeListManager clm = ChangeListManager.getInstance((Project)project2);
        if (targetChangeList == null || clm.getDefaultListName().equals(targetChangeList.getName())) {
            return null;
        }
        return new FilesMover(clm, targetChangeList);
    }

    @NotNull
    public List<FilePatch> getPatches() {
        return this.myPatches;
    }

    @NotNull
    private Collection<FilePatch> getFailedPatches() {
        return this.myFailedPatches;
    }

    @NotNull
    public List<BinaryType> getBinaryPatches() {
        return ContainerUtil.mapNotNull(this.myVerifier.getBinaryPatches(), (Function)new Function<Pair<VirtualFile, ApplyFilePatchBase<BinaryType>>, BinaryType>(){

            public BinaryType fun(Pair<VirtualFile, ApplyFilePatchBase<BinaryType>> patchInfo) {
                return ((ApplyFilePatchBase)patchInfo.getSecond()).getPatch();
            }
        });
    }

    public void execute() {
        this.execute(true, false);
    }

    public ApplyPatchTask createApplyPart(boolean showSuccessNotification, boolean silentAddDelete) {
        return new ApplyPatchTask(showSuccessNotification, silentAddDelete);
    }

    public void execute(boolean showSuccessNotification, boolean silentAddDelete) {
        this.createApplyPart(showSuccessNotification, silentAddDelete).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApplyPatchStatus executePatchGroup(final Collection<PatchApplier> group, LocalChangeList localChangeList) {
        if (group.isEmpty()) {
            return ApplyPatchStatus.SUCCESS;
        }
        Project project2 = group.iterator().next().myProject;
        ApplyPatchStatus result = ApplyPatchStatus.SUCCESS;
        for (PatchApplier patchApplier : group) {
            result = ApplyPatchStatus.and(result, patchApplier.nonWriteActionPreCheck());
        }
        Label beforeLabel = LocalHistory.getInstance().putSystemLabel(project2, "Before patch");
        final TriggerAdditionOrDeletion trigger = new TriggerAdditionOrDeletion(project2);
        final Ref refStatus = new Ref((Object)result);
        try {
            CommandProcessor.getInstance().executeCommand(project2, new Runnable(){

                @Override
                public void run() {
                    for (PatchApplier applier : group) {
                        refStatus.set((Object)ApplyPatchStatus.and((ApplyPatchStatus)((Object)refStatus.get()), applier.createFiles()));
                        applier.addSkippedItems(trigger);
                    }
                    trigger.prepare();
                    if (refStatus.get() == ApplyPatchStatus.SUCCESS) {
                        refStatus.set(null);
                    }
                    for (PatchApplier applier : group) {
                        refStatus.set((Object)ApplyPatchStatus.and((ApplyPatchStatus)((Object)refStatus.get()), applier.executeWritable()));
                        if (refStatus.get() != ApplyPatchStatus.ABORT) continue;
                        break;
                    }
                }
            }, VcsBundle.message((String)"patch.apply.command", (Object[])new Object[0]), null);
        }
        finally {
            VcsFileListenerContextHelper.getInstance((Project)project2).clearContext();
            LocalHistory.getInstance().putSystemLabel(project2, "After patch");
        }
        result = (ApplyPatchStatus)((Object)refStatus.get());
        result = result == null ? ApplyPatchStatus.FAILURE : result;
        trigger.processIt();
        HashSet<FilePath> directlyAffected = new HashSet<FilePath>();
        HashSet<VirtualFile> indirectlyAffected = new HashSet<VirtualFile>();
        for (PatchApplier applier : group) {
            directlyAffected.addAll(applier.getDirectlyAffected());
            indirectlyAffected.addAll(applier.getIndirectlyAffected());
        }
        directlyAffected.addAll(trigger.getAffected());
        Consumer<Collection<FilePath>> mover = localChangeList == null ? null : PatchApplier.createMover(project2, localChangeList);
        PatchApplier.refreshPassedFilesAndMoveToChangelist(project2, directlyAffected, indirectlyAffected, mover);
        if (result == ApplyPatchStatus.FAILURE || result == ApplyPatchStatus.ABORT) {
            PatchApplier.suggestRollback(project2, group, beforeLabel);
        }
        PatchApplier.showApplyStatus(project2, result);
        return result;
    }

    private static void suggestRollback(@NotNull Project project2, @NotNull Collection<PatchApplier> group, @NotNull Label beforeLabel) {
        List allFailed = ContainerUtil.concat(group, (Function)new Function<PatchApplier, Collection<? extends FilePatch>>(){

            public Collection<FilePatch> fun(PatchApplier applier) {
                return applier.getFailedPatches();
            }
        });
        boolean shouldInformAboutBinaries = ContainerUtil.exists(group, (Condition)new Condition<PatchApplier>(){

            public boolean value(PatchApplier applier) {
                return !applier.getBinaryPatches().isEmpty();
            }
        });
        UndoApplyPatchDialog undoApplyPatchDialog = new UndoApplyPatchDialog(project2, ContainerUtil.map((Collection)allFailed, (Function)new Function<FilePatch, FilePath>(){

            public FilePath fun(FilePatch filePatch) {
                String path = filePatch.getAfterName() == null ? filePatch.getBeforeName() : filePatch.getAfterName();
                return VcsUtil.getFilePath((String)path);
            }
        }), shouldInformAboutBinaries);
        undoApplyPatchDialog.show();
        if (undoApplyPatchDialog.isOK()) {
            PatchApplier.rollbackUnderProgress(project2, project2.getBaseDir(), beforeLabel);
        }
    }

    private static void rollbackUnderProgress(final @NotNull Project project2, final @NotNull VirtualFile virtualFile, final @NotNull Label labelToRevert) {
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                try {
                    labelToRevert.revert(project2, virtualFile);
                }
                catch (LocalHistoryException e) {
                    VcsNotifier.getInstance(project2).notifyImportantWarning("Rollback Failed", String.format("Try using local history dialog for %s and perform revert manually.", virtualFile.getName()));
                }
            }
        }, "Rollback Applied Changes...", true, project2);
    }

    protected void addSkippedItems(TriggerAdditionOrDeletion trigger) {
        trigger.addExisting(this.myVerifier.getToBeAdded());
        trigger.addDeleted(this.myVerifier.getToBeDeleted());
    }

    @NotNull
    public ApplyPatchStatus nonWriteActionPreCheck() {
        List<FilePatch> failedPreCheck = this.myVerifier.nonWriteActionPreCheck();
        this.myFailedPatches.addAll(failedPreCheck);
        this.myPatches.removeAll(failedPreCheck);
        List<FilePatch> skipped = this.myVerifier.getSkipped();
        boolean applyAll = skipped.isEmpty();
        this.myPatches.removeAll(skipped);
        if (!failedPreCheck.isEmpty()) {
            return ApplyPatchStatus.FAILURE;
        }
        return applyAll ? ApplyPatchStatus.SUCCESS : (skipped.size() == this.myPatches.size() ? ApplyPatchStatus.ALREADY_APPLIED : ApplyPatchStatus.PARTIAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected ApplyPatchStatus executeWritable() {
        ReadonlyStatusHandler.OperationStatus readOnlyFilesStatus = this.getReadOnlyFilesStatus(this.myVerifier.getWritableFiles());
        if (readOnlyFilesStatus.hasReadonlyFiles()) {
            PatchApplier.showError(this.myProject, readOnlyFilesStatus.getReadonlyFilesMessage(), true);
            return ApplyPatchStatus.ABORT;
        }
        this.myFailedPatches.addAll(this.myVerifier.filterBadFileTypePatches());
        ApplyPatchStatus result = this.myFailedPatches.isEmpty() ? null : ApplyPatchStatus.FAILURE;
        List<Pair<VirtualFile, ApplyTextFilePatch>> textPatches = this.myVerifier.getTextPatches();
        try {
            PatchApplier.markInternalOperation(textPatches, true);
            ApplyPatchStatus applyPatchStatus = ApplyPatchStatus.and(result, this.actualApply(textPatches, this.myVerifier.getBinaryPatches(), this.myCommitContext));
            return applyPatchStatus;
        }
        finally {
            PatchApplier.markInternalOperation(textPatches, false);
        }
    }

    @NotNull
    private ApplyPatchStatus createFiles() {
        Application application = ApplicationManager.getApplication();
        Boolean isSuccess = (Boolean)application.runWriteAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                List<FilePatch> filePatches = PatchApplier.this.myVerifier.execute();
                PatchApplier.this.myFailedPatches.addAll(filePatches);
                PatchApplier.this.myPatches.removeAll(filePatches);
                return PatchApplier.this.myFailedPatches.isEmpty();
            }
        });
        return isSuccess != false ? ApplyPatchStatus.SUCCESS : ApplyPatchStatus.FAILURE;
    }

    private static void markInternalOperation(List<Pair<VirtualFile, ApplyTextFilePatch>> textPatches, boolean set) {
        for (Pair<VirtualFile, ApplyTextFilePatch> patch : textPatches) {
            ChangesUtil.markInternalOperation((VirtualFile)((VirtualFile)patch.getFirst()), (boolean)set);
        }
    }

    protected void refreshFiles(Collection<FilePath> additionalDirectly) {
        List<FilePath> directlyAffected = this.myVerifier.getDirectlyAffected();
        List<VirtualFile> indirectlyAffected = this.myVerifier.getAllAffected();
        directlyAffected.addAll(additionalDirectly);
        PatchApplier.refreshPassedFilesAndMoveToChangelist(this.myProject, directlyAffected, indirectlyAffected, this.myToTargetListsMover);
    }

    public List<FilePath> getDirectlyAffected() {
        return this.myVerifier.getDirectlyAffected();
    }

    public List<VirtualFile> getIndirectlyAffected() {
        return this.myVerifier.getAllAffected();
    }

    public static void refreshPassedFilesAndMoveToChangelist(@NotNull Project project2, final Collection<FilePath> directlyAffected, final Collection<VirtualFile> indirectlyAffected, final Consumer<Collection<FilePath>> targetChangelistMover) {
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        for (FilePath filePath : directlyAffected) {
            lfs.refreshAndFindFileByIoFile(filePath.getIOFile());
        }
        lfs.refreshFiles(indirectlyAffected, false, true, null);
        if (project2.isDisposed()) {
            return;
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project2);
        if (!directlyAffected.isEmpty() && targetChangelistMover != null) {
            changeListManager.invokeAfterUpdate(new Runnable(){

                @Override
                public void run() {
                    targetChangelistMover.consume((Object)directlyAffected);
                }
            }, InvokeAfterUpdateMode.SYNCHRONOUS_CANCELLABLE, VcsBundle.message((String)"change.lists.manager.move.changes.to.list", (Object[])new Object[0]), (Consumer)new Consumer<VcsDirtyScopeManager>(){

                public void consume(VcsDirtyScopeManager vcsDirtyScopeManager) {
                    PatchApplier.markDirty(vcsDirtyScopeManager, directlyAffected, indirectlyAffected);
                }
            }, null);
        } else {
            PatchApplier.markDirty(VcsDirtyScopeManager.getInstance((Project)project2), directlyAffected, indirectlyAffected);
        }
    }

    private static void markDirty(@NotNull VcsDirtyScopeManager vcsDirtyScopeManager, @NotNull Collection<FilePath> directlyAffected, @NotNull Collection<VirtualFile> indirectlyAffected) {
        vcsDirtyScopeManager.filePathsDirty(directlyAffected, null);
        vcsDirtyScopeManager.filesDirty(indirectlyAffected, null);
    }

    @Nullable
    private ApplyPatchStatus actualApply(List<Pair<VirtualFile, ApplyTextFilePatch>> textPatches, List<Pair<VirtualFile, ApplyFilePatchBase<BinaryType>>> binaryPatches, CommitContext commitContext) {
        ApplyPatchStatus status;
        ApplyPatchContext context = new ApplyPatchContext(this.myBaseDirectory, 0, true, true);
        try {
            status = this.applyList(textPatches, context, null, commitContext);
            if (status == ApplyPatchStatus.ABORT) {
                return status;
            }
            if (this.myCustomForBinaries == null) {
                status = this.applyList(binaryPatches, context, status, commitContext);
            } else {
                ApplyPatchStatus patchStatus = this.myCustomForBinaries.apply(binaryPatches);
                List<FilePatch> appliedPatches = this.myCustomForBinaries.getAppliedPatches();
                this.moveForCustomBinaries(binaryPatches, appliedPatches);
                status = ApplyPatchStatus.and(status, patchStatus);
                this.myRemainingPatches.removeAll(appliedPatches);
            }
        }
        catch (IOException e) {
            PatchApplier.showError(this.myProject, e.getMessage(), true);
            return ApplyPatchStatus.ABORT;
        }
        return status;
    }

    private void moveForCustomBinaries(List<Pair<VirtualFile, ApplyFilePatchBase<BinaryType>>> patches, List<FilePatch> appliedPatches) throws IOException {
        for (Pair<VirtualFile, ApplyFilePatchBase<BinaryType>> patch : patches) {
            if (!appliedPatches.contains(((ApplyFilePatchBase)patch.getSecond()).getPatch())) continue;
            this.myVerifier.doMoveIfNeeded((VirtualFile)patch.getFirst());
        }
    }

    private <V extends FilePatch, T extends ApplyFilePatchBase<V>> ApplyPatchStatus applyList(List<Pair<VirtualFile, T>> patches, ApplyPatchContext context, ApplyPatchStatus status, CommitContext commiContext) throws IOException {
        for (Pair<VirtualFile, T> patch : patches) {
            ApplyPatchStatus patchStatus = ApplyPatchAction.applyOnly(this.myProject, (ApplyFilePatchBase)patch.getSecond(), context, (VirtualFile)patch.getFirst(), commiContext, this.myReverseConflict, this.myLeftConflictPanelTitle, this.myRightConflictPanelTitle);
            if (patchStatus == ApplyPatchStatus.ABORT) {
                return patchStatus;
            }
            status = ApplyPatchStatus.and(status, patchStatus);
            if (patchStatus == ApplyPatchStatus.FAILURE) {
                this.myFailedPatches.add((FilePatch)((ApplyFilePatchBase)patch.getSecond()).getPatch());
                continue;
            }
            if (patchStatus == ApplyPatchStatus.SKIP) continue;
            this.myVerifier.doMoveIfNeeded((VirtualFile)patch.getFirst());
            this.myRemainingPatches.remove(((ApplyFilePatchBase)patch.getSecond()).getPatch());
        }
        return status;
    }

    protected static void showApplyStatus(@NotNull Project project2, ApplyPatchStatus status) {
        if (status == ApplyPatchStatus.ALREADY_APPLIED) {
            PatchApplier.showError(project2, VcsBundle.message((String)"patch.apply.already.applied", (Object[])new Object[0]), false);
        } else if (status == ApplyPatchStatus.PARTIAL) {
            PatchApplier.showError(project2, VcsBundle.message((String)"patch.apply.partially.applied", (Object[])new Object[0]), false);
        } else if (ApplyPatchStatus.SUCCESS.equals((Object)status)) {
            String message = VcsBundle.message((String)"patch.apply.success.applied.text", (Object[])new Object[0]);
            VcsBalloonProblemNotifier.NOTIFICATION_GROUP.createNotification(message, MessageType.INFO).notify(project2);
        }
    }

    @NotNull
    public List<FilePatch> getRemainingPatches() {
        return this.myRemainingPatches;
    }

    private ReadonlyStatusHandler.OperationStatus getReadOnlyFilesStatus(@NotNull List<VirtualFile> filesToMakeWritable) {
        VirtualFile[] fileArray = VfsUtilCore.toVirtualFileArray(filesToMakeWritable);
        return ReadonlyStatusHandler.getInstance((Project)this.myProject).ensureFilesWritable(fileArray);
    }

    public static void showError(final Project project2, final String message, final boolean error) {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            return;
        }
        final String title = VcsBundle.message((String)"patch.apply.dialog.title", (Object[])new Object[0]);
        final Runnable messageShower = new Runnable(){

            @Override
            public void run() {
                if (error) {
                    Messages.showErrorDialog((Project)project2, (String)message, (String)title);
                } else {
                    Messages.showInfoMessage((Project)project2, (String)message, (String)title);
                }
            }
        };
        WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)new Runnable(){

            @Override
            public void run() {
                messageShower.run();
            }
        }, null, (Project)project2);
    }

    private static class FilesMover
    implements Consumer<Collection<FilePath>> {
        private final ChangeListManager myChangeListManager;
        private final LocalChangeList myTargetChangeList;

        public FilesMover(ChangeListManager changeListManager, LocalChangeList targetChangeList) {
            this.myChangeListManager = changeListManager;
            this.myTargetChangeList = targetChangeList;
        }

        public void consume(Collection<FilePath> directlyAffected) {
            ArrayList<Change> changes = new ArrayList<Change>();
            for (FilePath file2 : directlyAffected) {
                Change change = this.myChangeListManager.getChange(file2);
                if (change == null) continue;
                changes.add(change);
            }
            this.myChangeListManager.moveChangesTo(this.myTargetChangeList, changes.toArray(new Change[changes.size()]));
        }
    }

    public class ApplyPatchTask {
        private ApplyPatchStatus myStatus;
        private final boolean myShowNotification;
        private final boolean mySystemOperation;
        private VcsShowConfirmationOption.Value myAddconfirmationvalue;
        private VcsShowConfirmationOption.Value myDeleteconfirmationvalue;

        public ApplyPatchTask(boolean showNotification2, boolean systemOperation) {
            this.myShowNotification = showNotification2;
            this.mySystemOperation = systemOperation;
        }

        public void run() {
            PatchApplier.this.myRemainingPatches.addAll(PatchApplier.this.myPatches);
            ApplyPatchStatus patchStatus = PatchApplier.this.nonWriteActionPreCheck();
            Label beforeLabel = LocalHistory.getInstance().putSystemLabel(PatchApplier.this.myProject, "Before patch");
            TriggerAdditionOrDeletion trigger = new TriggerAdditionOrDeletion(PatchApplier.this.myProject);
            ApplyPatchStatus applyStatus = this.getApplyPatchStatus(trigger);
            this.myStatus = ApplyPatchStatus.SUCCESS.equals((Object)patchStatus) ? applyStatus : ApplyPatchStatus.and(patchStatus, applyStatus);
            trigger.processIt();
            LocalHistory.getInstance().putSystemLabel(PatchApplier.this.myProject, "After patch");
            if (this.myStatus == ApplyPatchStatus.FAILURE || this.myStatus == ApplyPatchStatus.ABORT) {
                PatchApplier.suggestRollback(PatchApplier.this.myProject, Collections.singletonList(PatchApplier.this), beforeLabel);
            }
            if (this.myShowNotification || !ApplyPatchStatus.SUCCESS.equals((Object)this.myStatus)) {
                PatchApplier.showApplyStatus(PatchApplier.this.myProject, this.myStatus);
            }
            PatchApplier.this.refreshFiles(trigger.getAffected());
        }

        @NotNull
        private ApplyPatchStatus getApplyPatchStatus(final @NotNull TriggerAdditionOrDeletion trigger) {
            final Ref refStatus = Ref.create(null);
            try {
                this.setConfirmationToDefault();
                CommandProcessor.getInstance().executeCommand(PatchApplier.this.myProject, new Runnable(){

                    @Override
                    public void run() {
                        if (PatchApplier.this.createFiles() != ApplyPatchStatus.SUCCESS) {
                            refStatus.set((Object)PatchApplier.this.createFiles());
                        }
                        PatchApplier.this.addSkippedItems(trigger);
                        trigger.prepare();
                        refStatus.set((Object)ApplyPatchStatus.and((ApplyPatchStatus)((Object)refStatus.get()), PatchApplier.this.executeWritable()));
                    }
                }, VcsBundle.message((String)"patch.apply.command", (Object[])new Object[0]), null);
            }
            finally {
                this.returnConfirmationBack();
                VcsFileListenerContextHelper.getInstance((Project)PatchApplier.this.myProject).clearContext();
            }
            ApplyPatchStatus status = (ApplyPatchStatus)((Object)refStatus.get());
            return status == null ? ApplyPatchStatus.ALREADY_APPLIED : status;
        }

        private void returnConfirmationBack() {
            if (this.mySystemOperation) {
                ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)PatchApplier.this.myProject);
                VcsShowConfirmationOption addConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, null);
                addConfirmation.setValue(this.myAddconfirmationvalue);
                VcsShowConfirmationOption deleteConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.REMOVE, null);
                deleteConfirmation.setValue(this.myDeleteconfirmationvalue);
            }
        }

        private void setConfirmationToDefault() {
            if (this.mySystemOperation) {
                ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)PatchApplier.this.myProject);
                VcsShowConfirmationOption addConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, null);
                this.myAddconfirmationvalue = addConfirmation.getValue();
                addConfirmation.setValue(VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY);
                VcsShowConfirmationOption deleteConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.REMOVE, null);
                this.myDeleteconfirmationvalue = deleteConfirmation.getValue();
                deleteConfirmation.setValue(VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY);
            }
        }

        public ApplyPatchStatus getStatus() {
            return this.myStatus;
        }
    }
}

