/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.incrementalMerge.Change;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeHighlighterHolder;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeList;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeSide;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeType;
import com.intellij.openapi.diff.impl.incrementalMerge.DiffRangeMarker;
import com.intellij.openapi.diff.impl.incrementalMerge.MergeList;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TwoSideChange<T extends SideChange>
extends ChangeSide
implements DiffRangeMarker.RangeInvalidListener {
    @NotNull
    protected final MergeList myMergeList;
    @NotNull
    protected DiffRangeMarker myBaseRangeMarker;
    protected T myLeftChange;
    protected T myRightChange;
    @NotNull
    protected final ChangeHighlighterHolder myCommonHighlighterHolder;

    protected TwoSideChange(@NotNull TextRange baseRange, @NotNull MergeList mergeList, @NotNull ChangeHighlighterHolder highlighterHolder) {
        this.myBaseRangeMarker = new DiffRangeMarker((DocumentEx)mergeList.getBaseDocument(), baseRange, this);
        this.myMergeList = mergeList;
        this.myCommonHighlighterHolder = highlighterHolder;
    }

    @Override
    @NotNull
    public ChangeHighlighterHolder getHighlighterHolder() {
        return this.myCommonHighlighterHolder;
    }

    @Override
    @NotNull
    public DiffRangeMarker getRange() {
        return this.myBaseRangeMarker;
    }

    @Nullable
    public Change getLeftChange() {
        return this.myLeftChange;
    }

    @Nullable
    public Change getRightChange() {
        return this.myRightChange;
    }

    public void setRange(@NotNull DiffRangeMarker range) {
        this.myBaseRangeMarker = range;
    }

    @Nullable
    T getOtherChange(@NotNull T change) {
        if (change == this.myLeftChange) {
            return this.myRightChange;
        }
        if (change == this.myRightChange) {
            return this.myLeftChange;
        }
        throw new IllegalStateException("Unexpected change: " + change);
    }

    public void removeOtherChange(@NotNull T change) {
        if (change == this.myLeftChange) {
            this.myRightChange = null;
        } else if (change == this.myRightChange) {
            this.myLeftChange = null;
        } else {
            throw new IllegalStateException("Unexpected change: " + change);
        }
    }

    public void conflictRemoved() {
        TwoSideChange.removeHighlighters(this.myLeftChange);
        TwoSideChange.removeHighlighters(this.myRightChange);
        this.myCommonHighlighterHolder.removeHighlighters();
        this.myMergeList.removeChanges((Change)this.myLeftChange, (Change)this.myRightChange);
        this.myBaseRangeMarker.removeListener(this);
    }

    private static <T extends SideChange> void removeHighlighters(@Nullable T change) {
        if (change != null) {
            change.getOriginalSide().getHighlighterHolder().removeHighlighters();
        }
    }

    @NotNull
    public Document getOriginalDocument(FragmentSide mergeSide) {
        return this.myMergeList.getChanges(mergeSide).getDocument(MergeList.BRANCH_SIDE);
    }

    @Override
    public void onRangeInvalidated() {
        this.conflictRemoved();
    }

    @NotNull
    public MergeList getMergeList() {
        return this.myMergeList;
    }

    protected static abstract class SideChange<V extends TwoSideChange>
    extends Change
    implements DiffRangeMarker.RangeInvalidListener {
        protected V myTwoSideChange;
        @NotNull
        protected final ChangeList myChangeList;
        protected Change.SimpleChangeSide myOriginalSide;
        @NotNull
        protected ChangeType myType;

        protected SideChange(@NotNull V twoSideChange, @NotNull ChangeList changeList, @NotNull ChangeType type, @NotNull FragmentSide mergeSide, @NotNull TextRange versionRange) {
            this.myTwoSideChange = twoSideChange;
            this.myChangeList = changeList;
            this.myOriginalSide = new Change.SimpleChangeSide(mergeSide, new DiffRangeMarker((DocumentEx)((TwoSideChange)twoSideChange).getOriginalDocument(mergeSide), versionRange, this));
            this.myType = type;
        }

        @Override
        @NotNull
        public ChangeType getType() {
            return this.myType;
        }

        public Change.SimpleChangeSide getOriginalSide() {
            return this.myOriginalSide;
        }

        protected void markApplied() {
            this.myType = ChangeType.deriveApplied(this.myType);
            this.myChangeList.apply(this);
            this.myOriginalSide.getHighlighterHolder().updateHighlighter(this.myOriginalSide, this.myType);
            this.myOriginalSide.getHighlighterHolder().setActions(new AnAction[0]);
            ((TwoSideChange)this.myTwoSideChange).getHighlighterHolder().updateHighlighter((ChangeSide)this.myTwoSideChange, this.myType);
        }

        @Override
        public ChangeList getChangeList() {
            return ((TwoSideChange)this.myTwoSideChange).getMergeList().getChanges(this.myOriginalSide.getFragmentSide());
        }

        @Override
        protected void changeSide(ChangeSide sideToChange, DiffRangeMarker newRange) {
            ((TwoSideChange)this.myTwoSideChange).setRange(newRange);
        }

        @Override
        @NotNull
        public ChangeSide getChangeSide(@NotNull FragmentSide side) {
            return SideChange.isBranch(side) ? this.myOriginalSide : this.myTwoSideChange;
        }

        protected static boolean isBranch(@NotNull FragmentSide side) {
            return MergeList.BRANCH_SIDE == side;
        }

        @Override
        protected void removeFromList() {
            ((TwoSideChange)this.myTwoSideChange).conflictRemoved();
            this.myTwoSideChange = null;
        }

        @Override
        public boolean isValid() {
            return this.myTwoSideChange != null;
        }

        @Override
        public void onRemovedFromList() {
            this.myOriginalSide.getRange().removeListener(this);
            this.myTwoSideChange = null;
            this.myOriginalSide = null;
        }

        @Override
        public void onRangeInvalidated() {
            this.removeFromList();
        }
    }
}

