/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeHighlighterHolder;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeSide;
import com.intellij.openapi.diff.impl.util.TextDiffType;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineSeparatorRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeType {
    private static final int LAYER = 5999;
    private static final ChangeType INSERT = new ChangeType(TextDiffType.INSERT, false);
    private static final ChangeType DELETED = new ChangeType(TextDiffType.DELETED, false);
    private static final ChangeType CHANGE = new ChangeType(TextDiffType.CHANGED, false);
    static final ChangeType CONFLICT = new ChangeType(TextDiffType.CONFLICT, false);
    private final TextDiffType myDiffType;
    private final boolean myApplied;

    private ChangeType(TextDiffType diffType, boolean applied) {
        this.myApplied = applied;
        this.myDiffType = applied ? TextDiffType.deriveApplied(diffType) : diffType;
    }

    public boolean isApplied() {
        return this.myApplied;
    }

    @NotNull
    public static ChangeType deriveApplied(ChangeType type) {
        return new ChangeType(type.myDiffType, true);
    }

    @Nullable
    public RangeHighlighter addMarker(ChangeSide changeSide, ChangeHighlighterHolder markup) {
        CharSequence text = changeSide.getText();
        if (text != null && text.length() > 0) {
            return this.addBlock(text, changeSide, markup, this.myDiffType);
        }
        return this.addLine(markup, changeSide.getStartLine(), this.myDiffType, SeparatorPlacement.TOP);
    }

    @NotNull
    public TextDiffType getTypeKey() {
        return this.myDiffType;
    }

    @NotNull
    public TextDiffType getTextDiffType() {
        return this.getTypeKey();
    }

    @Nullable
    private RangeHighlighter addBlock(CharSequence text, ChangeSide changeSide, final ChangeHighlighterHolder markup, TextDiffType diffType) {
        EditorColorsScheme colorScheme = markup.getEditor().getColorsScheme();
        Color separatorColor = this.getSeparatorColor(diffType.getLegendColor(colorScheme));
        int length = text.length();
        int start = changeSide.getStart();
        int end = start + length;
        RangeHighlighter highlighter = markup.addRangeHighlighter(start, end, 5999, diffType, HighlighterTargetArea.EXACT_RANGE, this.myApplied);
        LineSeparatorRenderer lineSeparatorRenderer = new LineSeparatorRenderer(){

            public void drawLine(Graphics g, int x1, int x2, int y) {
                Graphics2D g2 = (Graphics2D)g;
                Color color = ChangeType.this.myDiffType.getPolygonColor(markup.getEditor());
                if (color != null) {
                    if (ChangeType.this.myApplied) {
                        Rectangle bounds = g.getClipBounds();
                        if ((x1 = Math.max(x1, bounds.x)) >= x2) {
                            return;
                        }
                        UIUtil.drawBoldDottedLine((Graphics2D)g2, (int)x1, (int)x2, (int)y, null, (Color)color, (boolean)false);
                    } else {
                        UIUtil.drawLine((Graphics2D)g2, (int)x1, (int)y, (int)x2, (int)y, null, (Color)DiffUtil.getFramingColor(color));
                    }
                }
            }
        };
        if (highlighter != null) {
            highlighter.setLineSeparatorPlacement(SeparatorPlacement.TOP);
            highlighter.setLineSeparatorColor(separatorColor);
            highlighter.setLineSeparatorRenderer(lineSeparatorRenderer);
        }
        if (text.charAt(length - 1) == '\n') {
            --end;
        }
        if ((highlighter = markup.addRangeHighlighter(start, end, 5999, TextDiffType.NONE, HighlighterTargetArea.EXACT_RANGE, this.myApplied)) != null) {
            highlighter.setLineSeparatorPlacement(SeparatorPlacement.BOTTOM);
            highlighter.setLineSeparatorColor(separatorColor);
            highlighter.setLineSeparatorRenderer(lineSeparatorRenderer);
        }
        return highlighter;
    }

    @Nullable
    private RangeHighlighter addLine(final ChangeHighlighterHolder markup, int line, final TextDiffType type, SeparatorPlacement placement) {
        RangeHighlighter highlighter = markup.addLineHighlighter(line, 5999, type, this.myApplied);
        if (highlighter == null) {
            return null;
        }
        highlighter.setLineSeparatorPlacement(placement);
        highlighter.setLineSeparatorRenderer(new LineSeparatorRenderer(){

            public void drawLine(Graphics g, int x1, int x2, int y) {
                Graphics2D g2 = (Graphics2D)g;
                Color color = ChangeType.this.myDiffType.getPolygonColor(markup.getEditor());
                if (color != null) {
                    if (type.isApplied()) {
                        Rectangle bounds = g.getClipBounds();
                        if ((x1 = Math.max(x1, bounds.x)) >= x2) {
                            return;
                        }
                        UIUtil.drawBoldDottedLine((Graphics2D)g2, (int)x1, (int)x2, (int)y, null, (Color)color, (boolean)false);
                    } else {
                        DiffUtil.drawDoubleShadowedLine(g2, x1, x2, y, color);
                    }
                }
            }
        });
        return highlighter;
    }

    @NotNull
    static ChangeType fromDiffFragment(DiffFragment fragment) {
        if (fragment.getText1() == null) {
            return INSERT;
        }
        if (fragment.getText2() == null) {
            return DELETED;
        }
        return CHANGE;
    }

    @NotNull
    static ChangeType fromRanges(@NotNull TextRange left, @NotNull TextRange right) {
        if (left.getLength() == 0) {
            return INSERT;
        }
        if (right.getLength() == 0) {
            return DELETED;
        }
        return CHANGE;
    }

    public String toString() {
        return this.myDiffType.getDisplayName();
    }

    @NotNull
    public Color getSeparatorColor(@Nullable Color highlightColor) {
        if (this.myApplied) {
            return highlightColor == null ? Color.DARK_GRAY : highlightColor.darker();
        }
        return Color.GRAY;
    }
}

