/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.ComparisonPolicy;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.incrementalMerge.Change;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeType;
import com.intellij.openapi.diff.impl.incrementalMerge.SimpleChange;
import com.intellij.openapi.diff.impl.splitter.LineBlocks;
import com.intellij.openapi.diff.impl.string.DiffString;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeList {
    private static final Logger LOG = Logger.getInstance(ChangeList.class);
    public static final Comparator<Change> CHANGE_ORDER = new Change.ChangeOrder(FragmentSide.SIDE1);
    private final Project myProject;
    private final Document[] myDocuments = new Document[2];
    private final List<Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private ArrayList<Change> myChanges;
    private ArrayList<Change> myAppliedChanges;

    public ChangeList(@NotNull Document base, @NotNull Document version, @Nullable Project project2) {
        this.myDocuments[0] = base;
        this.myDocuments[1] = version;
        this.myProject = project2;
    }

    public void addListener(Listener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeListener(Listener listener2) {
        LOG.assertTrue(this.myListeners.remove(listener2));
    }

    public void setChanges(@NotNull ArrayList<Change> changes) {
        if (this.myChanges != null) {
            HashSet newChanges = new HashSet(changes);
            LOG.assertTrue(newChanges.size() == changes.size());
            Iterator<Change> iterator = this.myChanges.iterator();
            while (iterator.hasNext()) {
                Change oldChange = iterator.next();
                if (newChanges.contains((Object)oldChange)) continue;
                iterator.remove();
                oldChange.onRemovedFromList();
            }
        }
        for (Change change : changes) {
            LOG.assertTrue(change.isValid());
        }
        this.myChanges = new ArrayList<Change>(changes);
        this.myAppliedChanges = new ArrayList();
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public List<Change> getChanges() {
        return new ArrayList<Change>(this.myChanges);
    }

    public static ChangeList build(@NotNull Document base, @NotNull Document version, @NotNull Project project2) throws FilesTooBigForDiffException {
        ChangeList result = new ChangeList(base, version, project2);
        ArrayList<Change> changes = result.buildChanges();
        Collections.sort(changes, CHANGE_ORDER);
        result.setChanges(changes);
        return result;
    }

    public void setMarkup(Editor base, Editor version) {
        Editor[] editors = new Editor[]{base, version};
        for (Change change : this.myChanges) {
            change.addMarkup(editors);
        }
    }

    public void updateMarkup() {
        for (Change change : this.myChanges) {
            change.updateMarkup();
        }
    }

    @NotNull
    public Document getDocument(@NotNull FragmentSide side) {
        return this.myDocuments[side.getIndex()];
    }

    private ArrayList<Change> buildChanges() throws FilesTooBigForDiffException {
        Document base = this.getDocument(FragmentSide.SIDE1);
        DiffString[] baseLines = DiffUtil.convertToLines(base.getText());
        Document version = this.getDocument(FragmentSide.SIDE2);
        DiffString[] versionLines = DiffUtil.convertToLines(version.getText());
        DiffFragment[] fragments = ComparisonPolicy.DEFAULT.buildDiffFragmentsFromLines(baseLines, versionLines);
        final ArrayList<Change> result = new ArrayList<Change>();
        new DiffFragmentsEnumerator(fragments){

            @Override
            protected void process(DiffFragment fragment) {
                if (fragment.isEqual()) {
                    return;
                }
                Context context = this.getContext();
                TextRange range1 = context.createRange(FragmentSide.SIDE1);
                TextRange range2 = context.createRange(FragmentSide.SIDE2);
                result.add(new SimpleChange(ChangeType.fromDiffFragment(context.getFragment()), range1, range2, ChangeList.this));
            }
        }.execute();
        return result;
    }

    public Change getChange(int index) {
        return this.myChanges.get(index);
    }

    public int getCount() {
        return this.myChanges.size();
    }

    public LineBlocks getNonAppliedLineBlocks() {
        ArrayList<Change> changes = new ArrayList<Change>(this.myChanges);
        return LineBlocks.fromChanges(changes);
    }

    public LineBlocks getLineBlocks() {
        ArrayList<Change> changes = new ArrayList<Change>(this.myChanges);
        changes.addAll(this.myAppliedChanges);
        return LineBlocks.fromChanges(changes);
    }

    public void remove(@NotNull Change change) {
        if (change.getType().isApplied()) {
            LOG.assertTrue(this.myAppliedChanges.remove(change), (Object)change);
        } else {
            LOG.assertTrue(this.myChanges.remove(change), (Object)change);
        }
        change.onRemovedFromList();
        this.fireOnChangeRemoved();
    }

    public void apply(@NotNull Change change) {
        LOG.assertTrue(this.myChanges.remove(change), (Object)change);
        this.myAppliedChanges.add(change);
        this.fireOnChangeApplied();
    }

    private void fireOnChangeRemoved() {
        for (Listener listener2 : this.myListeners) {
            listener2.onChangeRemoved(this);
        }
    }

    void fireOnChangeApplied() {
        for (Listener listener2 : this.myListeners) {
            listener2.onChangeApplied(this);
        }
    }

    public static interface Listener {
        public void onChangeRemoved(ChangeList var1);

        public void onChangeApplied(ChangeList var1);
    }

    public static class Context {
        private DiffFragment myFragment;
        private final int[] myStarts = new int[]{0, 0};
        private final int[] myLines = new int[]{0, 0};

        public DiffFragment getFragment() {
            return this.myFragment;
        }

        public int getStart(@NotNull FragmentSide side) {
            return this.myStarts[side.getIndex()];
        }

        public int getEnd(@NotNull FragmentSide side) {
            return this.getStart(side) + StringUtil.length((CharSequence)side.getText(this.myFragment));
        }

        @NotNull
        public TextRange createRange(@NotNull FragmentSide side) {
            return new TextRange(this.getStart(side), this.getEnd(side));
        }
    }

    private static abstract class DiffFragmentsEnumerator {
        @NotNull
        private final DiffFragment[] myFragments;
        @NotNull
        private final Context myContext = new Context();

        private DiffFragmentsEnumerator(@NotNull DiffFragment[] fragments) {
            this.myFragments = fragments;
        }

        public void execute() {
            for (DiffFragment fragment : this.myFragments) {
                this.myContext.myFragment = fragment;
                this.process(fragment);
                DiffString text1 = fragment.getText1();
                DiffString text2 = fragment.getText2();
                int[] nArray = this.myContext.myStarts;
                nArray[0] = nArray[0] + StringUtil.length((CharSequence)text1);
                int[] nArray2 = this.myContext.myStarts;
                nArray2[1] = nArray2[1] + StringUtil.length((CharSequence)text2);
                int[] nArray3 = this.myContext.myLines;
                nArray3[0] = nArray3[0] + DiffFragmentsEnumerator.countLines(text1);
                int[] nArray4 = this.myContext.myLines;
                nArray4[1] = nArray4[1] + DiffFragmentsEnumerator.countLines(text2);
            }
        }

        private static int countLines(@Nullable DiffString text) {
            if (text == null) {
                return 0;
            }
            return StringUtil.countNewLines((CharSequence)text);
        }

        @NotNull
        protected Context getContext() {
            return this.myContext;
        }

        protected abstract void process(DiffFragment var1);
    }
}

