/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeHighlighterHolder;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeList;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeSide;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeType;
import com.intellij.openapi.diff.impl.incrementalMerge.DiffRangeMarker;
import com.intellij.openapi.diff.impl.util.DocumentUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Change {
    private static final Logger LOG = Logger.getInstance(Change.class);

    public abstract ChangeSide getChangeSide(FragmentSide var1);

    public abstract ChangeType getType();

    public abstract ChangeList getChangeList();

    protected abstract void removeFromList();

    public abstract void onApplied();

    public abstract void onRemovedFromList();

    public abstract boolean isValid();

    private void apply(@NotNull FragmentSide original) {
        FragmentSide targetSide = original.otherSide();
        RangeMarker originalRangeMarker = this.getRangeMarker(original);
        RangeMarker rangeMarker = this.getRangeMarker(targetSide);
        TextRange textRange = Change.modifyDocument(this.getProject(), originalRangeMarker, rangeMarker);
        if (textRange != null && this.isValid()) {
            this.updateTargetRangeMarker(targetSide, textRange);
        }
        this.onApplied();
    }

    protected final void updateTargetRangeMarker(@NotNull FragmentSide targetFragmentSide, @NotNull TextRange updatedTextRange) {
        ChangeSide targetSide = this.getChangeSide(targetFragmentSide);
        DiffRangeMarker originalRange = targetSide.getRange();
        DiffRangeMarker updatedRange = new DiffRangeMarker(originalRange.getDocument(), updatedTextRange, null);
        this.changeSide(targetSide, updatedRange);
    }

    protected abstract void changeSide(ChangeSide var1, DiffRangeMarker var2);

    @Nullable
    private static TextRange modifyDocument(@Nullable Project project2, @NotNull RangeMarker original, @NotNull RangeMarker target) {
        Document document = target.getDocument();
        if (project2 != null && !ReadonlyStatusHandler.ensureDocumentWritable((Project)project2, (Document)document)) {
            return null;
        }
        if (DocumentUtil.isEmpty(original)) {
            int offset = target.getStartOffset();
            document.deleteString(offset, target.getEndOffset());
        }
        CharSequence text = original.getDocument().getImmutableCharSequence().subSequence(original.getStartOffset(), original.getEndOffset());
        int startOffset = target.getStartOffset();
        if (DocumentUtil.isEmpty(target)) {
            document.insertString(startOffset, text);
        } else {
            document.replaceString(startOffset, target.getEndOffset(), text);
        }
        return new TextRange(startOffset, startOffset + text.length());
    }

    public void addMarkup(Editor[] editors) {
        LOG.assertTrue(editors.length == 2);
        this.highlight(editors, FragmentSide.SIDE1);
        this.highlight(editors, FragmentSide.SIDE2);
    }

    private void highlight(Editor[] editors, FragmentSide side) {
        this.getHighlighterHolder(side).highlight(this.getChangeSide(side), editors[side.getIndex()], this.getType());
    }

    private void updateHighlighter(FragmentSide side) {
        this.getHighlighterHolder(side).updateHighlighter(this.getChangeSide(side), this.getType());
    }

    @Nullable
    private Project getProject() {
        return this.getChangeList().getProject();
    }

    @NotNull
    private ChangeHighlighterHolder getHighlighterHolder(FragmentSide side) {
        return this.getChangeSide(side).getHighlighterHolder();
    }

    @NotNull
    private RangeMarker getRangeMarker(FragmentSide side) {
        ChangeSide changeSide = this.getChangeSide(side);
        LOG.assertTrue(changeSide != null);
        return changeSide.getRange();
    }

    public static void apply(final Change change, final FragmentSide fromSide) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                CommandProcessor.getInstance().executeCommand(change.getProject(), new Runnable(){

                    @Override
                    public void run() {
                        Change.doApply(change, fromSide);
                    }
                }, null, (Object)DiffBundle.message((String)"save.merge.result.command.name", (Object[])new Object[0]));
            }
        });
    }

    public static void doApply(Change change, FragmentSide fromSide) {
        change.apply(fromSide);
    }

    public void updateMarkup() {
        this.updateHighlighter(FragmentSide.SIDE1);
        this.updateHighlighter(FragmentSide.SIDE2);
    }

    public boolean canHasActions(FragmentSide fromSide) {
        FragmentSide targetSide = fromSide.otherSide();
        Document targetDocument = this.getChangeList().getDocument(targetSide);
        if (!targetDocument.isWritable()) {
            return false;
        }
        Editor targetEditor = this.getHighlighterHolder(targetSide).getEditor();
        return !targetEditor.isViewer();
    }

    protected static class SimpleChangeSide
    extends ChangeSide {
        private final FragmentSide mySide;
        private final DiffRangeMarker myRange;
        private final ChangeHighlighterHolder myHighlighterHolder;

        public SimpleChangeSide(FragmentSide side, DiffRangeMarker rangeMarker) {
            this.mySide = side;
            this.myRange = rangeMarker;
            this.myHighlighterHolder = new ChangeHighlighterHolder();
        }

        public SimpleChangeSide(@NotNull ChangeSide originalSide, @NotNull DiffRangeMarker newRange) {
            this.mySide = ((SimpleChangeSide)originalSide).getFragmentSide();
            this.myRange = newRange;
            this.myHighlighterHolder = originalSide.getHighlighterHolder();
        }

        @NotNull
        public FragmentSide getFragmentSide() {
            return this.mySide;
        }

        @Override
        @NotNull
        public DiffRangeMarker getRange() {
            return this.myRange;
        }

        @Override
        @NotNull
        public ChangeHighlighterHolder getHighlighterHolder() {
            return this.myHighlighterHolder;
        }
    }

    public static class ChangeOrder
    implements Comparator<Change> {
        private final FragmentSide myMainSide;

        public ChangeOrder(FragmentSide mainSide) {
            this.myMainSide = mainSide;
        }

        @Override
        public int compare(@NotNull Change change, @NotNull Change change1) {
            int result1 = ChangeOrder.compareSide(change, change1, this.myMainSide);
            if (result1 != 0) {
                return result1;
            }
            return ChangeOrder.compareSide(change, change1, this.myMainSide.otherSide());
        }

        private static int compareSide(Change change, Change change1, FragmentSide side) {
            return RangeMarker.BY_START_OFFSET.compare(change.getRangeMarker(side), change1.getRangeMarker(side));
        }
    }
}

