/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.fragments;

import com.intellij.openapi.diff.actions.MergeOperations;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.fragments.Fragment;
import com.intellij.openapi.diff.impl.fragments.FragmentHighlighter;
import com.intellij.openapi.diff.impl.fragments.InlineFragment;
import com.intellij.openapi.diff.impl.fragments.LineFragment;
import com.intellij.openapi.diff.impl.highlighting.DiffMarkup;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.util.TextDiffTypeEnum;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.util.TextRange;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class FragmentHighlighterImpl
implements FragmentHighlighter {
    protected final DiffMarkup myAppender1;
    protected final DiffMarkup myAppender2;
    private boolean myIsLast;

    public FragmentHighlighterImpl(DiffMarkup appender1, DiffMarkup appender2) {
        this.myAppender1 = appender1;
        this.myAppender2 = appender2;
        this.myIsLast = false;
    }

    public void setIsLast(boolean isLast) {
        this.myIsLast = isLast;
    }

    public void highlightInline(InlineFragment fragment) {
        this.highlightFragmentImpl((Fragment)fragment);
    }

    protected void highlightFragmentImpl(Fragment fragment) {
        this.myAppender1.highlightText(fragment, null);
        this.myAppender2.highlightText(fragment, null);
    }

    public void highlightLine(LineFragment fragment) {
        this.highlightFragmentImpl((Fragment)fragment);
        FragmentHighlighterImpl.addModifyActions(fragment, this.myAppender1, this.myAppender2);
        Iterator iterator = fragment.getChildrenIterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                Fragment childFragment = (Fragment)iterator.next();
                childFragment.highlight((FragmentHighlighter)this);
            }
        }
        if (fragment.isEqual() && this.myIsLast) {
            return;
        }
        FragmentHighlighterImpl.addSeparatingLine(fragment, this.myAppender1, fragment.getStartingLine1(), fragment.getEndLine1());
        FragmentHighlighterImpl.addSeparatingLine(fragment, this.myAppender2, fragment.getStartingLine2(), fragment.getEndLine2());
    }

    private static void addModifyActions(LineFragment fragment, DiffMarkup wrapper, DiffMarkup otherWrapper) {
        if (fragment.isEqual()) {
            return;
        }
        if (fragment.isHasLineChildren()) {
            return;
        }
        FragmentSide side = wrapper.getSide();
        TextRange range = fragment.getRange(side);
        TextRange otherRange = fragment.getRange(side.otherSide());
        Document document = wrapper.getDocument();
        Document otherDocument = otherWrapper.getDocument();
        wrapper.addAction(MergeOperations.mostSensible(document, otherDocument, range, otherRange, side), range.getStartOffset());
        otherWrapper.addAction(MergeOperations.mostSensible(otherDocument, document, otherRange, range, side.otherSide()), otherRange.getStartOffset());
    }

    private static void addSeparatingLine(@NotNull LineFragment fragment, @NotNull DiffMarkup appender, int startLine, int endLine) {
        if (endLine <= 0) {
            return;
        }
        TextDiffTypeEnum type = fragment.getType();
        appender.addLineMarker(endLine - 1, type == null ? null : DiffUtil.makeTextDiffType(fragment), SeparatorPlacement.BOTTOM);
        if (fragment.getRange(appender.getSide()).getLength() > 0 && startLine > 0) {
            appender.addLineMarker(startLine, type == null ? null : DiffUtil.makeTextDiffType(fragment), SeparatorPlacement.TOP);
        }
    }
}

