/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.dir.actions;

import com.intellij.ide.diff.DirDiffModel;
import com.intellij.ide.diff.DirDiffModelHolder;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diff.impl.dir.DirDiffTableModel;
import com.intellij.openapi.diff.impl.dir.actions.ChangeCompareModeGroup;
import com.intellij.openapi.diff.impl.dir.actions.EnableEqual;
import com.intellij.openapi.diff.impl.dir.actions.EnableLeft;
import com.intellij.openapi.diff.impl.dir.actions.EnableNotEqual;
import com.intellij.openapi.diff.impl.dir.actions.EnableRight;
import com.intellij.openapi.diff.impl.dir.actions.RefreshDirDiffAction;
import com.intellij.openapi.diff.impl.dir.actions.SynchronizeDiff;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirDiffToolbarActions
extends ActionGroup {
    private final AnAction[] myActions;

    public DirDiffToolbarActions(DirDiffTableModel model, JComponent panel) {
        super("Directory Diff Actions", false);
        ArrayList<AnAction> actions = new ArrayList<AnAction>(Arrays.asList(new AnAction[]{new RefreshDirDiffAction(model), Separator.getInstance(), new EnableLeft(model), new EnableNotEqual(model), new EnableEqual(model), new EnableRight(model), Separator.getInstance(), new ChangeCompareModeGroup(model), Separator.getInstance()}));
        if (model.isOperationsEnabled()) {
            actions.add((AnAction)new SynchronizeDiff(model, true));
            actions.add((AnAction)new SynchronizeDiff(model, false));
        }
        for (AnAction action : model.getSettings().getExtraActions()) {
            actions.add(action);
        }
        for (AnAction action : actions) {
            ShortcutSet shortcut;
            if (action instanceof ShortcutProvider && (shortcut = ((ShortcutProvider)action).getShortcut()) != null) {
                action.registerCustomShortcutSet(shortcut, panel);
            }
            if (!(action instanceof DirDiffModelHolder)) continue;
            ((DirDiffModelHolder)action).setModel((DirDiffModel)model);
        }
        this.myActions = actions.toArray(new AnAction[actions.size()]);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        return this.myActions;
    }
}

