/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.dir.actions;

import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.diff.impl.dir.DirDiffTableModel;
import com.intellij.openapi.diff.impl.dir.actions.ChangeCompareModeAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.ui.IdeBorderFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ChangeCompareModeGroup
extends ComboBoxAction
implements ShortcutProvider,
DumbAware {
    private final DefaultActionGroup myGroup;
    private DirDiffSettings mySettings;
    private JButton myButton;

    public ChangeCompareModeGroup(DirDiffTableModel model) {
        this.mySettings = model.getSettings();
        this.getTemplatePresentation().setText(this.mySettings.compareMode.getPresentableName(this.mySettings));
        ArrayList<ChangeCompareModeAction> actions = new ArrayList<ChangeCompareModeAction>();
        if (model.getSettings().showCompareModes) {
            for (DirDiffSettings.CompareMode mode : DirDiffSettings.CompareMode.values()) {
                actions.add(new ChangeCompareModeAction(model, mode));
            }
        } else {
            this.getTemplatePresentation().setVisible(false);
            this.getTemplatePresentation().setEnabled(false);
        }
        this.myGroup = new DefaultActionGroup((AnAction[])actions.toArray(new ChangeCompareModeAction[actions.size()]));
    }

    public void actionPerformed(AnActionEvent e) {
        this.myButton.doClick();
    }

    public void update(AnActionEvent e) {
        super.update(e);
        this.getTemplatePresentation().setText(this.mySettings.compareMode.getPresentableName(this.mySettings));
        e.getPresentation().setText(this.mySettings.compareMode.getPresentableName(this.mySettings));
    }

    public JComponent createCustomComponent(Presentation presentation) {
        JPanel panel = new JPanel(new BorderLayout());
        JLabel label = new JLabel("Compare by:");
        label.setDisplayedMnemonicIndex(0);
        panel.add((Component)label, "West");
        this.myButton = (JButton)super.createCustomComponent(presentation).getComponent(0);
        panel.add((Component)this.myButton, "Center");
        panel.setBorder(IdeBorderFactory.createEmptyBorder((int)2, (int)6, (int)2, (int)0));
        return panel;
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        return this.myGroup;
    }

    public ShortcutSet getShortcut() {
        return CustomShortcutSet.fromString((String[])new String[]{"alt C"});
    }
}

