/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl;

import com.intellij.openapi.diff.impl.CaptionIcon;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbAware;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FragmentNumberGutterIconRenderer
extends GutterIconRenderer
implements DumbAware {
    private final String myPresentation;
    private CaptionIcon myIcon;

    public FragmentNumberGutterIconRenderer(String presentation, TextAttributesKey key, Component component, EditorEx editor) {
        this.myPresentation = presentation;
        EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Color color = globalScheme.getAttributes(key).getBackgroundColor();
        this.myIcon = new CaptionIcon(color, editor.getColorsScheme().getFont(EditorFontType.PLAIN), presentation, component, CaptionIcon.Form.ROUNDED, false, false);
    }

    public void resetFont(Editor editor) {
        this.myIcon.setFont(editor.getColorsScheme().getFont(EditorFontType.PLAIN));
    }

    @NotNull
    public Icon getIcon() {
        return this.myIcon;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FragmentNumberGutterIconRenderer that = (FragmentNumberGutterIconRenderer)((Object)o);
        return this.myPresentation.equals(that.myPresentation);
    }

    public int hashCode() {
        return this.myPresentation.hashCode();
    }
}

