/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.actions;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffContentUtil;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.actions.BaseDiffAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class CompareFileWithEditor
extends BaseDiffAction {
    @Nullable
    private static Document getEditingDocument(DataContext dataContext) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            return null;
        }
        VirtualFile[] selectedFiles = FileEditorManager.getInstance((Project)project2).getSelectedFiles();
        if (selectedFiles.length == 0) {
            return null;
        }
        VirtualFile selectedFile = selectedFiles[0];
        Editor editor = FileEditorManager.getInstance((Project)project2).getSelectedTextEditor();
        if (editor != null) {
            for (VirtualFile file2 : selectedFiles) {
                Document document = FileDocumentManager.getInstance().getDocument(file2);
                if (document != editor.getDocument()) continue;
                selectedFile = file2;
            }
        }
        if (!DiffContentUtil.isTextFile((VirtualFile)selectedFile)) {
            return null;
        }
        return FileDocumentManager.getInstance().getDocument(selectedFile);
    }

    @Override
    public void update(AnActionEvent e) {
        boolean enabled = true;
        Presentation presentation = e.getPresentation();
        presentation.setText(DiffBundle.message((String)"diff.compare.element.type.with.editor.action.name", (Object[])new Object[0]));
        if (this.getDiffData(e.getDataContext()) == null) {
            enabled = false;
        }
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            presentation.setVisible(enabled);
        } else {
            presentation.setEnabled(enabled);
        }
    }

    @Override
    protected FileEditorContents getDiffData(DataContext dataContext) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        VirtualFile[] array = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        Document document = CompareFileWithEditor.getEditingDocument(dataContext);
        if (array == null || array.length != 1 || document == null) {
            return null;
        }
        if (array[0].isDirectory()) {
            return null;
        }
        if (CompareFileWithEditor.isSameFile(document, array[0])) {
            return null;
        }
        return new FileEditorContents(document, array[0], project2);
    }

    private static boolean isSameFile(Document document, VirtualFile elementFile) {
        VirtualFile documentFile = FileDocumentManager.getInstance().getFile(document);
        return documentFile != null && documentFile.isValid() && documentFile.equals(elementFile);
    }

    @Override
    protected void disableAction(Presentation presentation) {
        presentation.setVisible(false);
    }

    private static class FileEditorContents
    extends DiffRequest {
        private final VirtualFile myFile;
        private final Document myDocument;

        public FileEditorContents(Document document, VirtualFile file2, Project project2) {
            super(project2);
            this.myDocument = document;
            this.myFile = file2;
        }

        public String[] getContentTitles() {
            VirtualFile documentFile = BaseDiffAction.getDocumentFile(this.myDocument);
            String documentTitle = documentFile != null ? BaseDiffAction.getVirtualFileContentTitle(documentFile) : DiffBundle.message((String)"diff.content.editor.content.title", (Object[])new Object[0]);
            return new String[]{BaseDiffAction.getVirtualFileContentTitle(this.myFile), documentTitle};
        }

        @NotNull
        public DiffContent[] getContents() {
            return new DiffContent[]{DiffContent.fromFile((Project)this.getProject(), (VirtualFile)this.myFile), DiffContent.fromDocument((Project)this.getProject(), (Document)this.myDocument)};
        }

        public String getWindowTitle() {
            if (BaseDiffAction.isEditorContent(this.myDocument)) {
                return DiffBundle.message((String)"diff.element.qualified.name.vs.editor.dialog.title", (Object[])new Object[]{BaseDiffAction.getVirtualFileContentTitle(this.myFile)});
            }
            return DiffBundle.message((String)"diff.element.qualified.name.vs.file.dialog.title", (Object[])new Object[]{BaseDiffAction.getVirtualFileContentTitle(this.myFile), BaseDiffAction.getVirtualFileContentTitle(BaseDiffAction.getDocumentFile(this.myDocument))});
        }

        @NonNls
        public String toString() {
            return "FileEditorContents:" + this.myFile.getPath();
        }
    }
}

