/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.UnknownMacroNotification;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectMacrosUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StorageUtil {
    public static String DEBUG_LOG = null;

    private StorageUtil() {
    }

    public static void doNotify(final @NotNull Set<String> macros, final @NotNull Project project2, final @NotNull Map<TrackingPathMacroSubstitutor, IComponentStore> substitutorToStore) {
        String format = "<p><i>%s</i> %s undefined. <a href=\"define\">Fix it</a></p>";
        String productName = ApplicationNamesInfo.getInstance().getProductName();
        String content = String.format(format, StringUtil.join(macros, (String)", "), macros.size() == 1 ? "is" : "are") + "<br>Path variables are used to substitute absolute paths " + "in " + productName + " project files " + "and allow project file sharing in version control systems.<br>" + "Some of the files describing the current project settings contain unknown path variables " + "and " + productName + " cannot restore those paths.";
        new UnknownMacroNotification("Load Error", "Load error: undefined path variables", content, NotificationType.ERROR, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                StorageUtil.checkUnknownMacros(project2, true, macros, substitutorToStore);
            }
        }, macros).notify(project2);
    }

    public static void checkUnknownMacros(@NotNull Project project2, boolean notify) {
        LinkedHashSet<String> unknownMacros = new LinkedHashSet<String>();
        LinkedHashMap substitutorToStore = ContainerUtil.newLinkedHashMap();
        StorageUtil.collect((ComponentManager)project2, unknownMacros, substitutorToStore);
        for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
            StorageUtil.collect((ComponentManager)module2, unknownMacros, substitutorToStore);
        }
        if (unknownMacros.isEmpty()) {
            return;
        }
        if (notify) {
            StorageUtil.doNotify(unknownMacros, project2, substitutorToStore);
            return;
        }
        StorageUtil.checkUnknownMacros(project2, false, unknownMacros, substitutorToStore);
    }

    private static void checkUnknownMacros(@NotNull Project project2, boolean showDialog, @NotNull Set<String> unknownMacros, @NotNull Map<TrackingPathMacroSubstitutor, IComponentStore> substitutorToStore) {
        if (unknownMacros.isEmpty() || showDialog && !ProjectMacrosUtil.checkMacros(project2, (Set<String>)new THashSet(unknownMacros))) {
            return;
        }
        PathMacros pathMacros = PathMacros.getInstance();
        Iterator<String> it = unknownMacros.iterator();
        while (it.hasNext()) {
            String macro = it.next();
            if (!StringUtil.isEmptyOrSpaces((String)pathMacros.getValue(macro)) || pathMacros.isIgnoredMacroName(macro)) continue;
            it.remove();
        }
        if (unknownMacros.isEmpty()) {
            return;
        }
        for (Map.Entry<TrackingPathMacroSubstitutor, IComponentStore> entry : substitutorToStore.entrySet()) {
            TrackingPathMacroSubstitutor substitutor = entry.getKey();
            Set<String> components = substitutor.getComponents(unknownMacros);
            IComponentStore store = entry.getValue();
            if (store.isReloadPossible(components)) {
                substitutor.invalidateUnknownMacros(unknownMacros);
                for (UnknownMacroNotification notification : (UnknownMacroNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(UnknownMacroNotification.class, project2)) {
                    if (!unknownMacros.containsAll(notification.getMacros())) continue;
                    notification.expire();
                }
                store.reloadStates(components, project2.getMessageBus());
                continue;
            }
            if (Messages.showYesNoDialog((Project)project2, (String)"Component could not be reloaded. Reload project?", (String)"Configuration Changed", (Icon)Messages.getQuestionIcon()) != 0) continue;
            ProjectManagerEx.getInstanceEx().reloadProject(project2);
        }
    }

    private static void collect(@NotNull ComponentManager componentManager, @NotNull Set<String> unknownMacros, @NotNull Map<TrackingPathMacroSubstitutor, IComponentStore> substitutorToStore) {
        IComponentStore store = ServiceKt.getStateStore(componentManager);
        TrackingPathMacroSubstitutor substitutor = store.getStateStorageManager().getMacroSubstitutor();
        if (substitutor == null) {
            return;
        }
        Set<String> macros = substitutor.getUnknownMacros(null);
        if (macros.isEmpty()) {
            return;
        }
        unknownMacros.addAll(macros);
        substitutorToStore.put(substitutor, store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static VirtualFile getOrCreateVirtualFile(@Nullable Object requestor, @NotNull File file2) throws IOException {
        VirtualFile parentVirtualFile;
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
        if (virtualFile != null) {
            return virtualFile;
        }
        File absoluteFile = file2.getAbsoluteFile();
        FileUtil.createParentDirs((File)absoluteFile);
        File parentFile = absoluteFile.getParentFile();
        VirtualFile virtualFile2 = parentVirtualFile = StringUtil.isEmpty((String)parentFile.getPath()) ? null : LocalFileSystem.getInstance().refreshAndFindFileByIoFile(parentFile);
        if (parentVirtualFile == null) {
            throw new IOException(ProjectBundle.message((String)"project.configuration.save.file.not.found", (Object[])new Object[]{parentFile}));
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            return parentVirtualFile.createChildData(requestor, file2.getName());
        }
        AccessToken token = WriteAction.start();
        try {
            VirtualFile virtualFile3 = parentVirtualFile.createChildData(requestor, file2.getName());
            return virtualFile3;
        }
        finally {
            token.finish();
        }
    }
}

