/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.impl.BasePathMacroManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectPathMacroManager
extends BasePathMacroManager {
    private final Project myProject;

    public ProjectPathMacroManager(PathMacros pathMacros, Project project2) {
        super(pathMacros);
        this.myProject = project2;
    }

    @Override
    @NotNull
    public ExpandMacroToPathMap getExpandMacroMap() {
        ExpandMacroToPathMap result = super.getExpandMacroMap();
        ProjectPathMacroManager.addFileHierarchyReplacements(result, "PROJECT_DIR", ProjectPathMacroManager.getProjectDir(this.myProject));
        return result;
    }

    @Override
    @NotNull
    public ReplacePathToMacroMap getReplacePathMap() {
        ReplacePathToMacroMap result = super.getReplacePathMap();
        ProjectPathMacroManager.addFileHierarchyReplacements(result, "PROJECT_DIR", ProjectPathMacroManager.getProjectDir(this.myProject), null);
        return result;
    }

    @Nullable
    private static String getProjectDir(Project project2) {
        VirtualFile baseDir = project2.getBaseDir();
        return baseDir != null ? baseDir.getPath() : null;
    }
}

