/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.impl.BasePathMacroManager;
import com.intellij.openapi.module.Module;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.serialization.PathMacroUtil;

public class ModulePathMacroManager
extends BasePathMacroManager {
    private final Module myModule;

    public ModulePathMacroManager(PathMacros pathMacros, Module module2) {
        super(pathMacros);
        this.myModule = module2;
    }

    @Override
    @NotNull
    public ExpandMacroToPathMap getExpandMacroMap() {
        ExpandMacroToPathMap result = new ExpandMacroToPathMap();
        if (!this.myModule.isDisposed()) {
            ModulePathMacroManager.addFileHierarchyReplacements(result, "MODULE_DIR", PathMacroUtil.getModuleDir((String)this.myModule.getModuleFilePath()));
        }
        result.putAll(super.getExpandMacroMap());
        return result;
    }

    @Override
    @NotNull
    public ReplacePathToMacroMap getReplacePathMap() {
        ReplacePathToMacroMap result = super.getReplacePathMap();
        if (!this.myModule.isDisposed()) {
            String modulePath = PathMacroUtil.getModuleDir((String)this.myModule.getModuleFilePath());
            ModulePathMacroManager.addFileHierarchyReplacements(result, "MODULE_DIR", modulePath, PathMacroUtil.getUserHomePath());
        }
        return result;
    }
}

