/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.application.options.PathMacrosImpl;
import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.CompositePathMacroFilter;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SmartHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.PathMacroUtil;

public class BasePathMacroManager
extends PathMacroManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.components.impl.BasePathMacroManager");
    private PathMacrosImpl myPathMacros;

    public BasePathMacroManager(@Nullable PathMacros pathMacros) {
        this.myPathMacros = (PathMacrosImpl)pathMacros;
    }

    protected static void addFileHierarchyReplacements(@NotNull ExpandMacroToPathMap result, @NotNull String macroName, @Nullable String path) {
        if (path != null) {
            BasePathMacroManager.addFileHierarchyReplacements(result, BasePathMacroManager.getLocalFileSystem().findFileByPath(path), '$' + macroName + '$');
        }
    }

    private static void addFileHierarchyReplacements(@NotNull ExpandMacroToPathMap result, @Nullable VirtualFile f, @NotNull String macro) {
        if (f == null) {
            return;
        }
        BasePathMacroManager.addFileHierarchyReplacements(result, f.getParent(), macro + "/..");
        result.put(macro, StringUtil.trimEnd((String)f.getPath(), (String)"/"));
    }

    protected static void addFileHierarchyReplacements(ReplacePathToMacroMap result, String macroName, @Nullable String path, @Nullable String stopAt) {
        if (path == null) {
            return;
        }
        String macro = '$' + macroName + '$';
        path = StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)path), (String)"/");
        boolean overwrite = true;
        while (StringUtil.isNotEmpty((String)path) && path.contains("/")) {
            result.addReplacement(path, macro, overwrite);
            if (path.equals(stopAt)) break;
            macro = macro + "/..";
            overwrite = false;
            path = StringUtil.getPackageName((String)path, (char)'/');
        }
    }

    @NotNull
    private static VirtualFileSystem getLocalFileSystem() {
        return VirtualFileManager.getInstance().getFileSystem("file");
    }

    @NotNull
    public ExpandMacroToPathMap getExpandMacroMap() {
        ExpandMacroToPathMap result = new ExpandMacroToPathMap();
        for (Map.Entry entry : PathMacroUtil.getGlobalSystemMacros().entrySet()) {
            result.addMacroExpand((String)entry.getKey(), (String)entry.getValue());
        }
        this.getPathMacros().addMacroExpands(result);
        return result;
    }

    @NotNull
    protected ReplacePathToMacroMap getReplacePathMap() {
        ReplacePathToMacroMap result = new ReplacePathToMacroMap();
        for (Map.Entry entry : PathMacroUtil.getGlobalSystemMacros().entrySet()) {
            result.addMacroReplacement((String)entry.getValue(), (String)entry.getKey());
        }
        this.getPathMacros().addMacroReplacements(result);
        return result;
    }

    @Override
    @NotNull
    public TrackingPathMacroSubstitutor createTrackingSubstitutor() {
        return new MyTrackingPathMacroSubstitutor();
    }

    @Override
    public String expandPath(String path) {
        return this.getExpandMacroMap().substitute(path, SystemInfo.isFileSystemCaseSensitive);
    }

    @Override
    public String collapsePath(@Nullable String path) {
        return this.getReplacePathMap().substitute(path, SystemInfo.isFileSystemCaseSensitive);
    }

    @Override
    public void collapsePathsRecursively(@NotNull Element element) {
        this.getReplacePathMap().substitute(element, SystemInfo.isFileSystemCaseSensitive, true);
    }

    @Override
    @NotNull
    public String collapsePathsRecursively(@NotNull String text) {
        return this.getReplacePathMap().substituteRecursively(text, SystemInfo.isFileSystemCaseSensitive);
    }

    @Override
    public void expandPaths(@NotNull Element element) {
        this.getExpandMacroMap().substitute(element, SystemInfo.isFileSystemCaseSensitive);
    }

    @Override
    public void collapsePaths(@NotNull Element element) {
        this.getReplacePathMap().substitute(element, SystemInfo.isFileSystemCaseSensitive);
    }

    @NotNull
    private PathMacrosImpl getPathMacros() {
        if (this.myPathMacros == null) {
            this.myPathMacros = PathMacrosImpl.getInstanceEx();
        }
        return this.myPathMacros;
    }

    protected static boolean pathsEqual(@Nullable String path1, @Nullable String path2) {
        return path1 != null && path2 != null && FileUtil.pathsEqual((String)FileUtil.toSystemIndependentName((String)path1), (String)FileUtil.toSystemIndependentName((String)path2));
    }

    private class MyTrackingPathMacroSubstitutor
    implements TrackingPathMacroSubstitutor {
        private final String myLock = new String("MyTrackingPathMacroSubstitutor.lock");
        private final MultiMap<String, String> myMacroToComponentNames = MultiMap.createSet();
        private final MultiMap<String, String> myComponentNameToMacros = MultiMap.createSet();

        private MyTrackingPathMacroSubstitutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reset() {
            String string = this.myLock;
            synchronized (string) {
                this.myMacroToComponentNames.clear();
                this.myComponentNameToMacros.clear();
            }
        }

        @Override
        public String expandPath(String path) {
            return BasePathMacroManager.this.getExpandMacroMap().substitute(path, SystemInfo.isFileSystemCaseSensitive);
        }

        @Override
        public String collapsePath(@Nullable String path) {
            return BasePathMacroManager.this.getReplacePathMap().substitute(path, SystemInfo.isFileSystemCaseSensitive);
        }

        @Override
        public void expandPaths(@NotNull Element element) {
            BasePathMacroManager.this.getExpandMacroMap().substitute(element, SystemInfo.isFileSystemCaseSensitive);
        }

        @Override
        public void collapsePaths(@NotNull Element element) {
            BasePathMacroManager.this.getReplacePathMap().substitute(element, SystemInfo.isFileSystemCaseSensitive, false, Holder.FILTER);
        }

        public int hashCode() {
            return BasePathMacroManager.this.getExpandMacroMap().hashCode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidateUnknownMacros(@NotNull Set<String> macros) {
            String string = this.myLock;
            synchronized (string) {
                for (String macro : macros) {
                    Collection componentNames = this.myMacroToComponentNames.remove((Object)macro);
                    if (ContainerUtil.isEmpty((Collection)componentNames)) continue;
                    for (String component : componentNames) {
                        this.myComponentNameToMacros.remove((Object)component);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Set<String> getComponents(@NotNull Collection<String> macros) {
            String string = this.myLock;
            synchronized (string) {
                SmartHashSet result = new SmartHashSet();
                for (String macro : macros) {
                    result.addAll(this.myMacroToComponentNames.get((Object)macro));
                }
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Set<String> getUnknownMacros(@Nullable String componentName) {
            String string = this.myLock;
            synchronized (string) {
                Set list = componentName == null ? this.myMacroToComponentNames.keySet() : (Set)this.myComponentNameToMacros.get((Object)componentName);
                return ContainerUtil.isEmpty((Collection)list) ? Collections.emptySet() : Collections.unmodifiableSet(list);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addUnknownMacros(@NotNull String componentName, @NotNull Collection<String> unknownMacros) {
            if (unknownMacros.isEmpty()) {
                return;
            }
            LOG.debug("Registering unknown macros " + new ArrayList<String>(unknownMacros) + " in component " + componentName);
            String string = this.myLock;
            synchronized (string) {
                for (String unknownMacro : unknownMacros) {
                    this.myMacroToComponentNames.putValue((Object)unknownMacro, (Object)componentName);
                }
                this.myComponentNameToMacros.putValues((Object)componentName, unknownMacros);
            }
        }
    }

    private static class Holder {
        private static final CompositePathMacroFilter FILTER = new CompositePathMacroFilter((PathMacroFilter[])Extensions.getExtensions(PathMacrosCollector.MACRO_FILTER_EXTENSION_POINT_NAME));

        private Holder() {
        }
    }
}

