/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xmlb.XmlSerializer;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentSerializationUtil {
    @NotNull
    public static <S> Class<S> getStateClass(@NotNull Class<? extends PersistentStateComponent> aClass) {
        TypeVariable variable = PersistentStateComponent.class.getTypeParameters()[0];
        Type type = ReflectionUtil.resolveVariableInHierarchy(variable, aClass);
        assert (type != null) : aClass;
        Class result = ReflectionUtil.getRawType((Type)type);
        return result;
    }

    public static <S> void loadComponentState(@NotNull PersistentStateComponent<S> configuration, @Nullable Element element) {
        if (element != null) {
            Element state;
            Class<S> stateClass = ComponentSerializationUtil.getStateClass(configuration.getClass());
            Object object = state = stateClass.equals(Element.class) ? element : XmlSerializer.deserialize((Element)element, stateClass);
            if (state != null) {
                configuration.loadState((Object)state);
            }
        }
    }
}

