/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.generic;

import com.intellij.openapi.compiler.generic.CompileItem;
import com.intellij.openapi.compiler.generic.VirtualFilePersistentState;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public abstract class VirtualFileCompileItem<OutputState>
extends CompileItem<String, VirtualFilePersistentState, OutputState> {
    protected final VirtualFile myFile;

    public VirtualFileCompileItem(@NotNull VirtualFile file2) {
        this.myFile = file2;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @Override
    @NotNull
    public VirtualFilePersistentState computeSourceState() {
        return new VirtualFilePersistentState(this.myFile.getTimeStamp());
    }

    @Override
    public boolean isSourceUpToDate(@NotNull VirtualFilePersistentState state) {
        return this.myFile.getTimeStamp() == state.getSourceTimestamp();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.myFile.getUrl();
    }
}

