/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.impl.DocumentReferenceByDocument;
import com.intellij.openapi.command.impl.DocumentReferenceByNonlocalVirtualFile;
import com.intellij.openapi.command.impl.DocumentReferenceByVirtualFile;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.WeakKeyWeakValueHashMap;
import com.intellij.util.containers.WeakValueHashMap;
import com.intellij.util.io.fs.FilePath;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DocumentReferenceManagerImpl
extends DocumentReferenceManager
implements ApplicationComponent {
    private static final Key<List<VirtualFile>> DELETED_FILES = Key.create((String)(DocumentReferenceManagerImpl.class.getName() + ".DELETED_FILES"));
    private final Map<Document, DocumentReference> myDocToRef = new WeakKeyWeakValueHashMap();
    private static final Key<Reference<DocumentReference>> FILE_TO_REF_KEY = Key.create((String)"FILE_TO_REF_KEY");
    private static final Key<DocumentReference> FILE_TO_STRONG_REF_KEY = Key.create((String)"FILE_TO_STRONG_REF_KEY");
    private final Map<FilePath, DocumentReference> myDeletedFilePathToRef = new WeakValueHashMap();

    @NotNull
    public String getComponentName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public void initComponent() {
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new VirtualFileAdapter(){

            public void fileCreated(@NotNull VirtualFileEvent event) {
                VirtualFile f = event.getFile();
                DocumentReference ref = (DocumentReference)DocumentReferenceManagerImpl.this.myDeletedFilePathToRef.remove(new FilePath(f.getUrl()));
                if (ref != null) {
                    f.putUserData(FILE_TO_REF_KEY, new WeakReference<DocumentReference>(ref));
                    ((DocumentReferenceByVirtualFile)ref).update(f);
                }
            }

            public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
                VirtualFile f = event.getFile();
                f.putUserData(DELETED_FILES, (Object)DocumentReferenceManagerImpl.collectDeletedFiles(f, new ArrayList()));
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                VirtualFile f = event.getFile();
                List files = (List)f.getUserData(DELETED_FILES);
                f.putUserData(DELETED_FILES, null);
                assert (files != null) : f;
                for (VirtualFile each : files) {
                    DocumentReference ref = (DocumentReference)SoftReference.dereference((Reference)((Reference)each.getUserData(FILE_TO_REF_KEY)));
                    each.putUserData(FILE_TO_REF_KEY, null);
                    if (ref == null) continue;
                    DocumentReferenceManagerImpl.this.myDeletedFilePathToRef.put(new FilePath(each.getUrl()), ref);
                }
            }
        });
    }

    private static List<VirtualFile> collectDeletedFiles(VirtualFile f, List<VirtualFile> files) {
        if (!(f instanceof NewVirtualFile)) {
            return files;
        }
        if (!f.isDirectory()) {
            files.add(f);
        } else {
            for (VirtualFile each : ((NewVirtualFile)f).iterInDbChildren()) {
                DocumentReferenceManagerImpl.collectDeletedFiles(each, files);
            }
        }
        return files;
    }

    public void disposeComponent() {
    }

    @NotNull
    public DocumentReference create(@NotNull Document document) {
        DocumentReferenceManagerImpl.assertInDispatchThread();
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        return file2 == null ? this.createFromDocument(document) : this.create(file2);
    }

    @NotNull
    private DocumentReference createFromDocument(@NotNull Document document) {
        DocumentReference result = this.myDocToRef.get(document);
        if (result == null) {
            result = new DocumentReferenceByDocument(document);
            this.myDocToRef.put(document, result);
        }
        return result;
    }

    @NotNull
    public DocumentReference create(@NotNull VirtualFile file2) {
        DocumentReferenceManagerImpl.assertInDispatchThread();
        if (!file2.isInLocalFileSystem()) {
            DocumentReference reference = (DocumentReference)file2.getUserData(FILE_TO_STRONG_REF_KEY);
            if (reference == null) {
                reference = new DocumentReferenceByNonlocalVirtualFile(file2);
                file2.putUserData(FILE_TO_STRONG_REF_KEY, (Object)reference);
            }
            return reference;
        }
        assert (file2.isValid()) : "file is invalid: " + file2;
        DocumentReference result = (DocumentReference)SoftReference.dereference((Reference)((Reference)file2.getUserData(FILE_TO_REF_KEY)));
        if (result == null) {
            result = new DocumentReferenceByVirtualFile(file2);
            file2.putUserData(FILE_TO_REF_KEY, new WeakReference<DocumentReference>(result));
        }
        return result;
    }

    private static void assertInDispatchThread() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }
}

