/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ModalityStateEx
extends ModalityState {
    private static final WeakReference[] EMPTY_REFS_ARRAY = new WeakReference[0];
    private final WeakReference[] myModalEntities;

    public ModalityStateEx() {
        this(EMPTY_REFS_ARRAY);
    }

    public ModalityStateEx(@NotNull Object[] modalEntities) {
        if (modalEntities.length > 0) {
            this.myModalEntities = new WeakReference[modalEntities.length];
            for (int i = 0; i < modalEntities.length; ++i) {
                Object entity = modalEntities[i];
                this.myModalEntities[i] = new WeakReference<Object>(entity);
            }
        } else {
            this.myModalEntities = EMPTY_REFS_ARRAY;
        }
    }

    private List<Object> getModalEntities() {
        return ContainerUtil.mapNotNull((Object[])this.myModalEntities, (Function)new Function<WeakReference, Object>(){

            public Object fun(WeakReference reference) {
                return reference.get();
            }
        });
    }

    @NotNull
    public ModalityState appendProgress(@NotNull ProgressIndicator progress) {
        return this.appendEntity(progress);
    }

    @NotNull
    ModalityStateEx appendEntity(@NotNull Object anEntity) {
        ArrayList<Object> list = new ArrayList<Object>(this.myModalEntities.length + 1);
        list.addAll(this.getModalEntities());
        list.add(anEntity);
        return new ModalityStateEx(list.toArray());
    }

    public boolean dominates(@NotNull ModalityState anotherState) {
        if (anotherState == ModalityState.any()) {
            return false;
        }
        List<Object> otherEntities = ((ModalityStateEx)anotherState).getModalEntities();
        for (Object entity : this.getModalEntities()) {
            if (otherEntities.contains(entity)) continue;
            return true;
        }
        return false;
    }

    boolean contains(@NotNull Object modalEntity) {
        return this.getModalEntities().contains(modalEntity);
    }

    @NonNls
    public String toString() {
        if (this.myModalEntities.length == 0) {
            return "ModalityState.NON_MODAL";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("ModalityState:");
        for (int i = 0; i < this.myModalEntities.length; ++i) {
            Object entity = this.myModalEntities[i].get();
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(entity);
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModalityStateEx)) {
            return false;
        }
        List<Object> entities = this.getModalEntities();
        if (entities.isEmpty()) {
            return false;
        }
        return entities.equals(((ModalityStateEx)((Object)o)).getModalEntities());
    }

    public int hashCode() {
        return this.getModalEntities().hashCode();
    }
}

