/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ModalityStateListener;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.diagnostic.FrequentEventDetector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.awt.AWTEvent;
import java.awt.Dialog;
import java.awt.Window;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaterInvocator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.application.impl.LaterInvocator");
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private static final Object LOCK = new Object();
    private static final IdeEventQueue ourEventQueue = IdeEventQueue.getInstance();
    private static final FrequentEventDetector ourFrequentEventDetector = new FrequentEventDetector(1009, 100);
    private static final List<Object> ourModalEntities = ContainerUtil.createLockFreeCopyOnWriteList();
    private static final List<RunnableInfo> ourQueue = new ArrayList<RunnableInfo>();
    private static volatile int ourQueueSkipCount;
    private static final FlushQueue ourFlushQueueRunnable;
    private static final Stack<AWTEvent> ourEventStack;
    private static final EventDispatcher<ModalityStateListener> ourModalityStateMulticaster;
    private static final List<RunnableInfo> ourForcedFlushQueue;
    private static final AtomicBoolean FLUSHER_SCHEDULED;
    private static final Object RUN_LOCK;

    private LaterInvocator() {
    }

    public static void addModalityStateListener(@NotNull ModalityStateListener listener2, @NotNull Disposable parentDisposable) {
        if (!ourModalityStateMulticaster.getListeners().contains(listener2)) {
            ourModalityStateMulticaster.addListener((EventListener)listener2, parentDisposable);
        }
    }

    @NotNull
    static ModalityStateEx modalityStateForWindow(@NotNull Window window) {
        int index = ourModalEntities.indexOf(window);
        if (index < 0) {
            Window owner = window.getOwner();
            if (owner == null) {
                return (ModalityStateEx)ApplicationManager.getApplication().getNoneModalityState();
            }
            ModalityStateEx ownerState = LaterInvocator.modalityStateForWindow(owner);
            if (window instanceof Dialog && ((Dialog)window).isModal()) {
                return ownerState.appendEntity(window);
            }
            return ownerState;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object entity : ourModalEntities) {
            if (!(entity instanceof Window) && (!(entity instanceof ProgressIndicator) || !((ProgressIndicator)entity).isModal())) continue;
            result.add(entity);
        }
        return new ModalityStateEx(result.toArray());
    }

    @NotNull
    static ActionCallback invokeLater(@NotNull Runnable runnable2, @NotNull Condition<?> expired) {
        ModalityState modalityState = ModalityState.defaultModalityState();
        return LaterInvocator.invokeLater(runnable2, modalityState, expired);
    }

    @NotNull
    static ActionCallback invokeLater(@NotNull Runnable runnable2, @NotNull ModalityState modalityState) {
        return LaterInvocator.invokeLater(runnable2, modalityState, Conditions.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static ActionCallback invokeLater(@NotNull Runnable runnable2, @NotNull ModalityState modalityState, @NotNull Condition<?> expired) {
        ourFrequentEventDetector.eventHappened((Object)runnable2);
        ActionCallback callback = new ActionCallback();
        RunnableInfo runnableInfo = new RunnableInfo(runnable2, modalityState, expired, callback);
        Object object = LOCK;
        synchronized (object) {
            ourQueue.add(runnableInfo);
        }
        LaterInvocator.requestFlush();
        return callback;
    }

    static void invokeAndWait(final @NotNull Runnable runnable2, @NotNull ModalityState modalityState) {
        LOG.assertTrue(!LaterInvocator.isDispatchThread());
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        final Ref exception = Ref.create();
        Runnable runnable1 = new Runnable(){

            @Override
            public void run() {
                try {
                    runnable2.run();
                }
                catch (Throwable e) {
                    exception.set((Object)e);
                }
                finally {
                    semaphore.up();
                }
            }

            @NonNls
            public String toString() {
                return "InvokeAndWait[" + runnable2 + "]";
            }
        };
        LaterInvocator.invokeLater(runnable1, modalityState);
        semaphore.waitFor();
        if (!exception.isNull()) {
            throw new RuntimeException((Throwable)exception.get());
        }
    }

    public static void enterModal(@NotNull Object modalEntity) {
        LOG.assertTrue(LaterInvocator.isDispatchThread(), (Object)"enterModal() should be invoked in event-dispatch thread");
        if (LOG.isDebugEnabled()) {
            LOG.debug("enterModal:" + modalEntity);
        }
        ((ModalityStateListener)ourModalityStateMulticaster.getMulticaster()).beforeModalityStateChanged(true);
        ourModalEntities.add(modalEntity);
    }

    public static void leaveModal(@NotNull Object modalEntity) {
        LOG.assertTrue(LaterInvocator.isDispatchThread(), (Object)"leaveModal() should be invoked in event-dispatch thread");
        if (LOG.isDebugEnabled()) {
            LOG.debug("leaveModal:" + modalEntity);
        }
        while (LaterInvocator.ourFlushQueueRunnable.runNextEvent()) {
        }
        ((ModalityStateListener)ourModalityStateMulticaster.getMulticaster()).beforeModalityStateChanged(false);
        boolean removed = ourModalEntities.remove(modalEntity);
        LOG.assertTrue(removed, modalEntity);
        LaterInvocator.cleanupQueueForModal(modalEntity);
        ourQueueSkipCount = 0;
        LaterInvocator.requestFlush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanupQueueForModal(@NotNull Object modalEntity) {
        Object object = LOCK;
        synchronized (object) {
            Iterator<RunnableInfo> iterator = ourQueue.iterator();
            while (iterator.hasNext()) {
                ModalityStateEx stateEx;
                RunnableInfo runnableInfo = iterator.next();
                if (!(runnableInfo.modalityState instanceof ModalityStateEx) || !(stateEx = (ModalityStateEx)runnableInfo.modalityState).contains(modalEntity)) continue;
                ourForcedFlushQueue.add(runnableInfo);
                iterator.remove();
            }
        }
    }

    static void leaveAllModals() {
        ourModalEntities.clear();
        ourQueueSkipCount = 0;
        LaterInvocator.requestFlush();
    }

    @NotNull
    public static Object[] getCurrentModalEntities() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return ArrayUtil.toObjectArray(ourModalEntities);
    }

    public static boolean isInModalContext() {
        LOG.assertTrue(LaterInvocator.isDispatchThread());
        return !ourModalEntities.isEmpty();
    }

    private static boolean isDispatchThread() {
        return ApplicationManager.getApplication().isDispatchThread();
    }

    private static void requestFlush() {
        if (FLUSHER_SCHEDULED.compareAndSet(false, true)) {
            SwingUtilities.invokeLater(ourFlushQueueRunnable);
        }
    }

    public static boolean ensureFlushRequested() {
        if (LaterInvocator.getNextEvent(false) != null) {
            SwingUtilities.invokeLater(ourFlushQueueRunnable);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static RunnableInfo getNextEvent(boolean remove) {
        Object object = LOCK;
        synchronized (object) {
            Application application;
            if (!ourForcedFlushQueue.isEmpty()) {
                RunnableInfo toRun;
                RunnableInfo runnableInfo = toRun = remove ? ourForcedFlushQueue.remove(0) : ourForcedFlushQueue.get(0);
                if (!toRun.expired.value(null)) {
                    return toRun;
                }
                toRun.callback.setDone();
            }
            ModalityStateEx currentModality = ourModalEntities.isEmpty() ? ((application = ApplicationManager.getApplication()) == null ? ModalityState.NON_MODAL : application.getNoneModalityState()) : new ModalityStateEx(ourModalEntities.toArray());
            while (ourQueueSkipCount < ourQueue.size()) {
                RunnableInfo info = ourQueue.get(ourQueueSkipCount);
                if (info.expired.value(null)) {
                    ourQueue.remove(ourQueueSkipCount);
                    info.callback.setDone();
                    continue;
                }
                if (!currentModality.dominates(info.modalityState)) {
                    if (remove) {
                        ourQueue.remove(ourQueueSkipCount);
                    }
                    return info;
                }
                ++ourQueueSkipCount;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RunnableInfo> getLaterInvocatorQueue() {
        Object object = LOCK;
        synchronized (object) {
            return ContainerUtil.newArrayList(ourQueue);
        }
    }

    static /* synthetic */ RunnableInfo access$700(boolean x0) {
        return LaterInvocator.getNextEvent(x0);
    }

    static /* synthetic */ Object access$800() {
        return RUN_LOCK;
    }

    static /* synthetic */ IdeEventQueue access$900() {
        return ourEventQueue;
    }

    static /* synthetic */ Stack access$1000() {
        return ourEventStack;
    }

    static /* synthetic */ Logger access$1200() {
        return LOG;
    }

    static /* synthetic */ boolean access$1300() {
        return DEBUG;
    }

    static {
        ourFlushQueueRunnable = new FlushQueue();
        ourEventStack = new Stack();
        ourModalityStateMulticaster = EventDispatcher.create(ModalityStateListener.class);
        ourForcedFlushQueue = new ArrayList<RunnableInfo>();
        FLUSHER_SCHEDULED = new AtomicBoolean(false);
        RUN_LOCK = new Object();
    }

    private static class FlushQueue
    implements Runnable {
        private RunnableInfo myLastInfo;

        private FlushQueue() {
        }

        @Override
        public void run() {
            FLUSHER_SCHEDULED.set(false);
            if (this.runNextEvent()) {
                LaterInvocator.requestFlush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private boolean runNextEvent() {
            block13: {
                this.myLastInfo = lastInfo = LaterInvocator.access$700(true);
                if (lastInfo == null) break block13;
                var2_2 = LaterInvocator.access$800();
                synchronized (var2_2) {
                    event = LaterInvocator.access$900().getTrueCurrentEvent();
                    LaterInvocator.access$1000().push((Object)event);
                    stackSize = LaterInvocator.access$1000().size();
                    try {
                        RunnableInfo.access$1100(lastInfo).run();
                        RunnableInfo.access$400(lastInfo).setDone();
                    }
                    catch (ProcessCanceledException var5_5) {
                        LaterInvocator.access$1200().assertTrue(LaterInvocator.access$1000().size() == stackSize);
                        LaterInvocator.access$1000().pop();
                        if (!LaterInvocator.access$1300()) {
                            this.myLastInfo = null;
                        }
                    }
                    catch (Throwable t) {
                        LaterInvocator.access$1200().error(t);
                        {
                            catch (Throwable var6_7) {
                                LaterInvocator.access$1200().assertTrue(LaterInvocator.access$1000().size() == stackSize);
                                LaterInvocator.access$1000().pop();
                                if (!LaterInvocator.access$1300()) {
                                    this.myLastInfo = null;
                                }
                                throw var6_7;
                            }
                        }
                        LaterInvocator.access$1200().assertTrue(LaterInvocator.access$1000().size() == stackSize);
                        LaterInvocator.access$1000().pop();
                        if (!LaterInvocator.access$1300()) {
                            this.myLastInfo = null;
                        } else {
                            ** GOTO lbl45
                        }
                    }
                    LaterInvocator.access$1200().assertTrue(LaterInvocator.access$1000().size() == stackSize);
                    LaterInvocator.access$1000().pop();
                    if (!LaterInvocator.access$1300()) {
                        this.myLastInfo = null;
                    }
lbl45:
                    // 3 sources

                }
            }
            return lastInfo != null;
        }

        public String toString() {
            return "LaterInvocator.FlushQueue" + (this.myLastInfo == null ? "" : " lastInfo=" + this.myLastInfo);
        }
    }

    private static class RunnableInfo {
        @NotNull
        private final Runnable runnable;
        @NotNull
        private final ModalityState modalityState;
        @NotNull
        private final Condition<?> expired;
        @NotNull
        private final ActionCallback callback;

        public RunnableInfo(@NotNull Runnable runnable2, @NotNull ModalityState modalityState, @NotNull Condition<?> expired, @NotNull ActionCallback callback) {
            this.runnable = runnable2;
            this.modalityState = modalityState;
            this.expired = expired;
            this.callback = callback;
        }

        @NonNls
        public String toString() {
            return "[runnable: " + this.runnable + "; state=" + this.modalityState + (this.expired.value(null) ? "; expired" : "") + "] ";
        }

        static /* synthetic */ Runnable access$1100(RunnableInfo x0) {
            return x0.runnable;
        }
    }
}

