/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PreloadingActivity;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.io.storage.HeavyProcessLatch;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

public class Preloader
implements ApplicationComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.application.Preloader");
    private final Executor myExecutor = new SequentialTaskExecutor((Executor)PooledThreadExecutor.INSTANCE);
    private final ProgressIndicator myIndicator = new ProgressIndicatorBase();
    private final ProgressIndicator myWrappingIndicator = new AbstractProgressIndicatorBase(){

        @Override
        public void checkCanceled() {
            Preloader.checkHeavyProcessRunning();
            Preloader.this.myIndicator.checkCanceled();
        }

        @Override
        public boolean isCanceled() {
            return Preloader.this.myIndicator.isCanceled();
        }
    };

    private static void checkHeavyProcessRunning() {
        if (HeavyProcessLatch.INSTANCE.isRunning()) {
            TimeoutUtil.sleep((long)1L);
        }
    }

    public void initComponent() {
        if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        for (final PreloadingActivity activity : (PreloadingActivity[])PreloadingActivity.EP_NAME.getExtensions()) {
            this.myExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    if (Preloader.this.myIndicator.isCanceled()) {
                        return;
                    }
                    Preloader.checkHeavyProcessRunning();
                    if (Preloader.this.myIndicator.isCanceled()) {
                        return;
                    }
                    ProgressManager.getInstance().runProcess(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                activity.preload(Preloader.this.myWrappingIndicator);
                            }
                            catch (ProcessCanceledException processCanceledException) {
                                // empty catch block
                            }
                            LOG.info("Finished preloading " + activity);
                        }
                    }, Preloader.this.myIndicator);
                }
            });
        }
    }

    public void disposeComponent() {
        this.myIndicator.cancel();
    }

    @NotNull
    public String getComponentName() {
        return "Preloader";
    }
}

