/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PluginPathManager {
    private PluginPathManager() {
    }

    public static File getPluginHome(String pluginName) {
        File subrepo = PluginPathManager.findSubrepo(pluginName);
        if (subrepo != null) {
            return subrepo;
        }
        return new File(PathManager.getHomePath(), "plugins/" + pluginName);
    }

    private static File findSubrepo(String pluginName) {
        for (File subrepo : SubrepoHolder.subrepos) {
            File candidate = new File(subrepo, pluginName);
            if (!candidate.isDirectory()) continue;
            return candidate;
        }
        return null;
    }

    public static String getPluginHomePath(String pluginName) {
        return PluginPathManager.getPluginHome(pluginName).getPath();
    }

    public static String getPluginHomePathRelative(String pluginName) {
        File subrepo = PluginPathManager.findSubrepo(pluginName);
        if (subrepo != null) {
            String homePath = FileUtil.toSystemIndependentName((String)PathManager.getHomePath());
            return "/" + FileUtil.getRelativePath((String)homePath, (String)FileUtil.toSystemIndependentName((String)subrepo.getPath()), (char)'/');
        }
        return "/plugins/" + pluginName;
    }

    private static class SubrepoHolder {
        public static List<File> subrepos = SubrepoHolder.findSubrepos();

        private SubrepoHolder() {
        }

        private static List<File> findSubrepos() {
            File[] gitRoots;
            ArrayList<File> result = new ArrayList<File>();
            for (File subdir : gitRoots = SubrepoHolder.getSortedGitRoots(new File(PathManager.getHomePath()))) {
                File pluginsDir = new File(subdir, "plugins");
                if (pluginsDir.exists()) {
                    result.add(pluginsDir);
                } else {
                    result.add(subdir);
                }
                result.addAll(Arrays.asList(SubrepoHolder.getSortedGitRoots(subdir)));
            }
            return result;
        }

        @NotNull
        private static File[] getSortedGitRoots(@NotNull File dir) {
            File[] gitRoots = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File child) {
                    return child.isDirectory() && new File(child, ".git").exists();
                }
            });
            if (gitRoots == null) {
                return new File[0];
            }
            Arrays.sort(gitRoots, new Comparator<File>(){

                @Override
                public int compare(File file2, File file22) {
                    return FileUtil.compareFiles((File)file2, (File)file22);
                }
            });
            return gitRoots;
        }
    }
}

