/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.QuickSwitchSchemeAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.impl.BundledQuickListsProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.project.Project;
import com.intellij.util.ThrowableConvertor;
import gnu.trove.THashSet;
import java.io.File;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class QuickListsManager
implements ExportableApplicationComponent {
    private static final String LIST_TAG = "list";
    private final ActionManager myActionManager;
    private final SchemesManager<QuickList, QuickList> mySchemeManager;

    public QuickListsManager(@NotNull ActionManager actionManager, @NotNull SchemesManagerFactory schemesManagerFactory) {
        this.myActionManager = actionManager;
        this.mySchemeManager = schemesManagerFactory.create("quicklists", (SchemeProcessor)new SchemeProcessor<QuickList>(){

            @NotNull
            public QuickList readScheme(@NotNull Element element) {
                return QuickListsManager.createItem(element);
            }

            public Element writeScheme(@NotNull QuickList scheme) {
                Element element = new Element(QuickListsManager.LIST_TAG);
                scheme.writeExternal(element);
                return element;
            }
        });
    }

    @NotNull
    public static QuickListsManager getInstance() {
        return (QuickListsManager)ApplicationManager.getApplication().getComponent(QuickListsManager.class);
    }

    @NotNull
    public File[] getExportFiles() {
        return new File[]{this.mySchemeManager.getRootDirectory()};
    }

    @NotNull
    public String getPresentableName() {
        return IdeBundle.message((String)"quick.lists.presentable.name", (Object[])new Object[0]);
    }

    @NotNull
    private static QuickList createItem(@NotNull Element element) {
        QuickList item = new QuickList();
        item.readExternal(element);
        return item;
    }

    @NotNull
    public String getComponentName() {
        return "QuickListsManager";
    }

    public void initComponent() {
        for (BundledQuickListsProvider provider : (BundledQuickListsProvider[])BundledQuickListsProvider.EP_NAME.getExtensions()) {
            for (String path : provider.getBundledListsRelativePaths()) {
                this.mySchemeManager.loadBundledScheme(path, (Object)provider, (ThrowableConvertor)new ThrowableConvertor<Element, QuickList, Throwable>(){

                    public QuickList convert(Element element) throws Throwable {
                        return QuickListsManager.createItem(element);
                    }
                });
            }
        }
        this.mySchemeManager.loadSchemes();
        this.registerActions();
    }

    public void disposeComponent() {
    }

    @NotNull
    public SchemesManager<QuickList, QuickList> getSchemeManager() {
        return this.mySchemeManager;
    }

    @NotNull
    public QuickList[] getAllQuickLists() {
        List lists = this.mySchemeManager.getAllSchemes();
        return lists.toArray(new QuickList[lists.size()]);
    }

    private void registerActions() {
        THashSet registeredIds = new THashSet();
        for (QuickList list : this.mySchemeManager.getAllSchemes()) {
            String actionId = list.getActionId();
            if (!registeredIds.add(actionId)) continue;
            this.myActionManager.registerAction(actionId, (AnAction)new InvokeQuickListAction(list));
        }
    }

    private void unregisterActions() {
        for (String oldId : this.myActionManager.getActionIds("QuickList.")) {
            this.myActionManager.unregisterAction(oldId);
        }
    }

    public void setQuickLists(@NotNull List<QuickList> quickLists) {
        this.unregisterActions();
        this.mySchemeManager.setSchemes(quickLists);
        this.registerActions();
    }

    private static class InvokeQuickListAction
    extends QuickSwitchSchemeAction {
        private final QuickList myQuickList;

        public InvokeQuickListAction(@NotNull QuickList quickList) {
            this.myQuickList = quickList;
            this.myActionPlace = "ActionPlace.QuickListPopupAction";
            this.getTemplatePresentation().setDescription(this.myQuickList.getDescription());
            this.getTemplatePresentation().setText(this.myQuickList.getName(), false);
        }

        protected void fillActions(Project project2, @NotNull DefaultActionGroup group, @NotNull DataContext dataContext) {
            ActionManager actionManager = ActionManager.getInstance();
            for (String actionId : this.myQuickList.getActionIds()) {
                if ("QuickList.$Separator$".equals(actionId)) {
                    group.addSeparator();
                    continue;
                }
                AnAction action = actionManager.getAction(actionId);
                if (action == null) continue;
                group.add(action);
            }
        }

        protected boolean isEnabled() {
            return true;
        }
    }
}

