/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.openapi.options.ExternalizableSchemeAdapter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickList
extends ExternalizableSchemeAdapter {
    public static final String QUICK_LIST_PREFIX = "QuickList.";
    public static final String SEPARATOR_ID = "QuickList.$Separator$";
    private static final String ID_TAG = "id";
    private static final String ACTION_TAG = "action";
    private static final String DISPLAY_NAME_TAG = "display";
    private static final String DESCRIPTION_TAG = "description";
    private String myDescription;
    private String[] myActionIds = ArrayUtil.EMPTY_STRING_ARRAY;

    QuickList() {
        this.myName = "";
    }

    public QuickList(@NotNull String name, @Nullable String description, String[] actionIds) {
        this.myName = name;
        this.myDescription = StringUtil.nullize((String)description);
        this.myActionIds = actionIds;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(@Nullable String value) {
        this.myDescription = StringUtil.nullize((String)value);
    }

    public String[] getActionIds() {
        return this.myActionIds;
    }

    public void setActionIds(@NotNull String[] value) {
        this.myActionIds = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QuickList)) {
            return false;
        }
        QuickList quickList = (QuickList)((Object)o);
        return Arrays.equals(this.myActionIds, quickList.myActionIds) && Comparing.strEqual((String)this.myDescription, (String)quickList.myDescription) && this.myName.equals(quickList.myName);
    }

    public int hashCode() {
        return 29 * this.myName.hashCode() + Comparing.hashcode((Object)this.myDescription);
    }

    public String toString() {
        return this.getName() + " " + this.getDescription();
    }

    @NotNull
    public String getActionId() {
        return QUICK_LIST_PREFIX + this.getName();
    }

    public void writeExternal(@NotNull Element groupElement) {
        groupElement.setAttribute(DISPLAY_NAME_TAG, this.myName);
        if (this.myDescription != null) {
            groupElement.setAttribute(DESCRIPTION_TAG, this.myDescription);
        }
        for (String actionId : this.getActionIds()) {
            groupElement.addContent(new Element(ACTION_TAG).setAttribute(ID_TAG, actionId));
        }
    }

    public void readExternal(@NotNull Element element) {
        this.myName = element.getAttributeValue(DISPLAY_NAME_TAG);
        this.myDescription = StringUtil.nullize((String)element.getAttributeValue(DESCRIPTION_TAG));
        List actionElements = element.getChildren(ACTION_TAG);
        this.myActionIds = new String[actionElements.size()];
        int n = actionElements.size();
        for (int i = 0; i < n; ++i) {
            this.myActionIds[i] = ((Element)actionElements.get(i)).getAttributeValue(ID_TAG);
        }
    }
}

