/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.actions;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.connect.StatisticsNotification;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.messages.MessageBus;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationTestAction
extends AnAction
implements DumbAware {
    public static final String TEST_GROUP_ID = "Test Notification";
    private static final NotificationGroup TEST_STICKY_GROUP = new NotificationGroup("Test Sticky Notification", NotificationDisplayType.STICKY_BALLOON, true);
    private static final String MESSAGE_KEY = "NotificationTestAction_Message";

    public void actionPerformed(@NotNull AnActionEvent event) {
        new NotificationDialog(event.getProject(), NotificationsManagerImpl.newEnabled()).show();
    }

    private static class NotificationInfo
    implements NotificationListener {
        private String myGroupId;
        private String myTitle;
        private String mySubtitle;
        private List<String> myContent;
        private List<String> myActions;
        private boolean mySticky;
        private Notification myNotification;

        private NotificationInfo() {
        }

        public Notification getNotification() {
            if (this.myNotification == null) {
                String content;
                Icon icon = null;
                if (this.myGroupId != null) {
                    icon = IconLoader.findIcon((String)this.myGroupId);
                }
                if ("!!!St!!!".equals(this.myTitle)) {
                    this.myNotification = new StatisticsNotification("IDE Usage Statistics", this).setIcon(icon);
                    return this.myNotification;
                }
                String displayId = this.mySticky ? TEST_STICKY_GROUP.getDisplayId() : NotificationTestAction.TEST_GROUP_ID;
                String string = content = this.myContent == null ? "" : StringUtil.join(this.myContent, (String)"\n");
                if (icon == null) {
                    this.myNotification = new Notification(displayId, StringUtil.notNullize((String)this.myTitle), content, NotificationType.INFORMATION, (NotificationListener)this);
                } else {
                    this.myNotification = new Notification(displayId, icon, this.myTitle, this.mySubtitle, content, NotificationType.INFORMATION, (NotificationListener)this);
                    if (this.myActions != null) {
                        for (String action : this.myActions) {
                            this.myNotification.addAction((AnAction)new MyAnAction(action));
                        }
                    }
                }
            }
            return this.myNotification;
        }

        public void setGroupId(@Nullable String groupId) {
            this.myGroupId = groupId;
        }

        public void setTitle(@Nullable String title) {
            this.myTitle = title;
        }

        public void setSubtitle(@Nullable String subtitle) {
            this.mySubtitle = subtitle;
        }

        public void addContent(@NotNull String content) {
            if (this.myContent == null) {
                this.myContent = new ArrayList<String>();
            }
            this.myContent.add(content);
        }

        public void setActions(@NotNull List<String> actions) {
            this.myActions = actions;
        }

        public void setSticky(boolean sticky) {
            this.mySticky = sticky;
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (MessageDialogBuilder.yesNo((String)"Notification Listener", (String)(event.getDescription() + "      Expire?")).is()) {
                this.myNotification.expire();
                this.myNotification = null;
            }
        }

        private class MyAnAction
        extends AnAction {
            private MyAnAction(String text) {
                if (text != null) {
                    Icon icon;
                    if (text.endsWith(".png") && (icon = IconLoader.findIcon((String)text)) != null) {
                        this.getTemplatePresentation().setIcon(icon);
                        return;
                    }
                    this.getTemplatePresentation().setText(text);
                }
            }

            public void actionPerformed(AnActionEvent e) {
                if (MessageDialogBuilder.yesNo((String)"AnAction", (String)(this.getTemplatePresentation().getText() + "      Expire?")).is()) {
                    NotificationInfo.this.myNotification.expire();
                    NotificationInfo.this.myNotification = null;
                }
            }
        }
    }

    private static final class NotificationDialog
    extends DialogWrapper {
        private final JTextField myTitle = new JTextField(50);
        private final JTextArea myMessage = new JTextArea(10, 50);
        private final JComboBox myType = new JComboBox<NotificationType>(NotificationType.values());
        private final MessageBus myMessageBus;
        private final boolean myIsNew;

        private NotificationDialog(@Nullable Project project2, boolean isNew) {
            super(project2, true, DialogWrapper.IdeModalityType.MODELESS);
            this.myIsNew = isNew;
            this.myMessageBus = project2 != null ? project2.getMessageBus() : ApplicationManager.getApplication().getMessageBus();
            this.init();
            this.setOKButtonText("Notify");
            this.setTitle(NotificationTestAction.TEST_GROUP_ID);
            if (isNew) {
                this.myMessage.setText(PropertiesComponent.getInstance().getValue(NotificationTestAction.MESSAGE_KEY, "GroupID:\nTitle:\nSubtitle:\nContent:\nContent:\nActions:\nSticky:\n"));
            } else {
                this.myMessage.setText("You can close<br>\nthis very very very very long notification\nby clicking <a href=\"close\">this link</a>.\n<p>Long long long long. It should be long. Very long. Too long. And even longer.");
            }
        }

        @Nullable
        protected String getDimensionServiceKey() {
            return this.myIsNew ? "NotificationTestAction" : null;
        }

        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel(new BorderLayout(10, 10));
            if (!this.myIsNew) {
                panel.add("North", this.myTitle);
                panel.add("South", this.myType);
            }
            panel.add("Center", new JScrollPane(this.myMessage));
            return panel;
        }

        @NotNull
        protected Action[] createActions() {
            return new Action[]{this.getOKAction(), this.getCancelAction()};
        }

        public void doCancelAction() {
            if (this.myIsNew) {
                PropertiesComponent.getInstance().setValue(NotificationTestAction.MESSAGE_KEY, this.myMessage.getText());
            }
            super.doCancelAction();
        }

        protected void doOKAction() {
            String message = this.myMessage.getText();
            if (this.myIsNew) {
                this.newNotification(message);
                return;
            }
            String title = this.myTitle.getText();
            Object value = this.myType.getSelectedItem();
            NotificationType type = value instanceof NotificationType ? (NotificationType)value : NotificationType.ERROR;
            final Notification notification = new Notification(NotificationTestAction.TEST_GROUP_ID, title, message, type, new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    notification.expire();
                }
            });
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    ((Notifications)myMessageBus.syncPublisher(Notifications.TOPIC)).notify(notification);
                }
            });
        }

        private void newNotification(String text) {
            final ArrayList<NotificationInfo> notifications = new ArrayList<NotificationInfo>();
            NotificationInfo notification = null;
            for (String line : StringUtil.splitByLines((String)text, (boolean)false)) {
                String value;
                if (line.length() == 0 && notification != null) {
                    notification = null;
                    continue;
                }
                if (line.startsWith("//")) continue;
                if (line.startsWith("--")) break;
                if (notification == null) {
                    notification = new NotificationInfo();
                    notifications.add(notification);
                }
                if (line.startsWith("GroupID:")) {
                    notification.setGroupId(StringUtil.substringAfter((String)line, (String)":"));
                    continue;
                }
                if (line.startsWith("Title:")) {
                    notification.setTitle(StringUtil.substringAfter((String)line, (String)":"));
                    continue;
                }
                if (line.startsWith("Content:")) {
                    value = StringUtil.substringAfter((String)line, (String)":");
                    if (value == null) continue;
                    notification.addContent(value);
                    continue;
                }
                if (line.startsWith("Subtitle:")) {
                    notification.setSubtitle(StringUtil.substringAfter((String)line, (String)":"));
                    continue;
                }
                if (line.startsWith("Actions:")) {
                    value = StringUtil.substringAfter((String)line, (String)":");
                    if (value == null) continue;
                    notification.setActions(StringUtil.split((String)value, (String)","));
                    continue;
                }
                if (!line.startsWith("Sticky:")) continue;
                notification.setSticky("true".equals(StringUtil.substringAfter((String)line, (String)":")));
            }
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    for (NotificationInfo info : notifications) {
                        ((Notifications)myMessageBus.syncPublisher(Notifications.TOPIC)).notify(info.getNotification());
                    }
                }
            });
        }
    }
}

