/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.notification.NotificationDisplayType;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NotificationSettings {
    private final String myGroupId;
    private final NotificationDisplayType myDisplayType;
    private final boolean myShouldLog;
    private final boolean myShouldReadAloud;

    public NotificationSettings(String groupId, NotificationDisplayType displayType, boolean shouldLog, boolean shouldReadAloud) {
        this.myGroupId = groupId;
        this.myDisplayType = displayType;
        this.myShouldLog = shouldLog;
        this.myShouldReadAloud = shouldReadAloud;
    }

    @NotNull
    public String getGroupId() {
        return this.myGroupId;
    }

    @NotNull
    public NotificationDisplayType getDisplayType() {
        return this.myDisplayType;
    }

    public boolean isShouldLog() {
        return this.myShouldLog;
    }

    public NotificationSettings withShouldLog(boolean shouldLog) {
        return new NotificationSettings(this.myGroupId, this.myDisplayType, shouldLog, this.myShouldReadAloud);
    }

    public boolean isShouldReadAloud() {
        return this.myShouldReadAloud;
    }

    public NotificationSettings withShouldReadAloud(boolean shouldReadAloud) {
        return new NotificationSettings(this.myGroupId, this.myDisplayType, this.myShouldLog, shouldReadAloud);
    }

    public NotificationSettings withDisplayType(NotificationDisplayType displayType) {
        return new NotificationSettings(this.myGroupId, displayType, this.myShouldLog, this.myShouldReadAloud);
    }

    @Nullable
    public static NotificationSettings load(@NotNull Element element) {
        String displayTypeString = element.getAttributeValue("displayType");
        NotificationDisplayType displayType = NotificationDisplayType.BALLOON;
        boolean shouldLog = !"false".equals(element.getAttributeValue("shouldLog"));
        boolean shouldReadAloud = "true".equals(element.getAttributeValue("shouldReadAloud"));
        if ("BALLOON_ONLY".equals(displayTypeString)) {
            shouldLog = false;
            displayType = NotificationDisplayType.BALLOON;
        } else if (displayTypeString != null) {
            try {
                displayType = NotificationDisplayType.valueOf((String)displayTypeString.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        String groupId = element.getAttributeValue("groupId");
        return groupId != null ? new NotificationSettings(groupId, displayType, shouldLog, shouldReadAloud) : null;
    }

    @NotNull
    public Element save() {
        Element result = new Element("notification");
        result.setAttribute("groupId", this.getGroupId());
        NotificationDisplayType displayType = this.getDisplayType();
        if (displayType != NotificationDisplayType.BALLOON) {
            result.setAttribute("displayType", displayType.toString());
        }
        if (!this.myShouldLog) {
            result.setAttribute("shouldLog", "false");
        }
        if (this.myShouldReadAloud) {
            result.setAttribute("shouldReadAloud", "true");
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NotificationSettings)) {
            return false;
        }
        NotificationSettings settings = (NotificationSettings)o;
        if (this.myShouldLog != settings.myShouldLog) {
            return false;
        }
        if (this.myShouldReadAloud != settings.myShouldReadAloud) {
            return false;
        }
        if (this.myDisplayType != settings.myDisplayType) {
            return false;
        }
        return this.myGroupId.equals(settings.myGroupId);
    }

    public int hashCode() {
        int result = this.myGroupId.hashCode();
        result = 31 * result + this.myDisplayType.hashCode();
        result = 31 * result + (this.myShouldLog ? 1 : 0);
        result = 31 * result + (this.myShouldReadAloud ? 1 : 0);
        return result;
    }
}

