/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.moduleDependencies;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.moduleDependencies.DependenciesAnalyzeManager;
import com.intellij.moduleDependencies.ModulesDependenciesPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.PsiElement;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import java.awt.GridLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;

public class ShowModuleDependenciesAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabled(e.getProject() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Module[] modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(e.getDataContext());
        if (modules == null) {
            Module module2;
            PsiElement element = (PsiElement)CommonDataKeys.PSI_FILE.getData(e.getDataContext());
            Module module3 = module2 = element != null ? ModuleUtilCore.findModuleForPsiElement((PsiElement)element) : null;
            if (module2 != null && ModuleManager.getInstance((Project)project2).getModules().length > 1) {
                MyModuleOrProjectScope dlg = new MyModuleOrProjectScope(module2.getName());
                if (!dlg.showAndGet()) {
                    return;
                }
                if (!dlg.useProjectScope()) {
                    modules = new Module[]{module2};
                }
            }
        }
        ModulesDependenciesPanel panel = new ModulesDependenciesPanel(project2, modules);
        AnalysisScope scope = modules != null ? new AnalysisScope(modules) : new AnalysisScope(project2);
        Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)panel, scope.getDisplayName(), false);
        content.setDisposer((Disposable)panel);
        panel.setContent(content);
        DependenciesAnalyzeManager.getInstance(project2).addContent(content);
    }

    private static class MyModuleOrProjectScope
    extends DialogWrapper {
        private final JRadioButton myProjectScope;
        private final JRadioButton myModuleScope;

        protected MyModuleOrProjectScope(String moduleName) {
            super(false);
            this.setTitle(AnalysisScopeBundle.message((String)"module.dependencies.scope.dialog.title", (Object[])new Object[0]));
            ButtonGroup group = new ButtonGroup();
            this.myProjectScope = new JRadioButton(AnalysisScopeBundle.message((String)"module.dependencies.scope.dialog.project.button", (Object[])new Object[0]));
            this.myModuleScope = new JRadioButton(AnalysisScopeBundle.message((String)"module.dependencies.scope.dialog.module.button", (Object[])new Object[]{moduleName}));
            group.add(this.myProjectScope);
            group.add(this.myModuleScope);
            this.myProjectScope.setSelected(true);
            this.init();
        }

        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel(new GridLayout(2, 1));
            panel.add(this.myProjectScope);
            panel.add(this.myModuleScope);
            return panel;
        }

        public boolean useProjectScope() {
            return this.myProjectScope.isSelected();
        }
    }
}

