/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.mock.MockFileManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.util.PsiModificationTracker;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockPsiManager
extends PsiManagerEx {
    private final Project myProject;
    private final Map<VirtualFile, PsiDirectory> myDirectories = new THashMap();
    private MockFileManager myMockFileManager;
    private PsiModificationTrackerImpl myPsiModificationTracker;

    public MockPsiManager(@NotNull Project project2) {
        this.myProject = project2;
    }

    public void addPsiDirectory(VirtualFile file2, PsiDirectory psiDirectory) {
        this.myDirectories.put(file2, psiDirectory);
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    public PsiFile findFile(@NotNull VirtualFile file2) {
        return null;
    }

    @Nullable
    public FileViewProvider findViewProvider(@NotNull VirtualFile file2) {
        return null;
    }

    public PsiDirectory findDirectory(@NotNull VirtualFile file2) {
        return this.myDirectories.get(file2);
    }

    public boolean areElementsEquivalent(PsiElement element1, PsiElement element2) {
        return Comparing.equal((Object)element1, (Object)element2);
    }

    public void reloadFromDisk(@NotNull PsiFile file2) {
    }

    public void addPsiTreeChangeListener(@NotNull PsiTreeChangeListener listener2) {
    }

    public void addPsiTreeChangeListener(@NotNull PsiTreeChangeListener listener2, @NotNull Disposable parentDisposable) {
    }

    public void removePsiTreeChangeListener(@NotNull PsiTreeChangeListener listener2) {
    }

    @NotNull
    public PsiModificationTracker getModificationTracker() {
        if (this.myPsiModificationTracker == null) {
            this.myPsiModificationTracker = new PsiModificationTrackerImpl(this.myProject);
        }
        return this.myPsiModificationTracker;
    }

    public void startBatchFilesProcessingMode() {
    }

    public void finishBatchFilesProcessingMode() {
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        return null;
    }

    public <T> void putUserData(@NotNull Key<T> key, T value) {
    }

    public boolean isDisposed() {
        return false;
    }

    public void dropResolveCaches() {
        this.getFileManager().cleanupForNextTest();
    }

    public boolean isInProject(@NotNull PsiElement element) {
        return false;
    }

    @Override
    public boolean isBatchFilesProcessingMode() {
        return false;
    }

    @Override
    public boolean isAssertOnFileLoading(@NotNull VirtualFile file2) {
        return false;
    }

    @Override
    public void beforeChange(boolean isPhysical) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void afterChange(boolean isPhysical) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerRunnableToRunOnChange(@NotNull Runnable runnable2) {
    }

    @Override
    public void registerRunnableToRunOnAnyChange(@NotNull Runnable runnable2) {
    }

    @Override
    public void registerRunnableToRunAfterAnyChange(@NotNull Runnable runnable2) {
        throw new UnsupportedOperationException("Method registerRunnableToRunAfterAnyChange is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @Override
    @NotNull
    public FileManager getFileManager() {
        if (this.myMockFileManager == null) {
            this.myMockFileManager = new MockFileManager(this);
        }
        return this.myMockFileManager;
    }

    @Override
    public void beforeChildRemoval(@NotNull PsiTreeChangeEventImpl event) {
    }

    @Override
    public void beforeChildReplacement(@NotNull PsiTreeChangeEventImpl event) {
    }

    @Override
    public void beforeChildAddition(@NotNull PsiTreeChangeEventImpl event) {
    }
}

