/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.mock.MockLanguageFileType;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockFileTypeManager
extends FileTypeManagerEx {
    private final FileType fileType;

    public MockFileTypeManager(FileType fileType) {
        this.fileType = fileType;
    }

    @Override
    public void registerFileType(@NotNull FileType fileType) {
    }

    @Override
    public void unregisterFileType(@NotNull FileType fileType) {
    }

    @NotNull
    public String getIgnoredFilesList() {
        throw new IncorrectOperationException();
    }

    public void setIgnoredFilesList(@NotNull String list) {
    }

    @Override
    public boolean isIgnoredFilesListEqualToCurrent(@NotNull String list) {
        return false;
    }

    public void save() {
    }

    @Override
    @NotNull
    public String getExtension(@NotNull String fileName) {
        return "";
    }

    public void registerFileType(@NotNull FileType type, @NotNull List<FileNameMatcher> defaultAssociations) {
    }

    @Override
    public void fireFileTypesChanged() {
    }

    @NotNull
    public FileType getFileTypeByFileName(@NotNull String fileName) {
        return this.fileType;
    }

    @NotNull
    public FileType getFileTypeByFile(@NotNull VirtualFile file2) {
        return this.fileType;
    }

    @NotNull
    public FileType getFileTypeByExtension(@NotNull String extension) {
        return this.fileType;
    }

    @NotNull
    public FileType[] getRegisteredFileTypes() {
        return FileType.EMPTY_ARRAY;
    }

    public boolean isFileIgnored(@NotNull String name) {
        return false;
    }

    public boolean isFileIgnored(@NotNull VirtualFile file2) {
        return false;
    }

    @NotNull
    public String[] getAssociatedExtensions(@NotNull FileType type) {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    public void fireBeforeFileTypesChanged() {
    }

    public void addFileTypeListener(@NotNull FileTypeListener listener2) {
    }

    public void removeFileTypeListener(@NotNull FileTypeListener listener2) {
    }

    public FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile file2) {
        return file2.getFileType();
    }

    public FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile file2, @NotNull Project project2) {
        return this.getKnownFileTypeOrAssociate(file2);
    }

    @NotNull
    public List<FileNameMatcher> getAssociations(@NotNull FileType type) {
        return Collections.emptyList();
    }

    public void associate(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
    }

    public void removeAssociation(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
    }

    @NotNull
    public FileType getStdFileType(@NotNull @NonNls String fileTypeName) {
        if ("ARCHIVE".equals(fileTypeName) || "CLASS".equals(fileTypeName)) {
            return UnknownFileType.INSTANCE;
        }
        if ("PLAIN_TEXT".equals(fileTypeName)) {
            return PlainTextFileType.INSTANCE;
        }
        if ("JAVA".equals(fileTypeName)) {
            return MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.JavaFileType", fileTypeName);
        }
        if ("XML".equals(fileTypeName)) {
            return MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.XmlFileType", fileTypeName);
        }
        if ("DTD".equals(fileTypeName)) {
            return MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.DTDFileType", fileTypeName);
        }
        if ("JSP".equals(fileTypeName)) {
            return MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.NewJspFileType", fileTypeName);
        }
        if ("JSPX".equals(fileTypeName)) {
            return MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.JspxFileType", fileTypeName);
        }
        if ("HTML".equals(fileTypeName)) {
            return MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.HtmlFileType", fileTypeName);
        }
        if ("XHTML".equals(fileTypeName)) {
            return MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.XHtmlFileType", fileTypeName);
        }
        if ("JavaScript".equals(fileTypeName)) {
            return MockFileTypeManager.loadFileTypeSafe("com.intellij.lang.javascript.JavaScriptFileType", fileTypeName);
        }
        if ("Properties".equals(fileTypeName)) {
            return MockFileTypeManager.loadFileTypeSafe("com.intellij.lang.properties.PropertiesFileType", fileTypeName);
        }
        return new MockLanguageFileType(PlainTextLanguage.INSTANCE, fileTypeName.toLowerCase());
    }

    private static FileType loadFileTypeSafe(String className, String fileTypeName) {
        try {
            return (FileType)Class.forName(className).getField("INSTANCE").get(null);
        }
        catch (Exception ignored) {
            return new MockLanguageFileType(PlainTextLanguage.INSTANCE, fileTypeName.toLowerCase(Locale.ENGLISH));
        }
    }

    public boolean isFileOfType(@NotNull VirtualFile file2, @NotNull FileType type) {
        return false;
    }

    @NotNull
    public FileType detectFileTypeFromContent(@NotNull VirtualFile file2) {
        return UnknownFileType.INSTANCE;
    }

    @Nullable
    public FileType findFileTypeByName(@NotNull String fileTypeName) {
        return null;
    }
}

