/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.xml;

import com.intellij.codeInsight.unwrap.LanguageUnwrappers;
import com.intellij.codeInsight.unwrap.UnwrapDescriptor;
import com.intellij.codeInsight.unwrap.Unwrapper;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XmlEnclosingTagUnwrapper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class XmlUnwrapDescriptor
implements UnwrapDescriptor {
    @Override
    public List<Pair<PsiElement, Unwrapper>> collectUnwrappers(Project project2, Editor editor, PsiFile file2) {
        UnwrapDescriptor unwrapDescriptor;
        Language language;
        int offset = editor.getCaretModel().getOffset();
        PsiElement e1 = file2.findElementAt(offset);
        if (e1 != null && (language = e1.getParent().getLanguage()) != file2.getLanguage() && (unwrapDescriptor = (UnwrapDescriptor)LanguageUnwrappers.INSTANCE.forLanguage(language)) != null && !(unwrapDescriptor instanceof XmlUnwrapDescriptor)) {
            return unwrapDescriptor.collectUnwrappers(project2, editor, file2);
        }
        ArrayList<Pair<PsiElement, Unwrapper>> result = new ArrayList<Pair<PsiElement, Unwrapper>>();
        FileViewProvider viewProvider = file2.getViewProvider();
        for (Language language2 : viewProvider.getLanguages()) {
            UnwrapDescriptor unwrapDescriptor2 = (UnwrapDescriptor)LanguageUnwrappers.INSTANCE.forLanguage(language2);
            if (!(unwrapDescriptor2 instanceof XmlUnwrapDescriptor)) continue;
            PsiElement e = viewProvider.findElementAt(offset, language2);
            PsiElement tag = PsiTreeUtil.getParentOfType((PsiElement)e, XmlTag.class);
            while (tag != null) {
                if (XmlChildRole.START_TAG_NAME_FINDER.findChild(tag.getNode()) != null) {
                    result.add((Pair<PsiElement, Unwrapper>)new Pair((Object)tag, (Object)new XmlEnclosingTagUnwrapper()));
                }
                tag = PsiTreeUtil.getParentOfType((PsiElement)tag, XmlTag.class);
            }
        }
        Collections.sort(result, new Comparator<Pair<PsiElement, Unwrapper>>(){

            @Override
            public int compare(Pair<PsiElement, Unwrapper> o1, Pair<PsiElement, Unwrapper> o2) {
                return ((PsiElement)o2.first).getTextOffset() - ((PsiElement)o1.first).getTextOffset();
            }
        });
        return result;
    }

    @Override
    public boolean showOptionsDialog() {
        return true;
    }

    @Override
    public boolean shouldTryToRestoreCaretPosition() {
        return false;
    }
}

