/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.boilerplate;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.lang.javascript.boilerplate.GithubDownloadUtil;
import com.intellij.lang.javascript.boilerplate.GithubProjectGeneratorPeer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.templates.github.GeneratorException;
import com.intellij.platform.templates.github.GithubTagInfo;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GithubTagListProvider {
    private static final Logger LOG = Logger.getInstance(GithubTagListProvider.class);
    private final String myUserName;
    private final String myRepositoryName;

    public GithubTagListProvider(@NotNull String userName, @NotNull String repositoryName) {
        this.myUserName = userName;
        this.myRepositoryName = repositoryName;
    }

    @Nullable
    public ImmutableSet<GithubTagInfo> getCachedTags() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        File cacheFile = this.getTagsCacheFile();
        if (cacheFile.isFile()) {
            try {
                ImmutableSet<GithubTagInfo> tags = this.readTagsFromFile(cacheFile);
                LOG.info(this.getGeneratorName() + "tag info list has been successfully read from cache file " + cacheFile.getAbsolutePath());
                return tags;
            }
            catch (GeneratorException e) {
                LOG.warn("Can't read cache file " + cacheFile.getAbsolutePath(), (Throwable)e);
            }
        }
        return null;
    }

    public void updateTagListAsynchronously(@NotNull GithubProjectGeneratorPeer peer) {
        Runnable action = this.createUpdateTagListAction(peer);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            action.run();
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(action);
        }
    }

    private Runnable createUpdateTagListAction(final @NotNull GithubProjectGeneratorPeer peer) {
        return new Runnable(){

            @Override
            public void run() {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    peer.onTagsUpdated(Collections.emptySet());
                    return;
                }
                String[] urls = GithubTagListProvider.this.formatTagListDownloadUrls();
                String firstErrorMessage = null;
                for (String url : urls) {
                    String errorMessage;
                    try {
                        final ImmutableSet tags = GithubTagListProvider.this.fetchGithubTagsByUrl(url);
                        LOG.info(GithubTagListProvider.this.getGeneratorName() + "Cache has been successfully updated");
                        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                peer.onTagsUpdated((Set<GithubTagInfo>)tags);
                            }
                        });
                        return;
                    }
                    catch (IOException e) {
                        errorMessage = "Can not fetch tags from " + url;
                        LOG.warn(GithubTagListProvider.this.getGeneratorName() + errorMessage, (Throwable)e);
                    }
                    catch (GeneratorException e) {
                        errorMessage = "Malformed JSON received from " + url;
                        LOG.warn(GithubTagListProvider.this.getGeneratorName() + errorMessage, (Throwable)e);
                    }
                    if (firstErrorMessage != null) continue;
                    firstErrorMessage = errorMessage;
                }
                if (firstErrorMessage != null) {
                    peer.onTagsUpdateError(firstErrorMessage);
                }
            }
        };
    }

    private ImmutableSet<GithubTagInfo> fetchGithubTagsByUrl(@NotNull String url) throws IOException, GeneratorException {
        LOG.info(this.getGeneratorName() + "starting cache update from " + url + " ...");
        File cacheFile = this.getTagsCacheFile();
        GithubDownloadUtil.downloadAtomically(null, url, cacheFile, this.myUserName, this.myRepositoryName);
        return this.readTagsFromFile(cacheFile);
    }

    private String getGeneratorName() {
        return "[" + this.myUserName + "/" + this.myRepositoryName + "] ";
    }

    @NotNull
    private ImmutableSet<GithubTagInfo> readTagsFromFile(@NotNull File file2) throws GeneratorException {
        String content;
        try {
            content = Files.toString((File)file2, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new GeneratorException("Can not read '" + file2.getAbsolutePath() + "'!", e);
        }
        try {
            return GithubTagListProvider.parseContent(content);
        }
        catch (GeneratorException e) {
            String message = String.format("%s parsing version list failed: %s\n%s", this.getGeneratorName(), e.getMessage(), content);
            LOG.info(message, (Throwable)e);
            throw e;
        }
    }

    @NotNull
    private static ImmutableSet<GithubTagInfo> parseContent(@NotNull String tagFileContent) throws GeneratorException {
        JsonElement jsonElement;
        if (tagFileContent.trim().isEmpty()) {
            throw new GeneratorException("Can not parse fetched version list: got empty response");
        }
        try {
            JsonParser jsonParser = new JsonParser();
            jsonElement = jsonParser.parse(tagFileContent);
        }
        catch (Exception e) {
            throw new GeneratorException("Can not parse fetched version list: malformed JSON was received");
        }
        return GithubTagListProvider.toGithubTagList(jsonElement);
    }

    @NotNull
    private static ImmutableSet<GithubTagInfo> toGithubTagList(@NotNull JsonElement jsonElement) throws GeneratorException {
        if (jsonElement instanceof JsonArray) {
            JsonArray array = (JsonArray)jsonElement;
            ImmutableSet.Builder tags = ImmutableSet.builder();
            for (JsonElement element : array) {
                if (element instanceof JsonObject) {
                    JsonObject obj = (JsonObject)element;
                    JsonElement nameElement = obj.get("name");
                    String name = null;
                    if (nameElement != null) {
                        name = nameElement.getAsString();
                    }
                    String zipball = null;
                    JsonElement zipballElement = obj.get("zipball_url");
                    if (zipballElement != null) {
                        zipball = zipballElement.getAsString();
                    }
                    if (name == null || zipball == null) continue;
                    tags.add((Object)new GithubTagInfo(name, zipball));
                    continue;
                }
                throw new GeneratorException("Unexpected child element " + element.getClass().getName());
            }
            return tags.build();
        }
        throw new GeneratorException("jsonElement is expected be instance of " + JsonArray.class.getName());
    }

    @NotNull
    private File getTagsCacheFile() {
        File dir = GithubDownloadUtil.getCacheDir(this.myUserName, this.myRepositoryName);
        return new File(dir, "tags.json");
    }

    @NotNull
    private String[] formatTagListDownloadUrls() {
        return new String[]{"https://api.github.com/repos/" + this.myUserName + "/" + this.myRepositoryName + "/tags", "http://download.jetbrains.com/idea/project_templates/github-tags/" + this.myUserName + "-" + this.myRepositoryName + "-tags.json"};
    }
}

