/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java;

import com.intellij.lang.ImportOptimizer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaImportOptimizer
implements ImportOptimizer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.java.JavaImportOptimizer");

    @NotNull
    public Runnable processFile(final PsiFile file2) {
        if (!(file2 instanceof PsiJavaFile)) {
            return EmptyRunnable.getInstance();
        }
        Project project2 = file2.getProject();
        final PsiImportList newImportList = JavaCodeStyleManager.getInstance((Project)project2).prepareOptimizeImportsResult((PsiJavaFile)file2);
        if (newImportList == null) {
            return EmptyRunnable.getInstance();
        }
        return new ImportOptimizer.CollectingInfoRunnable(){
            private int myImportListLengthDiff = 0;

            public void run() {
                try {
                    PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)file2.getProject());
                    Document document = manager.getDocument(file2);
                    if (document != null) {
                        manager.commitDocument(document);
                    }
                    PsiImportList oldImportList = ((PsiJavaFile)file2).getImportList();
                    assert (oldImportList != null);
                    int importsBefore = oldImportList.getAllImportStatements().length;
                    oldImportList.replace((PsiElement)newImportList);
                    this.myImportListLengthDiff = importsBefore - newImportList.getAllImportStatements().length;
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }

            @Nullable
            public String getUserNotificationInfo() {
                if (this.myImportListLengthDiff > 0) {
                    return "removed " + this.myImportListLengthDiff + " import" + (this.myImportListLengthDiff > 1 ? "s" : "");
                }
                return null;
            }
        };
    }

    public boolean supports(PsiFile file2) {
        return file2 instanceof PsiJavaFile;
    }
}

